/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.core.contentassist;

import java.util.ArrayList;
import org.aspectj.asm.IProgramElement;
import org.eclipse.ajdt.core.codeconversion.AspectsConvertingParser;
import org.eclipse.ajdt.core.codeconversion.JavaCompatibleBuffer;
import org.eclipse.ajdt.core.model.AJWorldFacade;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.compiler.IProblem;

public class ProposalRequestorWrapper
extends CompletionRequestor {
    CompletionRequestor wrapped;
    ArrayList insertionTable;
    private AJWorldFacade world;
    private ICompilationUnit unit;

    public ProposalRequestorWrapper(CompletionRequestor wrapped, ICompilationUnit unit, JavaCompatibleBuffer buffer) {
        this.wrapped = wrapped;
        this.unit = unit;
        this.insertionTable = buffer.getInsertionTable();
    }

    public ProposalRequestorWrapper(CompletionRequestor wrapped, ICompilationUnit unit, ArrayList insertionTable) {
        this.wrapped = wrapped;
        this.unit = unit;
        this.insertionTable = insertionTable;
    }

    public void accept(CompletionProposal proposal) {
        if (!this.shouldAccept(proposal)) {
            return;
        }
        int s = proposal.getReplaceStart();
        int e = proposal.getReplaceEnd();
        proposal.setReplaceRange(this.trans(s), this.trans(e));
        this.wrapped.accept(proposal);
    }

    protected boolean shouldAccept(CompletionProposal proposal) {
        if (proposal.getKind() == 2 || proposal.getKind() == 6) {
            AJWorldFacade.ITDInfo info;
            if (this.world == null) {
                this.world = new AJWorldFacade(this.unit.getJavaProject().getProject());
            }
            if ((info = this.world.findITDInfoIfExists(proposal.getDeclarationSignature(), proposal.getName())) != null) {
                if (info.accessibility == IProgramElement.Accessibility.PUBLIC) {
                    return true;
                }
                if (info.accessibility == IProgramElement.Accessibility.PACKAGE) {
                    if (((IPackageFragment)this.unit.getParent()).getElementName().equals(info.packageDeclaredIn)) {
                        int oldFlags = proposal.getFlags();
                        oldFlags |= 0;
                        proposal.setFlags(oldFlags &= 0xFFFFFFFE);
                        return true;
                    }
                } else if (info.accessibility == IProgramElement.Accessibility.PRIVATE && this.unit.getElementName().startsWith(String.valueOf(info.topLevelAspectName) + ".") && ((IPackageFragment)this.unit.getParent()).getElementName().equals(info.packageDeclaredIn)) {
                    int oldFlags = proposal.getFlags();
                    oldFlags |= 2;
                    proposal.setFlags(oldFlags &= 0xFFFFFFFE);
                    return true;
                }
                return false;
            }
            return true;
        }
        return true;
    }

    private int trans(int pos) {
        return AspectsConvertingParser.translatePositionToBeforeChanges(pos, this.insertionTable);
    }

    public void acceptContext(CompletionContext context) {
        this.wrapped.acceptContext(context);
    }

    public void endReporting() {
        this.wrapped.endReporting();
    }

    public void beginReporting() {
        this.wrapped.beginReporting();
    }

    public void completionFailure(IProblem problem) {
        this.wrapped.completionFailure(problem);
    }

    public boolean equals(Object obj) {
        return this.wrapped.equals(obj);
    }

    public int hashCode() {
        return this.wrapped.hashCode();
    }

    public String toString() {
        return this.wrapped.toString();
    }
}

