/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.core;

import java.lang.reflect.Field;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.internal.core.ras.CoreFFDC;
import org.eclipse.jdt.internal.core.util.MementoTokenizer;

public class AJMementoTokenizer
extends MementoTokenizer {
    private static final String COUNT;
    private static final String JAVAPROJECT;
    private static final String PACKAGEFRAGMENTROOT;
    private static final String PACKAGEFRAGMENT;
    private static final String FIELD;
    private static final String METHOD;
    private static final String INITIALIZER;
    private static final String COMPILATIONUNIT;
    private static final String CLASSFILE;
    private static final String TYPE;
    private static final String PACKAGEDECLARATION;
    private static final String IMPORTDECLARATION;
    private static final String LOCALVARIABLE;
    private static final String ASPECT_CU;
    private static final String TYPE_PARAMETER;
    private static final String ADVICE;
    private static final String ASPECT_TYPE;
    private static final String CODEELEMENT;
    private static final String ITD;
    private static final String DECLARE;
    private static final String POINTCUT;
    private final char[] memento;
    private final int length;
    private int index = 0;
    private static Field mementoField;
    private static Field indexField;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;

    static {
        Factory factory = new Factory("AJMementoTokenizer.java", Class.forName("org.eclipse.ajdt.core.AJMementoTokenizer"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.AJMementoTokenizer", "java.lang.Exception:", "<missing>:"), 103);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("a", "getMemento", "org.eclipse.ajdt.core.AJMementoTokenizer", "org.eclipse.jdt.internal.core.util.MementoTokenizer:", "tokenizer:", "", "[C"), 98);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.AJMementoTokenizer", "java.lang.IllegalArgumentException:", "<missing>:"), 109);
        ajc$tjp_3 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.AJMementoTokenizer", "java.lang.IllegalAccessException:", "<missing>:"), 110);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.AJMementoTokenizer", "java.lang.Exception:", "<missing>:"), 128);
        ajc$tjp_5 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("a", "setIndex", "org.eclipse.ajdt.core.AJMementoTokenizer", "org.eclipse.jdt.internal.core.util.MementoTokenizer:int:", "tokenizer:val:", "", "void"), 123);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.AJMementoTokenizer", "java.lang.IllegalArgumentException:", "<missing>:"), 133);
        ajc$tjp_7 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.AJMementoTokenizer", "java.lang.IllegalAccessException:", "<missing>:"), 134);
        COUNT = Character.toString('!');
        JAVAPROJECT = Character.toString('=');
        PACKAGEFRAGMENTROOT = Character.toString('/');
        PACKAGEFRAGMENT = Character.toString('<');
        FIELD = Character.toString('^');
        METHOD = Character.toString('~');
        INITIALIZER = Character.toString('|');
        COMPILATIONUNIT = Character.toString('{');
        CLASSFILE = Character.toString('(');
        TYPE = Character.toString('[');
        PACKAGEDECLARATION = Character.toString('%');
        IMPORTDECLARATION = Character.toString('#');
        LOCALVARIABLE = Character.toString('@');
        ASPECT_CU = Character.toString('*');
        TYPE_PARAMETER = Character.toString(']');
        ADVICE = Character.toString('&');
        ASPECT_TYPE = Character.toString('}');
        CODEELEMENT = Character.toString('?');
        ITD = Character.toString(')');
        DECLARE = Character.toString('`');
        POINTCUT = Character.toString('+');
    }

    public AJMementoTokenizer(String memento) {
        super(memento);
        this.memento = memento.toCharArray();
        this.length = this.memento.length;
    }

    public AJMementoTokenizer(MementoTokenizer tokenizer) {
        super(String.valueOf(AJMementoTokenizer.getMemento(tokenizer)));
        this.memento = AJMementoTokenizer.getMemento(tokenizer);
        this.length = this.memento.length;
        this.index = AJMementoTokenizer.getIndex(new String(this.memento));
        AJMementoTokenizer.setIndex(this, this.index);
    }

    private static char[] getMemento(MementoTokenizer tokenizer) {
        if (mementoField == null) {
            try {
                mementoField = MementoTokenizer.class.getDeclaredField("memento");
                mementoField.setAccessible(true);
            }
            catch (Exception exception) {
                CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$1$31280822(exception, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
                return null;
            }
        }
        try {
            return (char[])mementoField.get(tokenizer);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$1$31280822(illegalArgumentException, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_1);
        }
        catch (IllegalAccessException illegalAccessException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$1$31280822(illegalAccessException, ajc$tjp_3, (JoinPoint.StaticPart)ajc$tjp_1);
        }
        return null;
    }

    private static int getIndex(String memento) {
        return Math.max(memento.indexOf(125), memento.indexOf(91));
    }

    private static void setIndex(MementoTokenizer tokenizer, int val) {
        if (indexField == null) {
            try {
                indexField = MementoTokenizer.class.getDeclaredField("index");
                indexField.setAccessible(true);
            }
            catch (Exception exception) {
                CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$1$31280822(exception, ajc$tjp_4, (JoinPoint.StaticPart)ajc$tjp_5);
            }
        }
        try {
            indexField.setInt(tokenizer, val);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$1$31280822(illegalArgumentException, ajc$tjp_6, (JoinPoint.StaticPart)ajc$tjp_5);
        }
        catch (IllegalAccessException illegalAccessException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$1$31280822(illegalAccessException, ajc$tjp_7, (JoinPoint.StaticPart)ajc$tjp_5);
        }
    }

    void setIndexTo(int newIndex) {
        this.index = newIndex;
    }

    public boolean hasMoreTokens() {
        return this.index < this.length;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String nextToken() {
        int start = this.index;
        StringBuffer buffer = null;
        switch (this.memento[this.index++]) {
            case '\\': {
                buffer = new StringBuffer();
                buffer.append(this.memento[this.index]);
                start = ++this.index;
                break;
            }
            case '!': {
                return COUNT;
            }
            case '=': {
                return JAVAPROJECT;
            }
            case '/': {
                return PACKAGEFRAGMENTROOT;
            }
            case '<': {
                return PACKAGEFRAGMENT;
            }
            case '^': {
                return FIELD;
            }
            case '~': {
                return METHOD;
            }
            case '|': {
                return INITIALIZER;
            }
            case '{': {
                return COMPILATIONUNIT;
            }
            case '(': {
                return CLASSFILE;
            }
            case '[': {
                return TYPE;
            }
            case '%': {
                return PACKAGEDECLARATION;
            }
            case '#': {
                return IMPORTDECLARATION;
            }
            case '@': {
                return LOCALVARIABLE;
            }
            case '*': {
                return ASPECT_CU;
            }
            case ']': {
                return TYPE_PARAMETER;
            }
            case '&': {
                return ADVICE;
            }
            case '}': {
                return ASPECT_TYPE;
            }
            case '?': {
                return CODEELEMENT;
            }
            case ')': {
                return ITD;
            }
            case '`': {
                return DECLARE;
            }
            case '+': {
                return POINTCUT;
            }
        }
        block28: while (this.index < this.length) {
            switch (this.memento[this.index]) {
                case '\\': {
                    if (buffer == null) {
                        buffer = new StringBuffer();
                    }
                    buffer.append(this.memento, start, this.index - start);
                    start = ++this.index;
                    break;
                }
                case '!': 
                case '#': 
                case '%': 
                case '&': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '/': 
                case '<': 
                case '=': 
                case '?': 
                case '@': 
                case '[': 
                case ']': 
                case '^': 
                case '`': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    break block28;
                }
            }
            ++this.index;
        }
        if (buffer != null) {
            buffer.append(this.memento, start, this.index - start);
            return buffer.toString();
        }
        return new String(this.memento, start, this.index - start);
    }
}

