/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.jdt.preferences;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import org.eclipse.contribution.jdt.IsWovenTester;
import org.eclipse.contribution.jdt.JDTWeavingPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.DisabledInfo;
import org.eclipse.osgi.service.resolver.State;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class WeavingStateConfigurer {
    private static final Version MIN_WEAVER_VERSION = new Version(1, 6, 1);
    private static final boolean IS_WEAVING = IsWovenTester.isWeavingActive();

    public String getWeaverVersionInfo() {
        BundleDescription weaver = Platform.getPlatformAdmin().getState(false).getBundle("org.aspectj.weaver", null);
        if (weaver != null) {
            if (MIN_WEAVER_VERSION.compareTo((Object)weaver.getVersion()) <= 0) {
                return "";
            }
            return "No compatible version of org.aspectj.weaver found.  JDT Weaving requires 1.6.1 or higher.  Found version " + weaver.getVersion();
        }
        return "org.aspectj.weaver not installed.  JDT Weaving requires 1.6.3 or higher.";
    }

    public IStatus changeWeavingState(boolean becomeEnabled) {
        boolean isCurrentlyWeaving = false;
        try {
            isCurrentlyWeaving = this.currentConfigStateIsWeaving();
        }
        catch (Exception e) {
            JDTWeavingPlugin.logException(e);
        }
        IStatus success = becomeEnabled && !isCurrentlyWeaving ? this.changeConfigDotIni(becomeEnabled) : Status.OK_STATUS;
        IStatus success2 = this.changeAutoStartupAspectsBundle(becomeEnabled);
        if (success != Status.OK_STATUS || success2 != Status.OK_STATUS) {
            return new MultiStatus(JDTWeavingPlugin.ID, 4, new IStatus[]{success, success2}, "Could not " + (becomeEnabled ? "ENABLED" : "DISABLED") + " weaving service", null);
        }
        return new Status(0, JDTWeavingPlugin.ID, "Weaving service successfully " + (becomeEnabled ? "ENABLED" : "DISABLED"));
    }

    private IStatus changeAutoStartupAspectsBundle(boolean becomeEnabled) {
        Bundle[] allEABundles = Platform.getBundles((String)"org.eclipse.equinox.weaving.aspectj", null);
        if (allEABundles == null || allEABundles.length == 0) {
            return new Status(4, JDTWeavingPlugin.ID, "Could not find org.eclipse.equinox.weaving.aspectj so weaving service cannot be " + (becomeEnabled ? "enabled" : "disabled") + ".");
        }
        try {
            State state = Platform.getPlatformAdmin().getState(false);
            if (becomeEnabled) {
                allEABundles[0].start();
                int i = 1;
                while (i < allEABundles.length) {
                    allEABundles[i].stop();
                    BundleDescription desc = state.getBundle(allEABundles[i].getBundleId());
                    DisabledInfo info = new DisabledInfo("org.eclipse.contribution.weaving.jdt", "Disabled older version of Equinox Aspects", desc);
                    try {
                        Platform.getPlatformAdmin().addDisabledInfo(info);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                    ++i;
                }
            } else {
                int i = 0;
                while (i < allEABundles.length) {
                    switch (allEABundles[i].getState()) {
                        case 2: 
                        case 4: 
                        case 8: 
                        case 32: {
                            allEABundles[i].stop();
                        }
                    }
                    ++i;
                }
            }
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            return new Status(4, JDTWeavingPlugin.ID, "Error occurred in setting org.eclipse.equinox.weaving.aspectj to autostart so weaving service cannot be " + (becomeEnabled ? "enabled" : "disabled") + ".", (Throwable)e);
        }
    }

    private IStatus changeConfigDotIni(boolean becomeEnabled) {
        Object success;
        try {
            String configArea = this.getConfigArea();
            File f = new File(new URI(configArea));
            BufferedReader br = new BufferedReader(new FileReader(f));
            String newConfig = this.internalChangeWeavingState(becomeEnabled, br);
            BufferedWriter bw = new BufferedWriter(new FileWriter(f));
            bw.write(newConfig);
            bw.close();
            success = becomeEnabled == this.currentConfigStateIsWeaving() ? Status.OK_STATUS : new Status(4, JDTWeavingPlugin.ID, "Could not add or remove org.eclipse.equinox.weaving.hook as a framework adaptor.");
        }
        catch (Exception e) {
            success = new Status(4, JDTWeavingPlugin.ID, e.getMessage(), (Throwable)e);
        }
        return success;
    }

    protected String internalChangeWeavingState(boolean becomeEnabled, BufferedReader br) throws IOException {
        StringBuffer sb = new StringBuffer();
        String line = null;
        boolean hookAdded = false;
        while ((line = br.readLine()) != null) {
            if (line.trim().startsWith("osgi.framework.extensions=")) {
                String[] split = line.split("=");
                if (split.length <= 1) continue;
                String[] extNames = split[1].split(",");
                boolean shouldAddLine = false;
                StringBuffer sb2 = new StringBuffer();
                sb2.append("osgi.framework.extensions=");
                int i = 0;
                while (i < extNames.length) {
                    String extName = extNames[i].trim();
                    if (!extName.equals("org.eclipse.equinox.weaving.hook")) {
                        sb2.append(String.valueOf(extName) + ",");
                        shouldAddLine = true;
                    }
                    ++i;
                }
                if (!shouldAddLine) continue;
                if (becomeEnabled) {
                    sb2.append("org.eclipse.equinox.weaving.hook\n");
                    hookAdded = true;
                } else {
                    sb2.replace(sb2.length() - 1, sb2.length(), "\n");
                }
                sb.append(sb2);
                continue;
            }
            sb.append(String.valueOf(line) + "\n");
        }
        if (becomeEnabled && !hookAdded) {
            sb.append("osgi.framework.extensions=org.eclipse.equinox.weaving.hook\n");
        }
        try {
            br.close();
        }
        catch (IOException e) {
            JDTWeavingPlugin.logException(e);
        }
        return sb.toString();
    }

    private String getConfigArea() {
        String configArea = String.valueOf(FrameworkProperties.getProperty((String)"osgi.configuration.area")) + "config.ini";
        configArea = configArea.replaceAll(" ", "%20");
        return configArea;
    }

    public boolean currentConfigStateIsWeaving() throws Exception {
        String configArea = this.getConfigArea();
        File f = new File(new URI(configArea));
        if (!f.exists()) {
            throw new FileNotFoundException("Could not find config file: " + f.getAbsolutePath());
        }
        if (!f.canWrite()) {
            throw new IOException("Could not write to config file: " + f.getAbsolutePath());
        }
        BufferedReader br = new BufferedReader(new FileReader(f));
        return this.internalCurrentConfigStateIsWeaving(br);
    }

    protected boolean internalCurrentConfigStateIsWeaving(BufferedReader br) throws IOException {
        String line = null;
        while ((line = br.readLine()) != null) {
            if (!line.trim().startsWith("osgi.framework.extensions=") || !line.contains("org.eclipse.equinox.weaving.hook")) continue;
            return true;
        }
        return false;
    }

    public boolean isWeaving() {
        return IS_WEAVING;
    }
}

