/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AJLog;
import org.eclipse.ajdt.core.AspectJCorePreferences;
import org.eclipse.ajdt.internal.launching.LaunchConfigurationManagementUtils;
import org.eclipse.ajdt.internal.ui.ajde.AJDTErrorHandler;
import org.eclipse.ajdt.internal.ui.preferences.PreferencePageBuilder;
import org.eclipse.ajdt.internal.ui.ras.UIFFDC;
import org.eclipse.ajdt.internal.ui.text.UIMessages;
import org.eclipse.ajdt.internal.ui.wizards.AspectPathBlock;
import org.eclipse.ajdt.internal.ui.wizards.InPathBlock;
import org.eclipse.ajdt.internal.ui.wizards.PathBlock;
import org.eclipse.ajdt.internal.ui.wizards.TabFolderLayout;
import org.eclipse.ajdt.internal.utils.AJDTUtils;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.ClasspathAttribute;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.launching.JREContainer;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathBasePage;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.progress.UIJob;

public class AspectJProjectPropertiesPage
extends PropertyPage
implements IStatusChangeListener {
    private static final String INDEX = "pageIndex";
    private int fPageIndex;
    private static final String PAGE_SETTINGS = "AspectJBuildPropertyPage";
    public static final String PROP_ID = "org.eclipse.ajdt.internal.ui.AspectJProjectPropertiesPage";
    private StringFieldEditor outputJarEditor;
    private IProject thisProject;
    private BuildPathBasePage fCurrPage;
    private InPathBlock fInPathBlock;
    private AspectPathBlock fAspectPathBlock;
    private boolean testing = false;
    private long fFileTimeStamp;
    private PageChangeListener fListener;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_6;

    protected Control createContents(Composite parent) {
        PreferencePageBuilder.aspectOf().ajc$before$org_eclipse_ajdt_internal_ui_preferences_PreferencePageBuilder$1$ce66e616((IWorkbenchPropertyPage)this);
        this.noDefaultAndApplyButton();
        this.thisProject = this.getProject();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        TabFolder folder = new TabFolder(composite, 0);
        folder.setLayout((Layout)new TabFolderLayout());
        folder.setLayoutData((Object)new GridData(1808));
        this.fInPathBlock = new InPathBlock(this, 0);
        this.fInPathBlock.tabContent(folder);
        this.fAspectPathBlock = new AspectPathBlock(this, 0);
        this.fAspectPathBlock.tabContent(folder);
        this.resetPathBlocks();
        TabItem item = new TabItem(folder, 0);
        item.setText(UIMessages.compilerPropsPage_outputJar);
        item.setControl((Control)this.outputTab((Composite)folder));
        folder.setSelection(this.fPageIndex);
        this.fCurrPage = (BuildPathBasePage)folder.getItem(this.fPageIndex).getData();
        folder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AspectJProjectPropertiesPage.this.tabChanged(e.item);
            }
        });
        this.initializeTimeStamps();
        this.updatePageContents();
        this.fListener = new PageChangeListener();
        this.getControl().addListener(23, (Listener)this.fListener);
        this.thisProject.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.fListener, 1);
        return composite;
    }

    private void resetPathBlocks() {
        IClasspathEntry[] initalInpath = null;
        try {
            initalInpath = this.getInitialPathValue(this.thisProject, AspectJCorePreferences.INPATH_ATTRIBUTE);
        }
        catch (CoreException coreException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
            CoreException ce = coreException;
            AJDTErrorHandler.handleAJDTError(UIMessages.InPathProp_exceptionInitializingInpath_title, UIMessages.InPathProp_exceptionInitializingInpath_message, ce);
        }
        this.fInPathBlock.init(JavaCore.create((IProject)this.thisProject), initalInpath);
        IClasspathEntry[] initialAspectpath = null;
        try {
            initialAspectpath = this.getInitialPathValue(this.thisProject, AspectJCorePreferences.ASPECTPATH_ATTRIBUTE);
        }
        catch (CoreException coreException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_1);
            CoreException ce = coreException;
            AJDTErrorHandler.handleAJDTError(UIMessages.AspectPathProp_exceptionInitializingAspectpath_title, UIMessages.AspectPathProp_exceptionInitializingAspectpath_message, ce);
        }
        this.fAspectPathBlock.init(JavaCore.create((IProject)this.thisProject), initialAspectpath);
    }

    private IClasspathEntry[] getInitialPathValue(IProject project, IClasspathAttribute attribute) throws CoreException {
        ArrayList<IClasspathEntry> newPath = new ArrayList<IClasspathEntry>();
        IJavaProject jProject = JavaCore.create((IProject)project);
        boolean isAspectPath = AspectJCorePreferences.isAspectPathAttribute((IClasspathAttribute)attribute);
        try {
            IClasspathEntry[] entries = jProject.getRawClasspath();
            int i = 0;
            while (i < entries.length) {
                if (AspectJCorePreferences.isOnPath((IClasspathEntry)entries[i], (boolean)isAspectPath)) {
                    newPath.add(entries[i]);
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_3, (JoinPoint.StaticPart)ajc$tjp_4);
        }
        newPath.addAll(this.getEntriesInContainers(project, attribute));
        if (newPath.size() > 0) {
            return newPath.toArray(new IClasspathEntry[0]);
        }
        return null;
    }

    protected List getEntriesInContainers(IProject project, IClasspathAttribute attribute) {
        try {
            IJavaProject jProject = JavaCore.create((IProject)project);
            IClasspathEntry[] allEntries = jProject.getRawClasspath();
            ArrayList<IClasspathEntry> entriesWithAttribute = new ArrayList<IClasspathEntry>();
            int i = 0;
            while (i < allEntries.length) {
                IClasspathContainer container;
                if (allEntries[i].getEntryKind() == 5 && (container = JavaCore.getClasspathContainer((IPath)allEntries[i].getPath(), (IJavaProject)jProject)) != null && !(container instanceof JREContainer)) {
                    IClasspathEntry[] containerEntries = container.getClasspathEntries();
                    int j = 0;
                    while (j < containerEntries.length) {
                        if (this.hasClasspathAttribute(containerEntries[j], attribute)) {
                            this.addContainerToAttribute(containerEntries[j], attribute, container);
                            entriesWithAttribute.add(containerEntries[j]);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            return entriesWithAttribute;
        }
        catch (JavaModelException javaModelException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_5, (JoinPoint.StaticPart)ajc$tjp_6);
            return Collections.EMPTY_LIST;
        }
    }

    private void addContainerToAttribute(IClasspathEntry classpathEntry, IClasspathAttribute attribute, IClasspathContainer container) {
        IClasspathAttribute[] attributes = classpathEntry.getExtraAttributes();
        int i = 0;
        while (i < attributes.length) {
            if (attributes[i].getName().equals(attribute.getName())) {
                attributes[i] = new ClasspathAttribute(attribute.getName(), container.getPath().toPortableString());
            }
            ++i;
        }
    }

    private boolean hasClasspathAttribute(IClasspathEntry entry, IClasspathAttribute attribute) {
        IClasspathAttribute[] allAttributes = entry.getExtraAttributes();
        int i = 0;
        while (i < allAttributes.length) {
            if (allAttributes[i].getName().equals(attribute.getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Composite outputTab(Composite composite) {
        Composite pageComposite = this.createPageComposite(composite, 3);
        Composite row0Composite = this.createRowComposite(pageComposite, 1);
        Label title = new Label(row0Composite, 16448);
        title.setText(UIMessages.compilerPropsPage_description);
        Composite row3Comp = this.createRowComposite(pageComposite, 2);
        this.outputJarEditor = new StringFieldEditor("", UIMessages.compilerPropsPage_outputJar, row3Comp);
        return pageComposite;
    }

    private Composite createPageComposite(Composite parent, int numColumns) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        layout.makeColumnsEqualWidth = true;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        return composite;
    }

    private Composite createRowComposite(Composite parent, int numColumns) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        layout.makeColumnsEqualWidth = true;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.horizontalSpan = 3;
        composite.setLayoutData((Object)data);
        return composite;
    }

    private boolean checkIfOnInpath(IProject project, String outJarStr) {
        String[] oldInpath = AspectJCorePreferences.getRawProjectInpath((IProject)project);
        String[] seperatedOldInpath = oldInpath[0].split(";");
        String outJar = String.valueOf('/') + this.thisProject.getName() + '/' + outJarStr;
        int j = 0;
        while (j < seperatedOldInpath.length) {
            if (seperatedOldInpath[j].equals(outJar) && !seperatedOldInpath[j].equals("")) {
                return true;
            }
            ++j;
        }
        return false;
    }

    private boolean checkIfOnAspectpath(IProject project, String string) {
        String[] oldAspectpath = AspectJCorePreferences.getRawProjectAspectPath((IProject)project);
        String[] seperatedOldAspectpath = oldAspectpath[0].split(";");
        String outJar = String.valueOf('/') + this.thisProject.getName() + '/' + string;
        int j = 0;
        while (j < seperatedOldAspectpath.length) {
            if (seperatedOldAspectpath[j].equals(outJar) && !seperatedOldAspectpath[j].equals("")) {
                return true;
            }
            ++j;
        }
        return false;
    }

    public void performApply() {
        PreferencePageBuilder.ajc$cflowCounter$0.inc();
        try {
            this.commit();
            if (!PreferencePageBuilder.ajc$cflowCounter$0.isValid()) {
                PreferencePageBuilder.aspectOf().ajc$afterReturning$org_eclipse_ajdt_internal_ui_preferences_PreferencePageBuilder$7$d61cf77c((IWorkbenchPropertyPage)this);
            }
            if (PreferencePageBuilder.ajc$cflowCounter$0.isValid()) {
                PreferencePageBuilder.aspectOf().ajc$afterReturning$org_eclipse_ajdt_internal_ui_preferences_PreferencePageBuilder$8$a1481a1f((IWorkbenchPropertyPage)this);
            }
        }
        finally {
            PreferencePageBuilder.ajc$cflowCounter$0.dec();
        }
    }

    public boolean performOk() {
        boolean bl = this.commit();
        if (!PreferencePageBuilder.ajc$cflowCounter$0.isValid()) {
            PreferencePageBuilder.aspectOf().ajc$afterReturning$org_eclipse_ajdt_internal_ui_preferences_PreferencePageBuilder$7$d61cf77c((IWorkbenchPropertyPage)this);
        }
        boolean bl2 = bl;
        if (PreferencePageBuilder.ajc$cflowCounter$0.isValid()) {
            PreferencePageBuilder.aspectOf().ajc$afterReturning$org_eclipse_ajdt_internal_ui_preferences_PreferencePageBuilder$8$a1481a1f((IWorkbenchPropertyPage)this);
        }
        return bl2;
    }

    private boolean commit() {
        this.thisProject.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.fListener);
        try {
            String oldOutJar = AspectJCorePreferences.getProjectOutJar((IProject)this.thisProject);
            ClasspathEntry oldEntry = null;
            if (oldOutJar != null && !oldOutJar.equals("")) {
                oldEntry = new ClasspathEntry(2, 1, new Path(String.valueOf(this.thisProject.getName()) + '/' + oldOutJar).makeAbsolute(), new IPath[0], new IPath[0], null, null, null, false, null, false, new IClasspathAttribute[0]);
            }
            String outJar = this.outputJarEditor.getStringValue();
            ClasspathEntry newEntry = null;
            if (outJar != null && !outJar.equals("")) {
                newEntry = new ClasspathEntry(2, 1, new Path(String.valueOf(this.thisProject.getName()) + '/' + outJar).makeAbsolute(), new IPath[0], new IPath[0], null, null, null, false, null, false, new IClasspathAttribute[0]);
            }
            if (this.checkIfOnInpath(this.thisProject, outJar) || this.checkIfOnAspectpath(this.thisProject, outJar)) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)UIMessages.buildpathwarning_title, (String)UIMessages.buildConfig_invalidOutjar);
                String string = oldOutJar;
                StringFieldEditor stringFieldEditor = this.outputJarEditor;
                PreferencePageBuilder.aspectOf().ajc$before$org_eclipse_ajdt_internal_ui_preferences_PreferencePageBuilder$5$2f71f9b9(stringFieldEditor, string, (IWorkbenchPropertyPage)this);
                stringFieldEditor.setStringValue(string);
            } else {
                LaunchConfigurationManagementUtils.updateOutJar(JavaCore.create((IProject)this.thisProject), oldEntry, newEntry);
                AspectJCorePreferences.setProjectOutJar((IProject)this.thisProject, (String)this.outputJarEditor.getStringValue());
            }
            if (this.fInPathBlock != null && this.fInPathBlock.hasChangesInDialog()) {
                new ConfigurePathBlockJob(this.fInPathBlock).schedule();
                this.getSettings().put(INDEX, this.fInPathBlock.getPageIndex());
                AspectJCorePreferences.setProjectInpathOutFolder((IProject)this.getProject(), (String)this.fInPathBlock.getOutputFolder());
            }
            if (this.fAspectPathBlock != null && this.fAspectPathBlock.hasChangesInDialog()) {
                new ConfigurePathBlockJob(this.fAspectPathBlock).schedule();
                this.getSettings().put(INDEX, this.fAspectPathBlock.getPageIndex());
            }
            AJDTUtils.refreshPackageExplorer();
            this.initializeTimeStamps();
            return true;
        }
        finally {
            this.thisProject.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.fListener);
        }
    }

    protected IDialogSettings getSettings() {
        IDialogSettings pathSettings = AspectJUIPlugin.getDefault().getDialogSettings();
        IDialogSettings pageSettings = pathSettings.getSection(PAGE_SETTINGS);
        if (pageSettings == null) {
            pageSettings = pathSettings.addNewSection(PAGE_SETTINGS);
            pageSettings.put(INDEX, 2);
        }
        return pageSettings;
    }

    public void performDefaults() {
        AJLog.log((String)("Compiler properties reset to default for project: " + this.thisProject.getName()));
        String string = "";
        StringFieldEditor stringFieldEditor = this.outputJarEditor;
        PreferencePageBuilder.aspectOf().ajc$before$org_eclipse_ajdt_internal_ui_preferences_PreferencePageBuilder$5$2f71f9b9(stringFieldEditor, string, (IWorkbenchPropertyPage)this);
        stringFieldEditor.setStringValue(string);
    }

    public void updatePageContents() {
        String string = AspectJCorePreferences.getProjectOutJar((IProject)this.thisProject);
        StringFieldEditor stringFieldEditor = this.outputJarEditor;
        PreferencePageBuilder.aspectOf().ajc$before$org_eclipse_ajdt_internal_ui_preferences_PreferencePageBuilder$5$2f71f9b9(stringFieldEditor, string, (IWorkbenchPropertyPage)this);
        stringFieldEditor.setStringValue(string);
    }

    public IProject getThisProject() {
        return this.thisProject;
    }

    public void dispose() {
        PreferencePageBuilder.aspectOf().ajc$before$org_eclipse_ajdt_internal_ui_preferences_PreferencePageBuilder$2$24dea784((IWorkbenchPropertyPage)this);
        super.dispose();
        this.thisProject.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.fListener);
    }

    private IProject getProject() {
        if (this.testing) {
            return this.thisProject;
        }
        return (IProject)this.getElement();
    }

    public void setThisProject(IProject project) {
        this.thisProject = project;
    }

    public void setIsTesting(boolean isTesting) {
        this.testing = isTesting;
    }

    public void setOutjarValue(String outjar) {
        String string = outjar;
        StringFieldEditor stringFieldEditor = this.outputJarEditor;
        PreferencePageBuilder.aspectOf().ajc$before$org_eclipse_ajdt_internal_ui_preferences_PreferencePageBuilder$5$2f71f9b9(stringFieldEditor, string, (IWorkbenchPropertyPage)this);
        stringFieldEditor.setStringValue(string);
    }

    public String getOutjarValue() {
        return this.outputJarEditor.getStringValue();
    }

    public void statusChanged(IStatus status) {
        this.setValid(!status.matches(4));
        StatusUtil.applyToStatusLine((DialogPage)this, (IStatus)status);
    }

    protected void tabChanged(Widget widget) {
        if (this.hasChanges()) {
            this.commit();
        }
        if (widget instanceof TabItem) {
            List selection;
            TabItem tabItem = (TabItem)widget;
            BuildPathBasePage newPage = (BuildPathBasePage)tabItem.getData();
            if (this.fCurrPage != null && !(selection = this.fCurrPage.getSelection()).isEmpty()) {
                newPage.setSelection(selection, false);
            }
            this.fCurrPage = newPage;
            this.fPageIndex = tabItem.getParent().getSelectionIndex();
        }
    }

    private boolean hasChanges() {
        return this.fAspectPathBlock != null && this.fAspectPathBlock.hasChangesInDialog() || this.fInPathBlock != null && this.fInPathBlock.hasChangesInDialog();
    }

    public boolean hasChangesInClasspathFile() {
        IFile file = this.thisProject.getFile(".classpath");
        return this.fFileTimeStamp != file.getModificationStamp();
    }

    public boolean isClassfileMissing() {
        return !this.thisProject.getFile(".classpath").exists();
    }

    public void initializeTimeStamps() {
        IFile file = this.thisProject.getFile(".classpath");
        this.fFileTimeStamp = file.getModificationStamp();
    }

    static {
        Factory factory = new Factory("AspectJProjectPropertiesPage.java", Class.forName(PROP_ID));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig(PROP_ID, "org.eclipse.core.runtime.CoreException:", "ce:"), 225);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "resetPathBlocks", PROP_ID, "", "", "", "void"), 220);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig(PROP_ID, "org.eclipse.core.runtime.CoreException:", "ce:"), 238);
        ajc$tjp_3 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig(PROP_ID, "org.eclipse.jdt.core.JavaModelException:", "<missing>:"), 260);
        ajc$tjp_4 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "getInitialPathValue", PROP_ID, "org.eclipse.core.resources.IProject:org.eclipse.jdt.core.IClasspathAttribute:", "project:attribute:", "org.eclipse.core.runtime.CoreException:", "[Lorg.eclipse.jdt.core.IClasspathEntry;"), 247);
        ajc$tjp_5 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig(PROP_ID, "org.eclipse.jdt.core.JavaModelException:", "<missing>:"), 311);
        ajc$tjp_6 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("4", "getEntriesInContainers", PROP_ID, "org.eclipse.core.resources.IProject:org.eclipse.jdt.core.IClasspathAttribute:", "project:attribute:", "", "java.util.List"), 280);
    }

    private class ConfigurePathBlockJob
    extends UIJob {
        PathBlock block;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

        ConfigurePathBlockJob(PathBlock block) {
            super("Configure " + block.getBlockTitle());
            this.block = block;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            try {
                this.block.configureJavaProject(monitor);
                return Status.OK_STATUS;
            }
            catch (CoreException coreException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
                CoreException e = coreException;
                return new Status(4, "org.eclipse.ajdt.ui", "Error configuring in path.", (Throwable)e);
            }
            catch (InterruptedException interruptedException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(interruptedException, (Object)this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_1);
                return Status.CANCEL_STATUS;
            }
        }

        static {
            Factory factory = new Factory("AspectJProjectPropertiesPage.java", Class.forName("org.eclipse.ajdt.internal.ui.AspectJProjectPropertiesPage$ConfigurePathBlockJob"));
            ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.AspectJProjectPropertiesPage$ConfigurePathBlockJob", "org.eclipse.core.runtime.CoreException:", "e:"), 138);
            ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "runInUIThread", "org.eclipse.ajdt.internal.ui.AspectJProjectPropertiesPage$ConfigurePathBlockJob", "org.eclipse.core.runtime.IProgressMonitor:", "monitor:", "", "org.eclipse.core.runtime.IStatus"), 134);
            ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.AspectJProjectPropertiesPage$ConfigurePathBlockJob", "java.lang.InterruptedException:", "<missing>:"), 140);
        }
    }

    private class PageChangeListener
    implements Listener,
    IResourceChangeListener {
        private PageChangeListener() {
        }

        public void handleEvent(Event event) {
            if (event.type == 23 && AspectJProjectPropertiesPage.this.hasChanges()) {
                AspectJProjectPropertiesPage.this.commit();
            }
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (event.getDelta() != null && event.getDelta().findMember(AspectJProjectPropertiesPage.this.thisProject.getFile((IPath)new Path(".classpath")).getFullPath()) != null) {
                this.refreshPathBlock();
            }
        }

        private void refreshPathBlock() {
            if (AspectJProjectPropertiesPage.this.hasChangesInClasspathFile()) {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        AspectJProjectPropertiesPage.this.resetPathBlocks();
                    }
                });
            }
        }
    }
}

