/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.managers;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.ls.core.internal.DependencyUtil;
import org.eclipse.jdt.ls.core.internal.JobHelpers;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.managers.ISourceDownloader;
import org.eclipse.jdt.ls.core.internal.managers.MavenCentralIdentifier;
import org.eclipse.jdt.ls.core.internal.managers.MavenLocalRepositoryIdentifier;
import org.eclipse.jdt.ls.core.internal.managers.MavenPropertiesIdentifier;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.jdt.MavenJdtPlugin;
import org.eclipse.m2e.jdt.internal.BuildPathManager;

public class MavenSourceDownloader
implements ISourceDownloader {
    private static Cache<String, Boolean> downloadRequestsCache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(1L, TimeUnit.HOURS).build();
    private static final int MAX_TIME_MILLIS = 3000;
    private static Cache<IPackageFragmentRoot, Integer> downloadStateCache = CacheBuilder.newBuilder().maximumSize(100L).build();

    @Override
    public void discoverSource(IClassFile classFile, IProgressMonitor monitor) throws CoreException {
        if (classFile == null) {
            return;
        }
        IClassFile element = classFile;
        while (element.getParent() != null) {
            if (!((element = element.getParent()) instanceof IPackageFragmentRoot)) continue;
            IPackageFragmentRoot fragment = (IPackageFragmentRoot)element;
            IPath attachmentPath = fragment.getSourceAttachmentPath();
            if (attachmentPath != null && !attachmentPath.isEmpty() && attachmentPath.toFile().exists()) break;
            if (!fragment.isArchive()) continue;
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(fragment.getPath());
            IPath path = file.getFullPath();
            if (!(path != null && path.toFile().exists() || (path = file.getLocation()) != null)) {
                return;
            }
            Boolean downloaded = (Boolean)downloadRequestsCache.getIfPresent((Object)path.toString());
            if (downloaded != null) break;
            downloadRequestsCache.put((Object)path.toString(), (Object)true);
            ArtifactKey artifact = new MavenPropertiesIdentifier().identify(path, monitor);
            if (artifact == null) {
                artifact = new MavenCentralIdentifier().identify(path, monitor);
            }
            if (artifact == null) {
                artifact = new MavenLocalRepositoryIdentifier().identify(path, monitor);
            }
            if (artifact == null) break;
            downloadStateCache.put((Object)fragment, (Object)2);
            if (!ProjectUtils.isMavenProject(element.getJavaProject().getProject())) {
                long lastModified;
                try {
                    File artifactFile = DependencyUtil.getArtifact(artifact.groupId(), artifact.artifactId(), artifact.version(), artifact.classifier());
                    lastModified = artifactFile.lastModified();
                }
                catch (FileNotFoundException | CoreException e1) {
                    lastModified = -1L;
                }
                if (lastModified > -1L) {
                    try {
                        File sources = DependencyUtil.getSources(artifact.groupId(), artifact.artifactId(), artifact.version());
                        sources.setLastModified(lastModified - 1L);
                    }
                    catch (FileNotFoundException | CoreException sources) {
                        // empty catch block
                    }
                    try {
                        File javadoc = DependencyUtil.getJavadoc(artifact.groupId(), artifact.artifactId(), artifact.version());
                        javadoc.setLastModified(lastModified - 1L);
                    }
                    catch (FileNotFoundException | CoreException throwable) {
                        // empty catch block
                    }
                }
            }
            BuildPathManager buildpathManager = (BuildPathManager)MavenJdtPlugin.getDefault().getBuildpathManager();
            buildpathManager.scheduleDownload(fragment, artifact, true, true);
            JobHelpers.waitForDownloadSourcesJobs(3000);
            if (downloadStateCache.getIfPresent((Object)fragment) == null) break;
            downloadStateCache.put((Object)fragment, (Object)4);
            break;
        }
    }

    @Override
    public int getDownloadStatus(IPackageFragmentRoot root) {
        return downloadStateCache.getIfPresent((Object)root) == null ? 1 : (Integer)downloadStateCache.getIfPresent((Object)root);
    }

    @Override
    public void clearDownloadStatus(IPackageFragmentRoot root) {
        downloadStateCache.invalidate((Object)root);
    }
}

