/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.javac.dom;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.PackageDeclaration;

public class FindNextJavadocableSibling
extends ASTVisitor {
    private ASTNode nextNode = null;
    private ASTNode nonJavaDocableNextNode = null;
    private int javadocStart;
    private int javadocLength;
    private boolean done = false;

    public FindNextJavadocableSibling(int javadocStart, int javadocLength) {
        this.javadocStart = javadocStart;
        this.javadocLength = javadocLength;
    }

    public boolean preVisit2(ASTNode node) {
        if (this.done) {
            return false;
        }
        this.preVisit(node);
        return true;
    }

    public ASTNode getNextNode() {
        if (this.nonJavaDocableNextNode == null || this.nextNode == null) {
            return this.nextNode;
        }
        if (this.nonJavaDocableNextNode.getStartPosition() < this.nextNode.getStartPosition()) {
            return null;
        }
        return this.nextNode;
    }

    public void preVisit(ASTNode node) {
        int jdocEnd = this.javadocStart + this.javadocLength;
        if (FindNextJavadocableSibling.isJavadocAble(node)) {
            if (node.getStartPosition() == this.javadocStart) {
                this.nextNode = node;
                this.done = true;
                return;
            }
            if (node.getStartPosition() > jdocEnd && (this.nextNode == null || this.nextNode.getStartPosition() > node.getStartPosition())) {
                this.nextNode = node;
            }
        } else if (node.getStartPosition() == this.javadocStart) {
            this.nonJavaDocableNextNode = node;
        } else if (node.getStartPosition() > jdocEnd && (this.nonJavaDocableNextNode == null || this.nonJavaDocableNextNode.getStartPosition() > node.getStartPosition())) {
            this.nonJavaDocableNextNode = node;
        }
    }

    private static boolean isJavadocAble(ASTNode node) {
        return node instanceof PackageDeclaration || node instanceof AbstractTypeDeclaration || node instanceof FieldDeclaration || node instanceof MethodDeclaration;
    }
}

