/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.test.runner.testng;

import com.microsoft.java.test.runner.common.TestRunnerMessageHelper;
import org.testng.IConfigurationListener;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestNGListener;
import org.testng.ITestResult;

public class TestNGListener
implements ISuiteListener,
ITestListener,
ITestNGListener,
IConfigurationListener {
    private ITestResult lastConfigFailure = null;

    public void onTestStart(ITestResult result) {
        TestRunnerMessageHelper.testStarted(this.createTestName(result));
    }

    public void onTestSuccess(ITestResult result) {
        long duration = result.getEndMillis() - result.getStartMillis();
        TestRunnerMessageHelper.testFinished(this.createTestName(result), duration);
    }

    public void onTestFailure(ITestResult result) {
        long duration = result.getEndMillis() - result.getStartMillis();
        TestRunnerMessageHelper.testFailed(this.createTestName(result), result.getThrowable(), duration);
    }

    public void onTestSkipped(ITestResult result) {
        Throwable throwable = result.getThrowable();
        if (throwable != null) {
            this.onTestFailure(result);
            return;
        }
        if (this.lastConfigFailure != null) {
            result.setThrowable(this.lastConfigFailure.getThrowable());
            result.setStatus(this.lastConfigFailure.getStatus());
            this.lastConfigFailure = null;
            this.onTestFailure(result);
            return;
        }
        TestRunnerMessageHelper.testIgnored(this.createTestName(result));
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult result) {
        this.onTestFailure(result);
    }

    private String createTestName(ITestResult result) {
        String className = result.getTestClass().getName();
        String methodName = result.getMethod().getMethodName();
        StringBuilder params = new StringBuilder();
        for (Class<?> paramClazz : result.getMethod().getConstructorOrMethod().getMethod().getParameterTypes()) {
            params.append(paramClazz.getSimpleName().replaceAll("<.*?>", ""));
            params.append(", ");
        }
        if (params.length() > 0) {
            params.delete(params.length() - 2, params.length());
        }
        return className + "#" + methodName + "(" + params.toString() + ")";
    }

    public void onStart(ITestContext context) {
    }

    public void onFinish(ITestContext context) {
    }

    public void onStart(ISuite suite) {
    }

    public void onFinish(ISuite suite) {
    }

    public void onConfigurationSuccess(ITestResult itr) {
    }

    public void onConfigurationFailure(ITestResult result) {
        this.lastConfigFailure = result;
    }

    public void onConfigurationSkip(ITestResult result) {
    }
}

