/*
 * Decompiled with CFR 0.152.
 */
package com.github.badsyntax.gradle.handlers;

import com.github.badsyntax.gradle.CancelBuildReply;
import com.github.badsyntax.gradle.CancelBuildRequest;
import com.github.badsyntax.gradle.GradleBuildCancellation;
import com.github.badsyntax.gradle.exceptions.GradleCancellationException;
import io.grpc.stub.StreamObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CancelBuildHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)CancelBuildHandler.class.getName());
    private CancelBuildRequest req;
    private StreamObserver<CancelBuildReply> responseObserver;

    public CancelBuildHandler(CancelBuildRequest req, StreamObserver<CancelBuildReply> responseObserver) {
        this.req = req;
        this.responseObserver = responseObserver;
    }

    public void run() {
        try {
            GradleBuildCancellation.cancelBuild(this.req.getCancellationKey());
            this.replyWithCancelledSuccess();
        }
        catch (GradleCancellationException e) {
            logger.error(e.getMessage());
            this.replyWithCancelError(e);
        }
        finally {
            this.responseObserver.onCompleted();
        }
    }

    private void replyWithCancelledSuccess() {
        this.responseObserver.onNext((Object)CancelBuildReply.newBuilder().setMessage("Cancel build requested").setBuildRunning(true).build());
    }

    private void replyWithCancelError(Exception e) {
        this.responseObserver.onNext((Object)CancelBuildReply.newBuilder().setMessage(e.getMessage()).setBuildRunning(false).build());
    }
}

