/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.managers;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.managers.IMavenArtifactIdentifier;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.embedder.IMaven;

public class MavenLocalRepositoryIdentifier
implements IMavenArtifactIdentifier {
    @Override
    public ArtifactKey identify(IPath path, IProgressMonitor monitor) {
        if (path == null) {
            return null;
        }
        return this.identify(path.toFile(), monitor);
    }

    private ArtifactKey identify(File file, IProgressMonitor monitor) {
        Path localRepoPath;
        block10: {
            Path filePath;
            block9: {
                String localRepositoryDir;
                block8: {
                    ArtifactRepository localRepository;
                    block7: {
                        if (file == null || !file.isFile() || !file.canRead()) {
                            return null;
                        }
                        IMaven maven = MavenPlugin.getMaven();
                        try {
                            localRepository = maven.getLocalRepository();
                            if (localRepository != null) break block7;
                            return null;
                        }
                        catch (Exception e) {
                            JavaLanguageServerPlugin.logError("Failed to identify " + String.valueOf(file) + " : " + String.valueOf(e));
                            return null;
                        }
                    }
                    localRepositoryDir = localRepository.getBasedir();
                    if (localRepositoryDir != null) break block8;
                    return null;
                }
                filePath = file.toPath().normalize();
                localRepoPath = Paths.get(localRepositoryDir, new String[0]).normalize();
                if (filePath.startsWith(localRepoPath)) break block9;
                return null;
            }
            Path fileRelativePath = localRepoPath.relativize(filePath);
            int fileSegmentCount = fileRelativePath.getNameCount();
            if (fileSegmentCount >= 4) break block10;
            return null;
        }
        File versionDirectory = file.getParentFile();
        String version = versionDirectory.getName();
        File artifactIdDirectory = versionDirectory.getParentFile();
        String artifactId = artifactIdDirectory.getName();
        File lastPartGroupIdDirectory = artifactIdDirectory.getParentFile();
        Path groupIdPath = lastPartGroupIdDirectory.toPath().normalize();
        Path relativePath = localRepoPath.relativize(groupIdPath);
        String groupId = relativePath.toString().replace("\\", ".").replace("/", ".");
        return new ArtifactKey(groupId, artifactId, version, null);
    }
}

