"use strict";
/*********************************************************************
 * Copyright (c) 2019 Ericsson and others
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *********************************************************************/
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const chai_1 = require("chai");
const pty_1 = require("../native/pty");
const forked_file_1 = require("../native/forked-file");
if (process.platform !== 'win32') {
    describe('pty creation', function () {
        let master;
        let slave;
        afterEach(function () {
            if (slave) {
                slave.destroy();
            }
            if (master) {
                master.destroy();
            }
        });
        it('should be able to open a ptmx/pts pair', failFast(function (fail) {
            return __awaiter(this, void 0, void 0, function* () {
                master = new pty_1.Pty();
                slave = new forked_file_1.ForkedFile(master.slave_name);
                let masterBuffer = '';
                let slaveBuffer = '';
                master.reader.on('error', fail);
                slave.reader.on('error', fail);
                master.reader.on('data', (data) => (masterBuffer += data.toString('utf8')));
                slave.reader.on('data', (data) => (slaveBuffer += data.toString('utf8')));
                yield sendAndAwait('master2slave', master.writer, slave.reader);
                (0, chai_1.expect)(masterBuffer).eq('');
                (0, chai_1.expect)(slaveBuffer).eq('master2slave');
                yield sendAndAwait('slave2master', slave.writer, master.reader);
                (0, chai_1.expect)(masterBuffer).eq('slave2master');
                (0, chai_1.expect)(slaveBuffer).eq('master2slave');
            });
        }));
    });
}
/**
 * What goes in should come out. Useful to test PTYs since what we write on `master` should come out of `slave` and vice-versa.
 *
 * @param str payload
 * @param writeTo where to write into
 * @param readFrom where to wait for it to come out
 */
function sendAndAwait(str, writeTo, readFrom) {
    return new Promise((resolve) => {
        readFrom.once('data', () => resolve());
        writeTo.write(str);
    });
}
/**
 * Allows an async function to reject early.
 */
function failFast(callback) {
    let fail;
    const abortPromise = new Promise((_, reject) => {
        fail = reject;
    });
    return function () {
        return Promise.race([abortPromise, callback.call(this, fail)]);
    };
}
//# sourceMappingURL=pty.spec.js.map