/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.classfile.ClassLoaderData;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.DebuggerException;
import sun.jvm.hotspot.memory.SymbolTable;
import sun.jvm.hotspot.memory.SystemDictionary;
import sun.jvm.hotspot.oops.AccessFlags;
import sun.jvm.hotspot.oops.BooleanField;
import sun.jvm.hotspot.oops.BreakpointInfo;
import sun.jvm.hotspot.oops.ByteField;
import sun.jvm.hotspot.oops.CIntField;
import sun.jvm.hotspot.oops.CharField;
import sun.jvm.hotspot.oops.ConstantPool;
import sun.jvm.hotspot.oops.DoubleField;
import sun.jvm.hotspot.oops.Field;
import sun.jvm.hotspot.oops.FieldType;
import sun.jvm.hotspot.oops.FloatField;
import sun.jvm.hotspot.oops.Instance;
import sun.jvm.hotspot.oops.IntField;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.LongField;
import sun.jvm.hotspot.oops.MetadataField;
import sun.jvm.hotspot.oops.MetadataVisitor;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.oops.NarrowOopField;
import sun.jvm.hotspot.oops.ObjArray;
import sun.jvm.hotspot.oops.ObjArrayKlass;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.OopField;
import sun.jvm.hotspot.oops.OopUtilities;
import sun.jvm.hotspot.oops.OopVisitor;
import sun.jvm.hotspot.oops.ShortField;
import sun.jvm.hotspot.oops.Symbol;
import sun.jvm.hotspot.oops.TypeArray;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObjectFactory;
import sun.jvm.hotspot.runtime.vmSymbols;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;
import sun.jvm.hotspot.utilities.Assert;
import sun.jvm.hotspot.utilities.CStringUtilities;
import sun.jvm.hotspot.utilities.IntArray;
import sun.jvm.hotspot.utilities.KlassArray;
import sun.jvm.hotspot.utilities.MethodArray;
import sun.jvm.hotspot.utilities.U2Array;

public class InstanceKlass
extends Klass {
    private static int ACCESS_FLAGS_OFFSET;
    private static int NAME_INDEX_OFFSET;
    private static int SIGNATURE_INDEX_OFFSET;
    private static int INITVAL_INDEX_OFFSET;
    private static int LOW_OFFSET;
    private static int HIGH_OFFSET;
    private static int FIELD_SLOTS;
    private static short FIELDINFO_TAG_SIZE;
    private static short FIELDINFO_TAG_MASK;
    private static short FIELDINFO_TAG_OFFSET;
    private static int CLASS_STATE_ALLOCATED;
    private static int CLASS_STATE_LOADED;
    private static int CLASS_STATE_LINKED;
    private static int CLASS_STATE_BEING_INITIALIZED;
    private static int CLASS_STATE_FULLY_INITIALIZED;
    private static int CLASS_STATE_INITIALIZATION_ERROR;
    private static MetadataField arrayKlasses;
    private static AddressField methods;
    private static AddressField methodOrdering;
    private static AddressField localInterfaces;
    private static AddressField transitiveInterfaces;
    private static AddressField fields;
    private static CIntField javaFieldsCount;
    private static MetadataField constants;
    private static AddressField classLoaderData;
    private static AddressField sourceDebugExtension;
    private static AddressField innerClasses;
    private static CIntField sourceFileNameIndex;
    private static CIntField nonstaticFieldSize;
    private static CIntField staticFieldSize;
    private static CIntField staticOopFieldCount;
    private static CIntField nonstaticOopMapSize;
    private static CIntField isMarkedDependent;
    private static CIntField initState;
    private static CIntField vtableLen;
    private static CIntField itableLen;
    private static AddressField breakpoints;
    private static CIntField genericSignatureIndex;
    private static CIntField majorVersion;
    private static CIntField minorVersion;
    private static long headerSize;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("InstanceKlass");
        arrayKlasses = new MetadataField(type.getAddressField("_array_klasses"), 0L);
        methods = type.getAddressField("_methods");
        methodOrdering = type.getAddressField("_method_ordering");
        localInterfaces = type.getAddressField("_local_interfaces");
        transitiveInterfaces = type.getAddressField("_transitive_interfaces");
        fields = type.getAddressField("_fields");
        javaFieldsCount = new CIntField(type.getCIntegerField("_java_fields_count"), 0L);
        constants = new MetadataField(type.getAddressField("_constants"), 0L);
        classLoaderData = type.getAddressField("_class_loader_data");
        sourceDebugExtension = type.getAddressField("_source_debug_extension");
        innerClasses = type.getAddressField("_inner_classes");
        sourceFileNameIndex = new CIntField(type.getCIntegerField("_source_file_name_index"), 0L);
        nonstaticFieldSize = new CIntField(type.getCIntegerField("_nonstatic_field_size"), 0L);
        staticFieldSize = new CIntField(type.getCIntegerField("_static_field_size"), 0L);
        staticOopFieldCount = new CIntField(type.getCIntegerField("_static_oop_field_count"), 0L);
        nonstaticOopMapSize = new CIntField(type.getCIntegerField("_nonstatic_oop_map_size"), 0L);
        isMarkedDependent = new CIntField(type.getCIntegerField("_is_marked_dependent"), 0L);
        initState = new CIntField(type.getCIntegerField("_init_state"), 0L);
        vtableLen = new CIntField(type.getCIntegerField("_vtable_len"), 0L);
        itableLen = new CIntField(type.getCIntegerField("_itable_len"), 0L);
        breakpoints = type.getAddressField("_breakpoints");
        genericSignatureIndex = new CIntField(type.getCIntegerField("_generic_signature_index"), 0L);
        majorVersion = new CIntField(type.getCIntegerField("_major_version"), 0L);
        minorVersion = new CIntField(type.getCIntegerField("_minor_version"), 0L);
        headerSize = Oop.alignObjectOffset(type.getSize());
        ACCESS_FLAGS_OFFSET = db.lookupIntConstant("FieldInfo::access_flags_offset");
        NAME_INDEX_OFFSET = db.lookupIntConstant("FieldInfo::name_index_offset");
        SIGNATURE_INDEX_OFFSET = db.lookupIntConstant("FieldInfo::signature_index_offset");
        INITVAL_INDEX_OFFSET = db.lookupIntConstant("FieldInfo::initval_index_offset");
        LOW_OFFSET = db.lookupIntConstant("FieldInfo::low_packed_offset");
        HIGH_OFFSET = db.lookupIntConstant("FieldInfo::high_packed_offset");
        FIELD_SLOTS = db.lookupIntConstant("FieldInfo::field_slots");
        FIELDINFO_TAG_SIZE = db.lookupIntConstant("FIELDINFO_TAG_SIZE").shortValue();
        FIELDINFO_TAG_MASK = db.lookupIntConstant("FIELDINFO_TAG_MASK").shortValue();
        FIELDINFO_TAG_OFFSET = db.lookupIntConstant("FIELDINFO_TAG_OFFSET").shortValue();
        CLASS_STATE_ALLOCATED = db.lookupIntConstant("InstanceKlass::allocated");
        CLASS_STATE_LOADED = db.lookupIntConstant("InstanceKlass::loaded");
        CLASS_STATE_LINKED = db.lookupIntConstant("InstanceKlass::linked");
        CLASS_STATE_BEING_INITIALIZED = db.lookupIntConstant("InstanceKlass::being_initialized");
        CLASS_STATE_FULLY_INITIALIZED = db.lookupIntConstant("InstanceKlass::fully_initialized");
        CLASS_STATE_INITIALIZATION_ERROR = db.lookupIntConstant("InstanceKlass::initialization_error");
    }

    public InstanceKlass(Address addr) {
        super(addr);
        if (this.getJavaFieldsCount() != this.getAllFieldsCount()) {
            for (int i = this.getJavaFieldsCount(); i < this.getAllFieldsCount(); ++i) {
                this.getFieldName(i);
                this.getFieldSignature(i);
            }
        }
    }

    public int getInitStateAsInt() {
        return (int)initState.getValue(this);
    }

    public ClassState getInitState() {
        int state = this.getInitStateAsInt();
        if (state == CLASS_STATE_ALLOCATED) {
            return ClassState.ALLOCATED;
        }
        if (state == CLASS_STATE_LOADED) {
            return ClassState.LOADED;
        }
        if (state == CLASS_STATE_LINKED) {
            return ClassState.LINKED;
        }
        if (state == CLASS_STATE_BEING_INITIALIZED) {
            return ClassState.BEING_INITIALIZED;
        }
        if (state == CLASS_STATE_FULLY_INITIALIZED) {
            return ClassState.FULLY_INITIALIZED;
        }
        if (state == CLASS_STATE_INITIALIZATION_ERROR) {
            return ClassState.INITIALIZATION_ERROR;
        }
        throw new RuntimeException("should not reach here");
    }

    public boolean isLoaded() {
        return this.getInitStateAsInt() >= CLASS_STATE_LOADED;
    }

    public boolean isLinked() {
        return this.getInitStateAsInt() >= CLASS_STATE_LINKED;
    }

    public boolean isInitialized() {
        return this.getInitStateAsInt() == CLASS_STATE_FULLY_INITIALIZED;
    }

    public boolean isNotInitialized() {
        return this.getInitStateAsInt() < CLASS_STATE_BEING_INITIALIZED;
    }

    public boolean isBeingInitialized() {
        return this.getInitStateAsInt() == CLASS_STATE_BEING_INITIALIZED;
    }

    public boolean isInErrorState() {
        return this.getInitStateAsInt() == CLASS_STATE_INITIALIZATION_ERROR;
    }

    @Override
    public int getClassStatus() {
        int result = 0;
        if (this.isLinked()) {
            result |= 3;
        }
        if (this.isInitialized()) {
            if (Assert.ASSERTS_ENABLED) {
                Assert.that(this.isLinked(), "Class status is not consistent");
            }
            result |= 4;
        }
        if (this.isInErrorState()) {
            result |= 8;
        }
        return result;
    }

    public long getObjectSize(Oop object) {
        return this.getSizeHelper() * VM.getVM().getAddressSize();
    }

    public long getSize() {
        return Oop.alignObjectSize(InstanceKlass.getHeaderSize() + Oop.alignObjectOffset(this.getVtableLen()) + Oop.alignObjectOffset(this.getItableLen()) + Oop.alignObjectOffset(this.getNonstaticOopMapSize()));
    }

    public static long getHeaderSize() {
        return headerSize;
    }

    public short getFieldAccessFlags(int index) {
        return this.getFields().at(index * FIELD_SLOTS + ACCESS_FLAGS_OFFSET);
    }

    public short getFieldNameIndex(int index) {
        if (index >= this.getJavaFieldsCount()) {
            throw new IndexOutOfBoundsException("not a Java field;");
        }
        return this.getFields().at(index * FIELD_SLOTS + NAME_INDEX_OFFSET);
    }

    public Symbol getFieldName(int index) {
        short nameIndex = this.getFields().at(index * FIELD_SLOTS + NAME_INDEX_OFFSET);
        if (index < this.getJavaFieldsCount()) {
            return this.getConstants().getSymbolAt(nameIndex);
        }
        return vmSymbols.symbolAt(nameIndex);
    }

    public short getFieldSignatureIndex(int index) {
        if (index >= this.getJavaFieldsCount()) {
            throw new IndexOutOfBoundsException("not a Java field;");
        }
        return this.getFields().at(index * FIELD_SLOTS + SIGNATURE_INDEX_OFFSET);
    }

    public Symbol getFieldSignature(int index) {
        short signatureIndex = this.getFields().at(index * FIELD_SLOTS + SIGNATURE_INDEX_OFFSET);
        if (index < this.getJavaFieldsCount()) {
            return this.getConstants().getSymbolAt(signatureIndex);
        }
        return vmSymbols.symbolAt(signatureIndex);
    }

    public short getFieldGenericSignatureIndex(int index) {
        int allFieldsCount = this.getAllFieldsCount();
        int generic_signature_slot = allFieldsCount * FIELD_SLOTS;
        for (int i = 0; i < allFieldsCount; ++i) {
            short flags = this.getFieldAccessFlags(i);
            AccessFlags access = new AccessFlags(flags);
            if (i == index) {
                if (access.fieldHasGenericSignature()) {
                    return this.getFields().at(generic_signature_slot);
                }
                return 0;
            }
            if (!access.fieldHasGenericSignature()) continue;
            ++generic_signature_slot;
        }
        return 0;
    }

    public Symbol getFieldGenericSignature(int index) {
        short genericSignatureIndex = this.getFieldGenericSignatureIndex(index);
        if (genericSignatureIndex != 0) {
            return this.getConstants().getSymbolAt(genericSignatureIndex);
        }
        return null;
    }

    public short getFieldInitialValueIndex(int index) {
        if (index >= this.getJavaFieldsCount()) {
            throw new IndexOutOfBoundsException("not a Java field;");
        }
        return this.getFields().at(index * FIELD_SLOTS + INITVAL_INDEX_OFFSET);
    }

    public int getFieldOffset(int index) {
        U2Array fields = this.getFields();
        short lo = fields.at(index * FIELD_SLOTS + LOW_OFFSET);
        short hi = fields.at(index * FIELD_SLOTS + HIGH_OFFSET);
        if ((lo & FIELDINFO_TAG_MASK) == FIELDINFO_TAG_OFFSET) {
            return VM.getVM().buildIntFromShorts(lo, hi) >> FIELDINFO_TAG_SIZE;
        }
        throw new RuntimeException("should not reach here");
    }

    public Klass getArrayKlasses() {
        return (Klass)arrayKlasses.getValue(this);
    }

    public MethodArray getMethods() {
        return new MethodArray(methods.getValue(this.getAddress()));
    }

    public KlassArray getLocalInterfaces() {
        return new KlassArray(localInterfaces.getValue(this.getAddress()));
    }

    public KlassArray getTransitiveInterfaces() {
        return new KlassArray(transitiveInterfaces.getValue(this.getAddress()));
    }

    public int getJavaFieldsCount() {
        return (int)javaFieldsCount.getValue(this);
    }

    public int getAllFieldsCount() {
        int len = this.getFields().length();
        int allFieldsCount = 0;
        while (allFieldsCount * FIELD_SLOTS < len) {
            short flags = this.getFieldAccessFlags(allFieldsCount);
            AccessFlags access = new AccessFlags(flags);
            if (access.fieldHasGenericSignature()) {
                --len;
            }
            ++allFieldsCount;
        }
        return allFieldsCount;
    }

    public ConstantPool getConstants() {
        return (ConstantPool)constants.getValue(this);
    }

    public ClassLoaderData getClassLoaderData() {
        return ClassLoaderData.instantiateWrapperFor(classLoaderData.getValue(this.getAddress()));
    }

    public Oop getClassLoader() {
        return this.getClassLoaderData().getClassLoader();
    }

    public Symbol getSourceFileName() {
        return this.getConstants().getSymbolAt(sourceFileNameIndex.getValue(this));
    }

    public String getSourceDebugExtension() {
        return CStringUtilities.getString(sourceDebugExtension.getValue(this.getAddress()));
    }

    public long getNonstaticFieldSize() {
        return nonstaticFieldSize.getValue(this);
    }

    public long getStaticOopFieldCount() {
        return staticOopFieldCount.getValue(this);
    }

    public long getNonstaticOopMapSize() {
        return nonstaticOopMapSize.getValue(this);
    }

    public boolean getIsMarkedDependent() {
        return isMarkedDependent.getValue(this) != 0L;
    }

    public long getVtableLen() {
        return vtableLen.getValue(this);
    }

    public long getItableLen() {
        return itableLen.getValue(this);
    }

    public long majorVersion() {
        return majorVersion.getValue(this);
    }

    public long minorVersion() {
        return minorVersion.getValue(this);
    }

    public Symbol getGenericSignature() {
        long index = genericSignatureIndex.getValue(this);
        if (index != 0L) {
            return this.getConstants().getSymbolAt(index);
        }
        return null;
    }

    public long getSizeHelper() {
        int lh = this.getLayoutHelper();
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(lh > 0, "layout helper initialized for instance class");
        }
        return (long)lh / VM.getVM().getAddressSize();
    }

    @Override
    public long computeModifierFlags() {
        int length;
        long access = this.getAccessFlags();
        U2Array innerClassList = this.getInnerClasses();
        int n = length = innerClassList == null ? 0 : innerClassList.length();
        if (length > 0) {
            if (Assert.ASSERTS_ENABLED) {
                Assert.that(length % 4 == 0 || length % 4 == 2, "just checking");
            }
            for (int i = 0; i < length && i != length - 2; i += 4) {
                short ioff = innerClassList.at(i + 0);
                if (ioff == 0) continue;
                ConstantPool.CPSlot classInfo = this.getConstants().getSlotAt(ioff);
                Symbol name = null;
                if (classInfo.isResolved()) {
                    name = classInfo.getKlass().getName();
                } else if (classInfo.isUnresolved()) {
                    name = classInfo.getSymbol();
                } else {
                    throw new RuntimeException("should not reach here");
                }
                if (!name.equals(this.getName())) continue;
                access = innerClassList.at(i + 3);
                break;
            }
        }
        return access & 0xFFFFFFFFFFFFFFDFL & 0x7FFFL;
    }

    public boolean isInnerClassName(Symbol sym) {
        return this.isInInnerClasses(sym, false);
    }

    public boolean isInnerOrLocalClassName(Symbol sym) {
        return this.isInInnerClasses(sym, true);
    }

    private boolean isInInnerClasses(Symbol sym, boolean includeLocals) {
        int length;
        U2Array innerClassList = this.getInnerClasses();
        int n = length = innerClassList == null ? 0 : innerClassList.length();
        if (length > 0) {
            if (Assert.ASSERTS_ENABLED) {
                Assert.that(length % 4 == 0 || length % 4 == 2, "just checking");
            }
            for (int i = 0; i < length && i != length - 2; i += 4) {
                short ioff = innerClassList.at(i + 0);
                if (ioff == 0) continue;
                ConstantPool.CPSlot iclassInfo = this.getConstants().getSlotAt(ioff);
                Symbol innerName = this.getConstants().getKlassNameAt(ioff);
                Symbol myname = this.getName();
                short ooff = innerClassList.at(i + 1);
                short innerNameIndex = innerClassList.at(i + 2);
                if (ooff == 0) {
                    if (!includeLocals || !innerName.equals(sym) || !innerName.asString().startsWith(myname.asString())) continue;
                    return innerNameIndex != 0;
                }
                ConstantPool.CPSlot oclassInfo = this.getConstants().getSlotAt(ooff);
                Symbol outerName = null;
                if (oclassInfo.isResolved()) {
                    outerName = oclassInfo.getKlass().getName();
                } else if (oclassInfo.isUnresolved()) {
                    outerName = oclassInfo.getSymbol();
                } else {
                    throw new RuntimeException("should not reach here");
                }
                if (!outerName.equals(myname) || !innerName.equals(sym)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean implementsInterface(Klass k) {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(k.isInterface(), "should not reach here");
        }
        KlassArray interfaces = this.getTransitiveInterfaces();
        int len = interfaces.length();
        for (int i = 0; i < len; ++i) {
            if (!interfaces.getAt(i).equals(k)) continue;
            return true;
        }
        return false;
    }

    @Override
    boolean computeSubtypeOf(Klass k) {
        if (k.isInterface()) {
            return this.implementsInterface(k);
        }
        return super.computeSubtypeOf(k);
    }

    @Override
    public void printValueOn(PrintStream tty) {
        tty.print("InstanceKlass for " + this.getName().asString());
    }

    @Override
    public void iterateFields(MetadataVisitor visitor) {
        super.iterateFields(visitor);
        visitor.doMetadata(arrayKlasses, true);
        visitor.doCInt(nonstaticFieldSize, true);
        visitor.doCInt(staticFieldSize, true);
        visitor.doCInt(staticOopFieldCount, true);
        visitor.doCInt(nonstaticOopMapSize, true);
        visitor.doCInt(isMarkedDependent, true);
        visitor.doCInt(initState, true);
        visitor.doCInt(vtableLen, true);
        visitor.doCInt(itableLen, true);
    }

    public void iterateStaticFields(OopVisitor visitor) {
        visitor.setObj(this.getJavaMirror());
        visitor.prologue();
        this.iterateStaticFieldsInternal(visitor);
        visitor.epilogue();
    }

    void iterateStaticFieldsInternal(OopVisitor visitor) {
        int length = this.getJavaFieldsCount();
        for (int index = 0; index < length; ++index) {
            short accessFlags = this.getFieldAccessFlags(index);
            FieldType type = new FieldType(this.getFieldSignature(index));
            AccessFlags access = new AccessFlags(accessFlags);
            if (!access.isStatic()) continue;
            this.visitField(visitor, type, index);
        }
    }

    @Override
    public Klass getJavaSuper() {
        return this.getSuper();
    }

    public Field[] getStaticFields() {
        U2Array fields = this.getFields();
        int length = this.getJavaFieldsCount();
        ArrayList<Field> result = new ArrayList<Field>();
        for (int index = 0; index < length; ++index) {
            Field f = this.newField(index);
            if (!f.isStatic()) continue;
            result.add(f);
        }
        return result.toArray(new Field[result.size()]);
    }

    public void iterateNonStaticFields(OopVisitor visitor, Oop obj) {
        if (this.getSuper() != null) {
            ((InstanceKlass)this.getSuper()).iterateNonStaticFields(visitor, obj);
        }
        int length = this.getJavaFieldsCount();
        for (int index = 0; index < length; ++index) {
            short accessFlags = this.getFieldAccessFlags(index);
            FieldType type = new FieldType(this.getFieldSignature(index));
            AccessFlags access = new AccessFlags(accessFlags);
            if (access.isStatic()) continue;
            this.visitField(visitor, type, index);
        }
    }

    public Field findLocalField(Symbol name, Symbol sig) {
        int length = this.getJavaFieldsCount();
        for (int i = 0; i < length; ++i) {
            Symbol f_name = this.getFieldName(i);
            Symbol f_sig = this.getFieldSignature(i);
            if (!name.equals(f_name) || !sig.equals(f_sig)) continue;
            return this.newField(i);
        }
        return null;
    }

    public Field findInterfaceField(Symbol name, Symbol sig) {
        KlassArray interfaces = this.getLocalInterfaces();
        int n = interfaces.length();
        for (int i = 0; i < n; ++i) {
            Field f;
            InstanceKlass intf1 = (InstanceKlass)interfaces.getAt(i);
            if (Assert.ASSERTS_ENABLED) {
                Assert.that(intf1.isInterface(), "just checking type");
            }
            if ((f = intf1.findLocalField(name, sig)) != null) {
                if (Assert.ASSERTS_ENABLED) {
                    Assert.that(f.getAccessFlagsObj().isStatic(), "interface field must be static");
                }
                return f;
            }
            f = intf1.findInterfaceField(name, sig);
            if (f == null) continue;
            return f;
        }
        return null;
    }

    public Field findField(Symbol name, Symbol sig) {
        Field f = this.findLocalField(name, sig);
        if (f != null) {
            return f;
        }
        f = this.findInterfaceField(name, sig);
        if (f != null) {
            return f;
        }
        InstanceKlass supr = (InstanceKlass)this.getSuper();
        if (supr != null) {
            return supr.findField(name, sig);
        }
        return null;
    }

    public Field findField(String name, String sig) {
        SymbolTable symbols = VM.getVM().getSymbolTable();
        Symbol nameSym = symbols.probe(name);
        Symbol sigSym = symbols.probe(sig);
        if (nameSym == null || sigSym == null) {
            return null;
        }
        return this.findField(nameSym, sigSym);
    }

    public Field findFieldDbg(String name, String sig) {
        return this.findField(name, sig);
    }

    public Field getFieldByIndex(int fieldIndex) {
        return this.newField(fieldIndex);
    }

    public List getImmediateFields() {
        int length = this.getJavaFieldsCount();
        ArrayList<Field> immediateFields = new ArrayList<Field>(length);
        for (int index = 0; index < length; ++index) {
            immediateFields.add(this.getFieldByIndex(index));
        }
        return immediateFields;
    }

    public List getAllFields() {
        InstanceKlass supr;
        List allFields = this.getImmediateFields();
        KlassArray interfaces = this.getTransitiveInterfaces();
        int n = interfaces.length();
        for (int i = 0; i < n; ++i) {
            InstanceKlass intf1 = (InstanceKlass)interfaces.getAt(i);
            if (Assert.ASSERTS_ENABLED) {
                Assert.that(intf1.isInterface(), "just checking type");
            }
            allFields.addAll(intf1.getImmediateFields());
        }
        if (!this.isInterface() && (supr = (InstanceKlass)this.getSuper()) != null) {
            allFields.addAll(supr.getImmediateFields());
        }
        return allFields;
    }

    public List getImmediateMethods() {
        MethodArray methods = this.getMethods();
        int length = methods.length();
        Object[] tmp = new Object[length];
        IntArray methodOrdering = this.getMethodOrdering();
        if (methodOrdering.length() != length) {
            for (int index = 0; index < length; ++index) {
                tmp[index] = methods.at(index);
            }
        } else {
            for (int index = 0; index < length; ++index) {
                int originalIndex = methodOrdering.at(index);
                tmp[originalIndex] = methods.at(index);
            }
        }
        return Arrays.asList(tmp);
    }

    public List getDirectImplementedInterfaces() {
        KlassArray interfaces = this.getLocalInterfaces();
        int length = interfaces.length();
        ArrayList<Klass> directImplementedInterfaces = new ArrayList<Klass>(length);
        for (int index = 0; index < length; ++index) {
            directImplementedInterfaces.add(interfaces.getAt(index));
        }
        return directImplementedInterfaces;
    }

    @Override
    public Klass arrayKlassImpl(boolean orNull, int n) {
        if (this.getArrayKlasses() == null) {
            return null;
        }
        ObjArrayKlass oak = (ObjArrayKlass)this.getArrayKlasses();
        if (orNull) {
            return oak.arrayKlassOrNull(n);
        }
        return oak.arrayKlass(n);
    }

    @Override
    public Klass arrayKlassImpl(boolean orNull) {
        return this.arrayKlassImpl(orNull, 1);
    }

    @Override
    public String signature() {
        return "L" + super.signature() + ";";
    }

    public Method findMethod(String name, String sig) {
        SymbolTable syms = VM.getVM().getSymbolTable();
        Symbol nameSym = syms.probe(name);
        Symbol sigSym = syms.probe(sig);
        if (nameSym == null || sigSym == null) {
            return null;
        }
        return this.findMethod(nameSym, sigSym);
    }

    public Method findMethod(Symbol name, Symbol sig) {
        return InstanceKlass.findMethod(this.getMethods(), name, sig);
    }

    public BreakpointInfo getBreakpoints() {
        Address addr = this.getAddress().getAddressAt(breakpoints.getOffset());
        return (BreakpointInfo)VMObjectFactory.newObject(BreakpointInfo.class, addr);
    }

    public IntArray getMethodOrdering() {
        Address addr = this.getAddress().getAddressAt(methodOrdering.getOffset());
        return (IntArray)VMObjectFactory.newObject(IntArray.class, addr);
    }

    public U2Array getFields() {
        Address addr = this.getAddress().getAddressAt(fields.getOffset());
        return (U2Array)VMObjectFactory.newObject(U2Array.class, addr);
    }

    public U2Array getInnerClasses() {
        Address addr = this.getAddress().getAddressAt(innerClasses.getOffset());
        return (U2Array)VMObjectFactory.newObject(U2Array.class, addr);
    }

    private void visitField(OopVisitor visitor, FieldType type, int index) {
        Field f = this.newField(index);
        if (type.isOop()) {
            visitor.doOop((OopField)f, false);
            return;
        }
        if (type.isByte()) {
            visitor.doByte((ByteField)f, false);
            return;
        }
        if (type.isChar()) {
            visitor.doChar((CharField)f, false);
            return;
        }
        if (type.isDouble()) {
            visitor.doDouble((DoubleField)f, false);
            return;
        }
        if (type.isFloat()) {
            visitor.doFloat((FloatField)f, false);
            return;
        }
        if (type.isInt()) {
            visitor.doInt((IntField)f, false);
            return;
        }
        if (type.isLong()) {
            visitor.doLong((LongField)f, false);
            return;
        }
        if (type.isShort()) {
            visitor.doShort((ShortField)f, false);
            return;
        }
        if (type.isBoolean()) {
            visitor.doBoolean((BooleanField)f, false);
            return;
        }
    }

    private Field newField(int index) {
        FieldType type = new FieldType(this.getFieldSignature(index));
        if (type.isOop()) {
            if (VM.getVM().isCompressedOopsEnabled()) {
                return new NarrowOopField(this, index);
            }
            return new OopField(this, index);
        }
        if (type.isByte()) {
            return new ByteField(this, index);
        }
        if (type.isChar()) {
            return new CharField(this, index);
        }
        if (type.isDouble()) {
            return new DoubleField(this, index);
        }
        if (type.isFloat()) {
            return new FloatField(this, index);
        }
        if (type.isInt()) {
            return new IntField(this, index);
        }
        if (type.isLong()) {
            return new LongField(this, index);
        }
        if (type.isShort()) {
            return new ShortField(this, index);
        }
        if (type.isBoolean()) {
            return new BooleanField(this, index);
        }
        throw new RuntimeException("Illegal field type at index " + index);
    }

    private static Method findMethod(MethodArray methods, Symbol name, Symbol signature) {
        int index;
        int len = methods.length();
        int l = 0;
        int h = len - 1;
        while (l <= h) {
            int mid = l + h >> 1;
            Method m = methods.at(mid);
            int res = m.getName().fastCompare(name);
            if (res == 0) {
                int index2;
                Method m1;
                int i;
                if (m.getSignature().equals(signature)) {
                    return m;
                }
                for (i = mid - 1; i >= l && (m1 = methods.at(i)).getName().equals(name); --i) {
                    if (!m1.getSignature().equals(signature)) continue;
                    return m1;
                }
                for (i = mid + 1; i <= h && (m1 = methods.at(i)).getName().equals(name); ++i) {
                    if (!m1.getSignature().equals(signature)) continue;
                    return m1;
                }
                if (Assert.ASSERTS_ENABLED && (index2 = InstanceKlass.linearSearch(methods, name, signature)) != -1) {
                    throw new DebuggerException("binary search bug: should have found entry " + index2);
                }
                return null;
            }
            if (res < 0) {
                l = mid + 1;
                continue;
            }
            h = mid - 1;
        }
        if (Assert.ASSERTS_ENABLED && (index = InstanceKlass.linearSearch(methods, name, signature)) != -1) {
            throw new DebuggerException("binary search bug: should have found entry " + index);
        }
        return null;
    }

    private static int linearSearch(MethodArray methods, Symbol name, Symbol signature) {
        int len = methods.length();
        for (int index = 0; index < len; ++index) {
            Method m = methods.at(index);
            if (!m.getSignature().equals(signature) || !m.getName().equals(name)) continue;
            return index;
        }
        return -1;
    }

    @Override
    public void dumpReplayData(PrintStream out) {
        ConstantPool cp = this.getConstants();
        for (Klass sub = this.getSubklassKlass(); sub != null; sub = sub.getNextSiblingKlass()) {
            if (!(sub instanceof InstanceKlass)) continue;
            out.println("instanceKlass " + sub.getName().asString());
        }
        int length = cp.getLength();
        out.print("ciInstanceKlass " + this.getName().asString() + " " + (this.isLinked() ? 1 : 0) + " " + (this.isInitialized() ? 1 : 0) + " " + length);
        for (int index = 1; index < length; ++index) {
            out.print(" " + cp.getTags().at(index));
        }
        out.println();
        if (this.isInitialized()) {
            Field[] staticFields = this.getStaticFields();
            for (int i = 0; i < staticFields.length; ++i) {
                Field bf;
                Field f = staticFields[i];
                Instance mirror = this.getJavaMirror();
                if (!f.isFinal() || f.hasInitialValue()) continue;
                out.print("staticfield " + this.getName().asString() + " " + OopUtilities.escapeString(f.getID().getName()) + " " + f.getFieldType().getSignature().asString() + " ");
                if (f instanceof ByteField) {
                    bf = (ByteField)f;
                    out.println(((ByteField)bf).getValue(mirror));
                    continue;
                }
                if (f instanceof BooleanField) {
                    bf = (BooleanField)f;
                    out.println(((BooleanField)bf).getValue(mirror) ? 1 : 0);
                    continue;
                }
                if (f instanceof ShortField) {
                    bf = (ShortField)f;
                    out.println(((ShortField)bf).getValue(mirror));
                    continue;
                }
                if (f instanceof CharField) {
                    bf = (CharField)f;
                    out.println(((CharField)bf).getValue(mirror) & 0xFFFF);
                    continue;
                }
                if (f instanceof IntField) {
                    bf = (IntField)f;
                    out.println(((IntField)bf).getValue(mirror));
                    continue;
                }
                if (f instanceof LongField) {
                    bf = (LongField)f;
                    out.println(((LongField)bf).getValue(mirror));
                    continue;
                }
                if (f instanceof FloatField) {
                    bf = (FloatField)f;
                    out.println(Float.floatToRawIntBits(((FloatField)bf).getValue(mirror)));
                    continue;
                }
                if (f instanceof DoubleField) {
                    bf = (DoubleField)f;
                    out.println(Double.doubleToRawLongBits(((DoubleField)bf).getValue(mirror)));
                    continue;
                }
                if (!(f instanceof OopField)) continue;
                bf = (OopField)f;
                Oop value = ((OopField)bf).getValue(mirror);
                if (value == null) {
                    out.println("null");
                    continue;
                }
                if (value.isInstance()) {
                    Instance inst = (Instance)value;
                    if (inst.isA(SystemDictionary.getStringKlass())) {
                        out.println("\"" + OopUtilities.stringOopToEscapedString(inst) + "\"");
                        continue;
                    }
                    out.println(inst.getKlass().getName().asString());
                    continue;
                }
                if (value.isObjArray()) {
                    ObjArray oa = (ObjArray)value;
                    ObjArrayKlass ek = (ObjArrayKlass)oa.getKlass();
                    out.println(oa.getLength() + " " + ek.getName().asString());
                    continue;
                }
                if (value.isTypeArray()) {
                    TypeArray ta = (TypeArray)value;
                    out.println(ta.getLength());
                    continue;
                }
                out.println(value);
            }
        }
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                InstanceKlass.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }

    public static class StaticField {
        public AccessFlags flags;
        public Field field;

        StaticField(Field field, AccessFlags flags) {
            this.field = field;
            this.flags = flags;
        }
    }

    public static interface EnclosingMethodAttributeOffset {
        public static final int enclosing_method_class_index_offset = 0;
        public static final int enclosing_method_method_index_offset = 1;
        public static final int enclosing_method_attribute_size = 2;
    }

    public static interface InnerClassAttributeOffset {
        public static final int innerClassInnerClassInfoOffset = 0;
        public static final int innerClassOuterClassInfoOffset = 1;
        public static final int innerClassInnerNameOffset = 2;
        public static final int innerClassAccessFlagsOffset = 3;
        public static final int innerClassNextOffset = 4;
    }

    public static class ClassState {
        public static final ClassState ALLOCATED = new ClassState("allocated");
        public static final ClassState LOADED = new ClassState("loaded");
        public static final ClassState LINKED = new ClassState("linked");
        public static final ClassState BEING_INITIALIZED = new ClassState("beingInitialized");
        public static final ClassState FULLY_INITIALIZED = new ClassState("fullyInitialized");
        public static final ClassState INITIALIZATION_ERROR = new ClassState("initializationError");
        private String value;

        private ClassState(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

