/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.FilePermission;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.LinkOption;
import java.nio.file.LinkPermission;
import java.nio.file.NotDirectoryException;
import java.nio.file.NotLinkException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.spi.FileTypeDetector;
import java.security.Permission;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import sun.nio.ch.ThreadPool;
import sun.nio.fs.AbstractFileSystemProvider;
import sun.nio.fs.AbstractFileTypeDetector;
import sun.nio.fs.DynamicFileAttributeView;
import sun.nio.fs.UnixChannelFactory;
import sun.nio.fs.UnixCopyFile;
import sun.nio.fs.UnixDirectoryStream;
import sun.nio.fs.UnixException;
import sun.nio.fs.UnixFileAttributeViews;
import sun.nio.fs.UnixFileAttributes;
import sun.nio.fs.UnixFileModeAttribute;
import sun.nio.fs.UnixFileSystem;
import sun.nio.fs.UnixNativeDispatcher;
import sun.nio.fs.UnixPath;
import sun.nio.fs.UnixSecureDirectoryStream;
import sun.nio.fs.UnixUriUtils;
import sun.nio.fs.Util;

public abstract class UnixFileSystemProvider
extends AbstractFileSystemProvider {
    private static final String USER_DIR = "user.dir";
    private final UnixFileSystem theFileSystem;

    public UnixFileSystemProvider() {
        String string = System.getProperty(USER_DIR);
        this.theFileSystem = this.newFileSystem(string);
    }

    abstract UnixFileSystem newFileSystem(String var1);

    @Override
    public final String getScheme() {
        return "file";
    }

    private void checkUri(URI uRI) {
        if (!uRI.getScheme().equalsIgnoreCase(this.getScheme())) {
            throw new IllegalArgumentException("URI does not match this provider");
        }
        if (uRI.getAuthority() != null) {
            throw new IllegalArgumentException("Authority component present");
        }
        if (uRI.getPath() == null) {
            throw new IllegalArgumentException("Path component is undefined");
        }
        if (!uRI.getPath().equals("/")) {
            throw new IllegalArgumentException("Path component should be '/'");
        }
        if (uRI.getQuery() != null) {
            throw new IllegalArgumentException("Query component present");
        }
        if (uRI.getFragment() != null) {
            throw new IllegalArgumentException("Fragment component present");
        }
    }

    @Override
    public final FileSystem newFileSystem(URI uRI, Map<String, ?> map) {
        this.checkUri(uRI);
        throw new FileSystemAlreadyExistsException();
    }

    @Override
    public final FileSystem getFileSystem(URI uRI) {
        this.checkUri(uRI);
        return this.theFileSystem;
    }

    @Override
    public Path getPath(URI uRI) {
        return UnixUriUtils.fromUri(this.theFileSystem, uRI);
    }

    UnixPath checkPath(Path path) {
        if (path == null) {
            throw new NullPointerException();
        }
        if (!(path instanceof UnixPath)) {
            throw new ProviderMismatchException();
        }
        return (UnixPath)path;
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> clazz, LinkOption ... linkOptionArray) {
        UnixPath unixPath = UnixPath.toUnixPath(path);
        boolean bl = Util.followLinks(linkOptionArray);
        if (clazz == BasicFileAttributeView.class) {
            return (V)UnixFileAttributeViews.createBasicView(unixPath, bl);
        }
        if (clazz == PosixFileAttributeView.class) {
            return (V)UnixFileAttributeViews.createPosixView(unixPath, bl);
        }
        if (clazz == FileOwnerAttributeView.class) {
            return (V)UnixFileAttributeViews.createOwnerView(unixPath, bl);
        }
        if (clazz == null) {
            throw new NullPointerException();
        }
        return (V)((FileAttributeView)null);
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> clazz, LinkOption ... linkOptionArray) throws IOException {
        Class<BasicFileAttributeView> clazz2;
        if (clazz == BasicFileAttributes.class) {
            clazz2 = BasicFileAttributeView.class;
        } else if (clazz == PosixFileAttributes.class) {
            clazz2 = PosixFileAttributeView.class;
        } else {
            if (clazz == null) {
                throw new NullPointerException();
            }
            throw new UnsupportedOperationException();
        }
        return (A)this.getFileAttributeView(path, clazz2, linkOptionArray).readAttributes();
    }

    @Override
    protected DynamicFileAttributeView getFileAttributeView(Path path, String string, LinkOption ... linkOptionArray) {
        UnixPath unixPath = UnixPath.toUnixPath(path);
        boolean bl = Util.followLinks(linkOptionArray);
        if (string.equals("basic")) {
            return UnixFileAttributeViews.createBasicView(unixPath, bl);
        }
        if (string.equals("posix")) {
            return UnixFileAttributeViews.createPosixView(unixPath, bl);
        }
        if (string.equals("unix")) {
            return UnixFileAttributeViews.createUnixView(unixPath, bl);
        }
        if (string.equals("owner")) {
            return UnixFileAttributeViews.createOwnerView(unixPath, bl);
        }
        return null;
    }

    @Override
    public FileChannel newFileChannel(Path path, Set<? extends OpenOption> set, FileAttribute<?> ... fileAttributeArray) throws IOException {
        UnixPath unixPath = this.checkPath(path);
        int n = UnixFileModeAttribute.toUnixMode(438, fileAttributeArray);
        try {
            return UnixChannelFactory.newFileChannel(unixPath, set, n);
        }
        catch (UnixException unixException) {
            unixException.rethrowAsIOException(unixPath);
            return null;
        }
    }

    @Override
    public AsynchronousFileChannel newAsynchronousFileChannel(Path path, Set<? extends OpenOption> set, ExecutorService executorService, FileAttribute<?> ... fileAttributeArray) throws IOException {
        UnixPath unixPath = this.checkPath(path);
        int n = UnixFileModeAttribute.toUnixMode(438, fileAttributeArray);
        ThreadPool threadPool = executorService == null ? null : ThreadPool.wrap(executorService, 0);
        try {
            return UnixChannelFactory.newAsynchronousFileChannel(unixPath, set, n, threadPool);
        }
        catch (UnixException unixException) {
            unixException.rethrowAsIOException(unixPath);
            return null;
        }
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> set, FileAttribute<?> ... fileAttributeArray) throws IOException {
        UnixPath unixPath = UnixPath.toUnixPath(path);
        int n = UnixFileModeAttribute.toUnixMode(438, fileAttributeArray);
        try {
            return UnixChannelFactory.newFileChannel(unixPath, set, n);
        }
        catch (UnixException unixException) {
            unixException.rethrowAsIOException(unixPath);
            return null;
        }
    }

    @Override
    boolean implDelete(Path path, boolean bl) throws IOException {
        UnixPath unixPath = UnixPath.toUnixPath(path);
        unixPath.checkDelete();
        UnixFileAttributes unixFileAttributes = null;
        try {
            unixFileAttributes = UnixFileAttributes.get(unixPath, false);
            if (unixFileAttributes.isDirectory()) {
                UnixNativeDispatcher.rmdir(unixPath);
            } else {
                UnixNativeDispatcher.unlink(unixPath);
            }
            return true;
        }
        catch (UnixException unixException) {
            if (!bl && unixException.errno() == 2) {
                return false;
            }
            if (unixFileAttributes != null && unixFileAttributes.isDirectory() && (unixException.errno() == 17 || unixException.errno() == 93)) {
                throw new DirectoryNotEmptyException(unixPath.getPathForExceptionMessage());
            }
            unixException.rethrowAsIOException(unixPath);
            return false;
        }
    }

    @Override
    public void copy(Path path, Path path2, CopyOption ... copyOptionArray) throws IOException {
        UnixCopyFile.copy(UnixPath.toUnixPath(path), UnixPath.toUnixPath(path2), copyOptionArray);
    }

    @Override
    public void move(Path path, Path path2, CopyOption ... copyOptionArray) throws IOException {
        UnixCopyFile.move(UnixPath.toUnixPath(path), UnixPath.toUnixPath(path2), copyOptionArray);
    }

    @Override
    public void checkAccess(Path path, AccessMode ... accessModeArray) throws IOException {
        UnixPath unixPath = UnixPath.toUnixPath(path);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (accessModeArray.length == 0) {
            bl = true;
        } else {
            block7: for (AccessMode accessMode : accessModeArray) {
                switch (accessMode) {
                    case READ: {
                        bl2 = true;
                        continue block7;
                    }
                    case WRITE: {
                        bl3 = true;
                        continue block7;
                    }
                    case EXECUTE: {
                        bl4 = true;
                        continue block7;
                    }
                    default: {
                        throw new AssertionError((Object)"Should not get here");
                    }
                }
            }
        }
        int n = 0;
        if (bl || bl2) {
            unixPath.checkRead();
            n |= bl2 ? 4 : 0;
        }
        if (bl3) {
            unixPath.checkWrite();
            n |= 2;
        }
        if (bl4) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkExec(unixPath.getPathForPermissionCheck());
            }
            n |= 1;
        }
        try {
            UnixNativeDispatcher.access(unixPath, n);
        }
        catch (UnixException unixException) {
            unixException.rethrowAsIOException(unixPath);
        }
    }

    @Override
    public boolean isSameFile(Path path, Path path2) throws IOException {
        UnixFileAttributes unixFileAttributes;
        UnixFileAttributes unixFileAttributes2;
        UnixPath unixPath = UnixPath.toUnixPath(path);
        if (unixPath.equals(path2)) {
            return true;
        }
        if (path2 == null) {
            throw new NullPointerException();
        }
        if (!(path2 instanceof UnixPath)) {
            return false;
        }
        UnixPath unixPath2 = (UnixPath)path2;
        unixPath.checkRead();
        unixPath2.checkRead();
        try {
            unixFileAttributes2 = UnixFileAttributes.get(unixPath, true);
        }
        catch (UnixException unixException) {
            unixException.rethrowAsIOException(unixPath);
            return false;
        }
        try {
            unixFileAttributes = UnixFileAttributes.get(unixPath2, true);
        }
        catch (UnixException unixException) {
            unixException.rethrowAsIOException(unixPath2);
            return false;
        }
        return unixFileAttributes2.isSameFile(unixFileAttributes);
    }

    @Override
    public boolean isHidden(Path path) {
        UnixPath unixPath = UnixPath.toUnixPath(path);
        unixPath.checkRead();
        UnixPath unixPath2 = unixPath.getFileName();
        if (unixPath2 == null) {
            return false;
        }
        return unixPath2.asByteArray()[0] == 46;
    }

    abstract FileStore getFileStore(UnixPath var1) throws IOException;

    @Override
    public FileStore getFileStore(Path path) throws IOException {
        UnixPath unixPath = UnixPath.toUnixPath(path);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("getFileStoreAttributes"));
            unixPath.checkRead();
        }
        return this.getFileStore(unixPath);
    }

    @Override
    public void createDirectory(Path path, FileAttribute<?> ... fileAttributeArray) throws IOException {
        UnixPath unixPath = UnixPath.toUnixPath(path);
        unixPath.checkWrite();
        int n = UnixFileModeAttribute.toUnixMode(511, fileAttributeArray);
        try {
            UnixNativeDispatcher.mkdir(unixPath, n);
        }
        catch (UnixException unixException) {
            if (unixException.errno() == 21) {
                throw new FileAlreadyExistsException(unixPath.toString());
            }
            unixException.rethrowAsIOException(unixPath);
        }
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path path, DirectoryStream.Filter<? super Path> filter) throws IOException {
        UnixPath unixPath = UnixPath.toUnixPath(path);
        unixPath.checkRead();
        if (filter == null) {
            throw new NullPointerException();
        }
        if (!UnixNativeDispatcher.openatSupported()) {
            try {
                long l = UnixNativeDispatcher.opendir(unixPath);
                return new UnixDirectoryStream(unixPath, l, filter);
            }
            catch (UnixException unixException) {
                if (unixException.errno() == 20) {
                    throw new NotDirectoryException(unixPath.getPathForExceptionMessage());
                }
                unixException.rethrowAsIOException(unixPath);
            }
        }
        int n = -1;
        int n2 = -1;
        long l = 0L;
        try {
            n = UnixNativeDispatcher.open(unixPath, 0, 0);
            n2 = UnixNativeDispatcher.dup(n);
            l = UnixNativeDispatcher.fdopendir(n);
        }
        catch (UnixException unixException) {
            if (n != -1) {
                UnixNativeDispatcher.close(n);
            }
            if (n2 != -1) {
                UnixNativeDispatcher.close(n2);
            }
            if (unixException.errno() == 20) {
                throw new NotDirectoryException(unixPath.getPathForExceptionMessage());
            }
            unixException.rethrowAsIOException(unixPath);
        }
        return new UnixSecureDirectoryStream(unixPath, l, n2, filter);
    }

    @Override
    public void createSymbolicLink(Path path, Path path2, FileAttribute<?> ... fileAttributeArray) throws IOException {
        UnixPath unixPath = UnixPath.toUnixPath(path);
        UnixPath unixPath2 = UnixPath.toUnixPath(path2);
        if (fileAttributeArray.length > 0) {
            UnixFileModeAttribute.toUnixMode(0, fileAttributeArray);
            throw new UnsupportedOperationException("Initial file attributesnot supported when creating symbolic link");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new LinkPermission("symbolic"));
            unixPath.checkWrite();
        }
        try {
            UnixNativeDispatcher.symlink(unixPath2.asByteArray(), unixPath);
        }
        catch (UnixException unixException) {
            unixException.rethrowAsIOException(unixPath);
        }
    }

    @Override
    public void createLink(Path path, Path path2) throws IOException {
        UnixPath unixPath = UnixPath.toUnixPath(path);
        UnixPath unixPath2 = UnixPath.toUnixPath(path2);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new LinkPermission("hard"));
            unixPath.checkWrite();
            unixPath2.checkWrite();
        }
        try {
            UnixNativeDispatcher.link(unixPath2, unixPath);
        }
        catch (UnixException unixException) {
            unixException.rethrowAsIOException(unixPath, unixPath2);
        }
    }

    @Override
    public Path readSymbolicLink(Path path) throws IOException {
        Object object;
        UnixPath unixPath = UnixPath.toUnixPath(path);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            object = new FilePermission(unixPath.getPathForPermissionCheck(), "readlink");
            securityManager.checkPermission((Permission)object);
        }
        try {
            object = UnixNativeDispatcher.readlink(unixPath);
            return new UnixPath(unixPath.getFileSystem(), (byte[])object);
        }
        catch (UnixException unixException) {
            if (unixException.errno() == 22) {
                throw new NotLinkException(unixPath.getPathForExceptionMessage());
            }
            unixException.rethrowAsIOException(unixPath);
            return null;
        }
    }

    FileTypeDetector getFileTypeDetector() {
        return new AbstractFileTypeDetector(){

            @Override
            public String implProbeContentType(Path path) {
                return null;
            }
        };
    }

    final FileTypeDetector chain(final AbstractFileTypeDetector ... abstractFileTypeDetectorArray) {
        return new AbstractFileTypeDetector(){

            @Override
            protected String implProbeContentType(Path path) throws IOException {
                for (AbstractFileTypeDetector abstractFileTypeDetector : abstractFileTypeDetectorArray) {
                    String string = abstractFileTypeDetector.implProbeContentType(path);
                    if (string == null || string.isEmpty()) continue;
                    return string;
                }
                return null;
            }
        };
    }
}

