/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import sun.security.provider.certpath.BuildStep;
import sun.security.provider.certpath.Vertex;

public class AdjacencyList {
    private ArrayList<BuildStep> mStepList = new ArrayList();
    private List<List<Vertex>> mOrigList;

    public AdjacencyList(List<List<Vertex>> list) {
        this.mOrigList = list;
        this.buildList(list, 0, null);
    }

    public Iterator<BuildStep> iterator() {
        return Collections.unmodifiableList(this.mStepList).iterator();
    }

    public int numAttemptedPaths() {
        return this.mOrigList.size();
    }

    private boolean buildList(List<List<Vertex>> list, int n, BuildStep buildStep) {
        List<Vertex> list2 = list.get(n);
        boolean bl = true;
        boolean bl2 = true;
        for (Vertex object : list2) {
            if (object.getIndex() != -1) {
                if (list.get(object.getIndex()).size() != 0) {
                    bl = false;
                }
            } else if (object.getThrowable() == null) {
                bl2 = false;
            }
            this.mStepList.add(new BuildStep(object, 1));
        }
        if (bl) {
            if (bl2) {
                if (buildStep == null) {
                    this.mStepList.add(new BuildStep(null, 4));
                } else {
                    this.mStepList.add(new BuildStep(buildStep.getVertex(), 2));
                }
                return false;
            }
            ArrayList arrayList = new ArrayList();
            for (Vertex vertex : list2) {
                if (vertex.getThrowable() != null) continue;
                arrayList.add(vertex);
            }
            if (arrayList.size() == 1) {
                this.mStepList.add(new BuildStep((Vertex)arrayList.get(0), 5));
            } else {
                this.mStepList.add(new BuildStep((Vertex)arrayList.get(0), 5));
            }
            return true;
        }
        boolean bl3 = false;
        for (Vertex vertex : list2) {
            if (vertex.getIndex() == -1 || list.get(vertex.getIndex()).size() == 0) continue;
            BuildStep buildStep2 = new BuildStep(vertex, 3);
            this.mStepList.add(buildStep2);
            bl3 = this.buildList(list, vertex.getIndex(), buildStep2);
        }
        if (bl3) {
            return true;
        }
        if (buildStep == null) {
            this.mStepList.add(new BuildStep(null, 4));
        } else {
            this.mStepList.add(new BuildStep(buildStep.getVertex(), 2));
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[\n");
        int n = 0;
        for (List<Vertex> list : this.mOrigList) {
            stringBuilder.append("LinkedList[").append(n++).append("]:\n");
            for (Vertex vertex : list) {
                stringBuilder.append(vertex.toString()).append("\n");
            }
        }
        stringBuilder.append("]\n");
        return stringBuilder.toString();
    }
}

