/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.util.Locale;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.GeneralNameInterface;

public class DNSName
implements GeneralNameInterface {
    private String name;
    private static final String alphaDigits = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";

    public DNSName(DerValue derValue) throws IOException {
        this.name = derValue.getIA5String();
    }

    public DNSName(String string, boolean bl) throws IOException {
        if (string == null || string.length() == 0) {
            throw new IOException("DNSName must not be null or empty");
        }
        if (string.contains(" ")) {
            throw new IOException("DNSName with blank components is not permitted");
        }
        if (string.startsWith(".") || string.endsWith(".")) {
            throw new IOException("DNSName may not begin or end with a .");
        }
        int n = 0;
        while (n < string.length()) {
            int n2 = string.indexOf(46, n);
            if (n2 < 0) {
                n2 = string.length();
            }
            if (n2 - n < 1) {
                throw new IOException("DNSName with empty components are not permitted");
            }
            if (bl) {
                if (alphaDigits.indexOf(string.charAt(n)) < 0 && (string.length() < 3 || string.indexOf(42, 0) != 0 || string.charAt(n + 1) != '.' || alphaDigits.indexOf(string.charAt(n + 2)) < 0)) {
                    throw new IOException("DNSName components must begin with a letter, digit, or the first component can have only a wildcard character *");
                }
            } else if (alphaDigits.indexOf(string.charAt(n)) < 0) {
                throw new IOException("DNSName components must begin with a letter or digit");
            }
            for (int i = n + 1; i < n2; ++i) {
                char c = string.charAt(i);
                if (alphaDigits.indexOf(c) >= 0 || c == '-') continue;
                throw new IOException("DNSName components must consist of letters, digits, and hyphens");
            }
            n = n2 + 1;
        }
        this.name = string;
    }

    public DNSName(String string) throws IOException {
        this(string, false);
    }

    @Override
    public int getType() {
        return 2;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void encode(DerOutputStream derOutputStream) throws IOException {
        derOutputStream.putIA5String(this.name);
    }

    public String toString() {
        return "DNSName: " + this.name;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DNSName)) {
            return false;
        }
        DNSName dNSName = (DNSName)object;
        return this.name.equalsIgnoreCase(dNSName.name);
    }

    public int hashCode() {
        return this.name.toUpperCase(Locale.ENGLISH).hashCode();
    }

    @Override
    public int constrains(GeneralNameInterface generalNameInterface) throws UnsupportedOperationException {
        int n;
        int n2;
        String string;
        String string2;
        int n3 = generalNameInterface == null ? -1 : (generalNameInterface.getType() != 2 ? -1 : ((string2 = ((DNSName)generalNameInterface).getName().toLowerCase(Locale.ENGLISH)).equals(string = this.name.toLowerCase(Locale.ENGLISH)) ? 0 : (string.endsWith(string2) ? (string.charAt((n2 = string.lastIndexOf(string2)) - 1) == '.' ? 2 : 3) : (string2.endsWith(string) ? (string2.charAt((n = string2.lastIndexOf(string)) - 1) == '.' ? 1 : 3) : 3))));
        return n3;
    }

    @Override
    public int subtreeDepth() throws UnsupportedOperationException {
        int n = 1;
        int n2 = this.name.indexOf(46);
        while (n2 >= 0) {
            ++n;
            n2 = this.name.indexOf(46, n2 + 1);
        }
        return n;
    }
}

