/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.utilities;

import java.util.LinkedList;
import sun.jvm.hotspot.utilities.MessageQueue;

public class MessageQueueBackend {
    private MessageQueueImpl leftRightQueue;
    private MessageQueueImpl rightLeftQueue;

    public MessageQueueBackend() {
        LinkedList leftRightPipe = new LinkedList();
        LinkedList rightLeftPipe = new LinkedList();
        this.leftRightQueue = new MessageQueueImpl(rightLeftPipe, leftRightPipe);
        this.rightLeftQueue = new MessageQueueImpl(leftRightPipe, rightLeftPipe);
    }

    public MessageQueue getFirstQueue() {
        return this.leftRightQueue;
    }

    public MessageQueue getSecondQueue() {
        return this.rightLeftQueue;
    }

    private class MessageQueueImpl
    implements MessageQueue {
        private LinkedList readList;
        private LinkedList writeList;

        public MessageQueueImpl(LinkedList listToReadFrom, LinkedList listToWriteTo) {
            this.readList = listToReadFrom;
            this.writeList = listToWriteTo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object readMessage() {
            LinkedList linkedList = this.readList;
            synchronized (linkedList) {
                while (this.readList.isEmpty()) {
                    try {
                        this.readList.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return this.readList.removeFirst();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object readMessageWithTimeout(long millis) {
            LinkedList linkedList = this.readList;
            synchronized (linkedList) {
                if (this.readList.isEmpty()) {
                    if (millis == 0L) {
                        return null;
                    }
                    try {
                        this.readList.wait(millis);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                if (this.readList.isEmpty()) {
                    return null;
                }
                return this.readList.removeFirst();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeMessage(Object obj) {
            LinkedList linkedList = this.writeList;
            synchronized (linkedList) {
                this.writeList.addLast(obj);
                this.writeList.notify();
            }
        }
    }
}

