/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.tool;

import java.io.PrintWriter;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import jdk.jfr.AnnotationElement;
import jdk.jfr.DataAmount;
import jdk.jfr.Frequency;
import jdk.jfr.MemoryAddress;
import jdk.jfr.Percentage;
import jdk.jfr.ValueDescriptor;
import jdk.jfr.consumer.RecordedClass;
import jdk.jfr.consumer.RecordedClassLoader;
import jdk.jfr.consumer.RecordedEvent;
import jdk.jfr.consumer.RecordedFrame;
import jdk.jfr.consumer.RecordedMethod;
import jdk.jfr.consumer.RecordedObject;
import jdk.jfr.consumer.RecordedStackTrace;
import jdk.jfr.consumer.RecordedThread;
import jdk.jfr.internal.PrivateAccess;
import jdk.jfr.internal.Type;
import jdk.jfr.internal.Utils;
import jdk.jfr.internal.tool.EventPrintWriter;

public final class PrettyWriter
extends EventPrintWriter {
    private static final String TYPE_OLD_OBJECT = "jdk.types.OldObject";
    private static final DateTimeFormatter TIME_FORMAT = DateTimeFormatter.ofPattern("HH:mm:ss.SSS");
    private static final Long ZERO = 0L;
    private boolean showIds;
    private RecordedEvent currentEvent;

    public PrettyWriter(PrintWriter printWriter) {
        super(printWriter);
    }

    @Override
    protected void print(List<RecordedEvent> list) {
        for (RecordedEvent recordedEvent : list) {
            this.print(recordedEvent);
            this.flush(false);
        }
    }

    public void printType(Type type) {
        if (this.showIds) {
            this.print("// id: ");
            this.println(String.valueOf(type.getId()));
        }
        int n = type.getName().length() + 10;
        String string = type.getName();
        int n2 = string.lastIndexOf(".");
        if (n2 != -1) {
            this.println("@Name(\"" + string + "\")");
        }
        this.printAnnotations(n, type.getAnnotationElements());
        this.print("class " + string.substring(n2 + 1));
        String string2 = type.getSuperType();
        if (string2 != null) {
            this.print(" extends " + string2);
        }
        this.println(" {");
        this.indent();
        boolean bl = true;
        for (ValueDescriptor valueDescriptor : type.getFields()) {
            this.printField(n, valueDescriptor, bl);
            bl = false;
        }
        this.retract();
        this.println("}");
        this.println();
    }

    private void printField(int n, ValueDescriptor valueDescriptor, boolean bl) {
        if (!bl) {
            this.println();
        }
        this.printAnnotations(n, valueDescriptor.getAnnotationElements());
        this.printIndent();
        Type type = PrivateAccess.getInstance().getType(valueDescriptor);
        if (Type.SUPER_TYPE_SETTING.equals(type.getSuperType())) {
            this.print("static ");
        }
        this.print(this.makeSimpleType(valueDescriptor.getTypeName()));
        if (valueDescriptor.isArray()) {
            this.print("[]");
        }
        this.print(" ");
        this.print(valueDescriptor.getName());
        this.print(";");
        this.printCommentRef(n, valueDescriptor.getTypeId());
    }

    private void printCommentRef(int n, long l) {
        if (this.showIds) {
            int n2 = this.getColumn();
            if (n2 > n) {
                this.print("  ");
            } else {
                while (n2 < n) {
                    this.print(" ");
                    ++n2;
                }
            }
            this.println(" // id=" + l);
        } else {
            this.println();
        }
    }

    private void printAnnotations(int n, List<AnnotationElement> list) {
        for (AnnotationElement annotationElement : list) {
            this.printIndent();
            this.print("@");
            this.print(this.makeSimpleType(annotationElement.getTypeName()));
            List<ValueDescriptor> list2 = annotationElement.getValueDescriptors();
            if (!list2.isEmpty()) {
                this.printAnnotation(annotationElement);
                this.printCommentRef(n, annotationElement.getTypeId());
                continue;
            }
            this.println();
        }
    }

    private void printAnnotation(AnnotationElement annotationElement) {
        StringJoiner stringJoiner = new StringJoiner(", ", "(", ")");
        List<ValueDescriptor> list = annotationElement.getValueDescriptors();
        for (ValueDescriptor valueDescriptor : list) {
            Object object = annotationElement.getValue(valueDescriptor.getName());
            if (list.size() == 1 && valueDescriptor.getName().equals("value")) {
                stringJoiner.add(this.textify(object));
                continue;
            }
            stringJoiner.add(valueDescriptor.getName() + "=" + this.textify(object));
        }
        this.print(stringJoiner.toString());
    }

    private String textify(Object object) {
        if (object.getClass().isArray()) {
            Object[] objectArray = (Object[])object;
            if (objectArray.length == 1) {
                return this.quoteIfNeeded(objectArray[0]);
            }
            StringJoiner stringJoiner = new StringJoiner(", ", "{", "}");
            for (Object object2 : objectArray) {
                stringJoiner.add(this.quoteIfNeeded(object2));
            }
            return stringJoiner.toString();
        }
        return this.quoteIfNeeded(object);
    }

    private String quoteIfNeeded(Object object) {
        if (object instanceof String) {
            return "\"" + object + "\"";
        }
        return String.valueOf(object);
    }

    private String makeSimpleType(String string) {
        int n = string.lastIndexOf(".");
        return string.substring(n + 1);
    }

    public void print(RecordedEvent recordedEvent) {
        this.currentEvent = recordedEvent;
        this.print(recordedEvent.getEventType().getName(), " ");
        this.println("{");
        this.indent();
        for (ValueDescriptor valueDescriptor : recordedEvent.getFields()) {
            String string = valueDescriptor.getName();
            if (this.isZeroDuration(recordedEvent, string) || this.isLateField(string)) continue;
            this.printFieldValue(recordedEvent, valueDescriptor);
        }
        if (recordedEvent.getThread() != null) {
            this.printIndent();
            this.print("eventThread = ");
            this.printThread(recordedEvent.getThread(), "");
        }
        if (recordedEvent.getStackTrace() != null) {
            this.printIndent();
            this.print("stackTrace = ");
            this.printStackTrace(recordedEvent.getStackTrace());
        }
        this.retract();
        this.printIndent();
        this.println("}");
        this.println();
    }

    private boolean isZeroDuration(RecordedEvent recordedEvent, String string) {
        return string.equals("duration") && ZERO.equals(recordedEvent.getValue("duration"));
    }

    private void printStackTrace(RecordedStackTrace recordedStackTrace) {
        this.println("[");
        List<RecordedFrame> list = recordedStackTrace.getFrames();
        this.indent();
        int n = 0;
        while (n < list.size() && n < this.getStackDepth()) {
            RecordedFrame recordedFrame = list.get(n);
            if (!recordedFrame.isJavaFrame()) continue;
            this.printIndent();
            this.printValue(recordedFrame, null, "");
            this.println();
            ++n;
        }
        if (recordedStackTrace.isTruncated() || n == this.getStackDepth()) {
            this.printIndent();
            this.println("...");
        }
        this.retract();
        this.printIndent();
        this.println("]");
    }

    public void print(RecordedObject recordedObject, String string) {
        this.println("{");
        this.indent();
        for (ValueDescriptor valueDescriptor : recordedObject.getFields()) {
            this.printFieldValue(recordedObject, valueDescriptor);
        }
        this.retract();
        this.printIndent();
        this.println("}" + string);
    }

    private void printFieldValue(RecordedObject recordedObject, ValueDescriptor valueDescriptor) {
        this.printIndent();
        this.print(valueDescriptor.getName(), " = ");
        this.printValue(this.getValue(recordedObject, valueDescriptor), valueDescriptor, "");
    }

    private void printArray(Object[] objectArray) {
        this.println("[");
        this.indent();
        for (int i = 0; i < objectArray.length; ++i) {
            this.printIndent();
            this.printValue(objectArray[i], null, i + 1 < objectArray.length ? ", " : "");
        }
        this.retract();
        this.printIndent();
        this.println("]");
    }

    private void printValue(Object object, ValueDescriptor valueDescriptor, String string) {
        Object object2;
        if (object == null) {
            this.println("N/A" + string);
            return;
        }
        if (object instanceof RecordedObject) {
            RecordedFrame recordedFrame;
            if (object instanceof RecordedThread) {
                this.printThread((RecordedThread)object, string);
                return;
            }
            if (object instanceof RecordedClass) {
                this.printClass((RecordedClass)object, string);
                return;
            }
            if (object instanceof RecordedClassLoader) {
                this.printClassLoader((RecordedClassLoader)object, string);
                return;
            }
            if (object instanceof RecordedFrame && (recordedFrame = (RecordedFrame)object).isJavaFrame()) {
                this.printJavaFrame((RecordedFrame)object, string);
                return;
            }
            if (object instanceof RecordedMethod) {
                this.println(this.formatMethod((RecordedMethod)object));
                return;
            }
            if (valueDescriptor.getTypeName().equals(TYPE_OLD_OBJECT)) {
                this.printOldObject((RecordedObject)object);
                return;
            }
            this.print((RecordedObject)object, string);
            return;
        }
        if (object.getClass().isArray()) {
            this.printArray((Object[])object);
            return;
        }
        if (object instanceof Double && (Double.isNaN((Double)(object2 = (Double)object)) || (Double)object2 == Double.NEGATIVE_INFINITY)) {
            this.println("N/A");
            return;
        }
        if (object instanceof Float && (Float.isNaN(((Float)(object2 = (Float)object)).floatValue()) || ((Float)object2).floatValue() == Float.NEGATIVE_INFINITY)) {
            this.println("N/A");
            return;
        }
        if (object instanceof Long && (Long)(object2 = (Long)object) == Long.MIN_VALUE) {
            this.println("N/A");
            return;
        }
        if (object instanceof Integer && (Integer)(object2 = (Integer)object) == Integer.MIN_VALUE) {
            this.println("N/A");
            return;
        }
        if (valueDescriptor.getContentType() != null && this.printFormatted(valueDescriptor, object)) {
            return;
        }
        object2 = String.valueOf(object);
        if (object instanceof String) {
            object2 = "\"" + (String)object2 + "\"";
        }
        this.println((String)object2);
    }

    private void printOldObject(RecordedObject recordedObject) {
        this.println(" [");
        this.indent();
        this.printIndent();
        try {
            this.printReferenceChain(recordedObject);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.retract();
        this.printIndent();
        this.println("]");
    }

    private void printReferenceChain(RecordedObject recordedObject) {
        this.printObject(recordedObject, this.currentEvent.getLong("arrayElements"));
        RecordedObject recordedObject2 = (RecordedObject)recordedObject.getValue("referrer");
        while (recordedObject2 != null) {
            RecordedObject recordedObject3;
            long l = recordedObject2.getLong("skip");
            if (l > 0L) {
                this.printIndent();
                this.println("...");
            }
            String string = "";
            long l2 = Long.MIN_VALUE;
            RecordedObject recordedObject4 = (RecordedObject)recordedObject2.getValue("array");
            if (recordedObject4 != null) {
                long l3 = recordedObject4.getLong("index");
                l2 = recordedObject4.getLong("size");
                string = "[" + l3 + "]";
            }
            if ((recordedObject3 = (RecordedObject)recordedObject2.getValue("field")) != null) {
                string = recordedObject3.getString("name");
            }
            this.printIndent();
            this.print(string);
            this.print(" : ");
            recordedObject = (RecordedObject)recordedObject2.getValue("object");
            if (recordedObject != null) {
                this.printObject(recordedObject, l2);
            }
            recordedObject2 = (RecordedObject)recordedObject.getValue("referrer");
        }
    }

    void printObject(RecordedObject recordedObject, long l) {
        RecordedClass recordedClass = recordedObject.getClass("type");
        if (recordedClass != null) {
            String string = recordedClass.getName();
            if (string != null && string.startsWith("[")) {
                string = this.decodeDescriptors(string, l > 0L ? Long.toString(l) : "").get(0);
            }
            this.print(string);
            String string2 = recordedObject.getString("description");
            if (string2 != null) {
                this.print(" ");
                this.print(string2);
            }
        }
        this.println();
    }

    private void printClassLoader(RecordedClassLoader recordedClassLoader, String string) {
        RecordedClass recordedClass = recordedClassLoader.getType();
        this.print(recordedClass == null ? "null" : recordedClass.getName());
        if (recordedClass != null) {
            this.print(" (");
            this.print("id = ");
            this.print(String.valueOf(recordedClassLoader.getId()));
            this.println(")");
        }
    }

    private void printJavaFrame(RecordedFrame recordedFrame, String string) {
        this.print(this.formatMethod(recordedFrame.getMethod()));
        int n = recordedFrame.getLineNumber();
        if (n >= 0) {
            this.print(" line: " + n);
        }
        this.print(string);
    }

    private String formatMethod(RecordedMethod recordedMethod) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(recordedMethod.getType().getName());
        stringBuilder.append(".");
        stringBuilder.append(recordedMethod.getName());
        stringBuilder.append("(");
        StringJoiner stringJoiner = new StringJoiner(", ");
        String string = recordedMethod.getDescriptor().replace("/", ".");
        String string2 = string.substring(1, string.lastIndexOf(")"));
        for (String string3 : this.decodeDescriptors(string2, "")) {
            String string4 = string3.substring(string3.lastIndexOf(46) + 1);
            stringJoiner.add(string4);
        }
        stringBuilder.append(stringJoiner);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    private void printClass(RecordedClass recordedClass, String string) {
        String string2;
        RecordedClassLoader recordedClassLoader = recordedClass.getClassLoader();
        String string3 = "null";
        if (recordedClassLoader != null) {
            string3 = recordedClassLoader.getName() != null ? recordedClassLoader.getName() : recordedClassLoader.getType().getName();
        }
        if ((string2 = recordedClass.getName()).startsWith("[")) {
            string2 = this.decodeDescriptors(string2, "").get(0);
        }
        this.println(string2 + " (classLoader = " + string3 + ")" + string);
    }

    List<String> decodeDescriptors(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < string.length(); ++i) {
            String string3;
            String string4 = "";
            while (string.charAt(i) == '[') {
                string4 = string4 + "[" + string2 + "]";
                string2 = "";
                ++i;
            }
            char c = string.charAt(i);
            switch (c) {
                case 'L': {
                    int n = string.indexOf(59, i);
                    string3 = string.substring(i + 1, n);
                    i = n;
                    break;
                }
                case 'I': {
                    string3 = "int";
                    break;
                }
                case 'J': {
                    string3 = "long";
                    break;
                }
                case 'Z': {
                    string3 = "boolean";
                    break;
                }
                case 'D': {
                    string3 = "double";
                    break;
                }
                case 'F': {
                    string3 = "float";
                    break;
                }
                case 'S': {
                    string3 = "short";
                    break;
                }
                case 'C': {
                    string3 = "char";
                    break;
                }
                case 'B': {
                    string3 = "byte";
                    break;
                }
                default: {
                    string3 = "<unknown-descriptor-type>";
                }
            }
            arrayList.add(string3 + string4);
        }
        return arrayList;
    }

    private void printThread(RecordedThread recordedThread, String string) {
        long l = recordedThread.getJavaThreadId();
        if (l > 0L) {
            this.println("\"" + recordedThread.getJavaName() + "\" (javaThreadId = " + recordedThread.getJavaThreadId() + ")" + string);
        } else {
            this.println("\"" + recordedThread.getOSName() + "\" (osThreadId = " + recordedThread.getOSThreadId() + ")" + string);
        }
    }

    private boolean printFormatted(ValueDescriptor valueDescriptor, Object object) {
        long l;
        Object object2;
        if (object instanceof Duration) {
            Duration duration = (Duration)object;
            if (duration.getSeconds() == Long.MIN_VALUE && duration.getNano() == 0) {
                this.println("N/A");
                return true;
            }
            double d = (double)duration.getNano() / 1.0E9 + (double)((int)(duration.getSeconds() % 60L));
            if (d < 1.0) {
                if (d < 0.001) {
                    this.println(String.format("%.3f", d * 1000000.0) + " us");
                } else {
                    this.println(String.format("%.3f", d * 1000.0) + " ms");
                }
            } else if (d < 1000.0) {
                this.println(String.format("%.3f", d) + " s");
            } else {
                this.println(String.format("%.0f", d) + " s");
            }
            return true;
        }
        if (object instanceof OffsetDateTime) {
            OffsetDateTime offsetDateTime = (OffsetDateTime)object;
            if (offsetDateTime.equals(OffsetDateTime.MIN)) {
                this.println("N/A");
                return true;
            }
            this.println(TIME_FORMAT.format(offsetDateTime));
            return true;
        }
        Percentage percentage = valueDescriptor.getAnnotation(Percentage.class);
        if (percentage != null && object instanceof Number) {
            double d = ((Number)object).doubleValue();
            this.println(String.format("%.2f", d * 100.0) + "%");
            return true;
        }
        DataAmount dataAmount = valueDescriptor.getAnnotation(DataAmount.class);
        if (dataAmount != null && object instanceof Number) {
            object2 = (Number)object;
            l = ((Number)object2).longValue();
            if (valueDescriptor.getAnnotation(Frequency.class) != null) {
                if (dataAmount.value().equals("BYTES")) {
                    this.println(Utils.formatBytesPerSecond(l));
                    return true;
                }
                if (dataAmount.value().equals("BITS")) {
                    this.println(Utils.formatBitsPerSecond(l));
                    return true;
                }
            } else {
                if (dataAmount.value().equals("BYTES")) {
                    this.println(Utils.formatBytes(l));
                    return true;
                }
                if (dataAmount.value().equals("BITS")) {
                    this.println(Utils.formatBits(l));
                    return true;
                }
            }
        }
        if ((object2 = valueDescriptor.getAnnotation(MemoryAddress.class)) != null && object instanceof Number) {
            l = ((Number)object).longValue();
            this.println(String.format("0x%08X", l));
            return true;
        }
        Frequency frequency = valueDescriptor.getAnnotation(Frequency.class);
        if (frequency != null && object instanceof Number) {
            this.println(object + " Hz");
            return true;
        }
        return false;
    }

    public void setShowIds(boolean bl) {
        this.showIds = bl;
    }
}

