/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.jfr;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import jdk.jfr.AnnotationElement;
import jdk.jfr.EventType;
import jdk.jfr.Recording;
import jdk.jfr.SettingDescriptor;
import jdk.jfr.Timespan;
import jdk.jfr.Timestamp;
import jdk.jfr.ValueDescriptor;
import jdk.jfr.consumer.RecordedClass;
import jdk.jfr.consumer.RecordedEvent;
import jdk.jfr.consumer.RecordedFrame;
import jdk.jfr.consumer.RecordedMethod;
import jdk.jfr.consumer.RecordedObject;
import jdk.jfr.consumer.RecordedStackTrace;
import jdk.jfr.consumer.RecordedThread;
import jdk.jfr.consumer.RecordedThreadGroup;
import jdk.jfr.consumer.RecordingFile;
import jdk.test.lib.Asserts;
import jdk.test.lib.jfr.EventField;

public class Events {
    private static long lastId = -1L;

    public static EventField assertField(RecordedEvent event, String name) {
        String[] partNames = name.split("\\.");
        RecordedObject struct = event;
        try {
            for (int i = 0; i < partNames.length; ++i) {
                String partName = partNames[i];
                boolean isLastPart = i == partNames.length - 1;
                ValueDescriptor d = Events.getValueDescriptor(struct, partName);
                if (isLastPart) {
                    return new EventField(struct, d);
                }
                Asserts.assertTrue(struct.getValue(partName) instanceof RecordedObject, "Expected '" + partName + "' to be a struct");
                struct = (RecordedObject)struct.getValue(partName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.printf("Failed event:%n%s%n", event.toString());
        Asserts.fail(String.format("Field %s not in event", name));
        return null;
    }

    private static RecordedObject getRecordedPackage(RecordedClass rc) {
        if (rc == null) {
            throw new RuntimeException("RecordedClass must not be null!");
        }
        return (RecordedObject)rc.getValue("package");
    }

    private static RecordedObject getRecordedModule(RecordedObject pkg) {
        if (pkg == null) {
            return null;
        }
        return (RecordedObject)pkg.getValue("module");
    }

    private static boolean isMatchingTargetName(RecordedObject ro, String targetName) {
        if (ro == null) {
            return targetName == null;
        }
        String recordedName = (String)ro.getValue("name");
        if (recordedName == null) {
            return targetName == null;
        }
        return recordedName.equals(targetName);
    }

    public static void assertClassPackage(RecordedClass rc, String packageNameTarget) {
        RecordedObject recordedPackage = Events.getRecordedPackage(rc);
        if (recordedPackage == null) {
            if (packageNameTarget != null) {
                throw new RuntimeException("RecordedClass package is null!");
            }
            return;
        }
        Asserts.assertTrue(Events.isMatchingTargetName(recordedPackage, packageNameTarget), "mismatched package name! Target is " + packageNameTarget);
    }

    public static void assertClassModule(RecordedClass rc, String moduleNameTarget) {
        RecordedObject recordedPackage = Events.getRecordedPackage(rc);
        RecordedObject recordedModule = Events.getRecordedModule(recordedPackage);
        if (recordedModule == null) {
            if (moduleNameTarget != null) {
                throw new RuntimeException("RecordedClass module is null!");
            }
            return;
        }
        Asserts.assertTrue(Events.isMatchingTargetName(recordedModule, moduleNameTarget), "mismatched module name! Target is " + moduleNameTarget);
    }

    private static ValueDescriptor getValueDescriptor(RecordedObject struct, String name) throws Exception {
        List<ValueDescriptor> valueDescriptors = struct.getFields();
        for (ValueDescriptor d : valueDescriptors) {
            if (!name.equals(d.getName())) continue;
            return d;
        }
        System.out.printf("Failed struct:%s", struct.toString());
        Asserts.fail(String.format("Field %s not in struct", name));
        return null;
    }

    public static void hasEvents(List<RecordedEvent> events) {
        Asserts.assertFalse(events.isEmpty(), "No events");
    }

    public static void hasEvents(RecordingFile file) {
        Asserts.assertTrue(file.hasMoreEvents(), "No events");
    }

    public static void assertEventThread(RecordedEvent event) {
        RecordedThread eventThread = event.getThread();
        if (eventThread == null) {
            System.out.printf("Failed event:%n%s%n", event.toString());
            Asserts.fail("No thread in event");
        }
    }

    public static void assertJavaMethod(RecordedEvent event) {
        Events.assertField(event, "method.name").notEmpty();
        Events.assertField(event, "method.descriptor").notEmpty();
        Events.assertField(event, "method.modifiers").atLeast(0);
        Events.assertField(event, "method.hidden");
        Events.assertField(event, "method.type.name").notEmpty();
        Events.assertField(event, "method.type.modifiers").atLeast(0);
    }

    public static void assertEventThread(RecordedEvent event, Thread thread) {
        Events.assertThread(event.getThread(), thread);
    }

    public static void assertEventThread(RecordedEvent event, String structName, Thread thread) {
        Events.assertThread((RecordedThread)Events.assertField(event, structName).notNull().getValue(), thread);
    }

    public static void assertDuration(RecordedEvent event, String name, Duration duration) {
        Asserts.assertEquals(event.getDuration(name), duration);
    }

    public static void assertInstant(RecordedEvent event, String name, Instant instant) {
        Asserts.assertEquals(event.getInstant(name), instant);
    }

    public static void assertMissingValue(RecordedEvent event, String name) {
        ValueDescriptor v = event.getEventType().getField(name);
        if (v.getAnnotation(Timespan.class) != null) {
            Duration d = event.getDuration(name);
            Asserts.assertTrue(d.getSeconds() == Long.MIN_VALUE && d.getNano() == 0);
            return;
        }
        if (v.getAnnotation(Timestamp.class) != null) {
            Instant instant = event.getInstant(name);
            Asserts.assertTrue(instant.equals(Instant.MIN));
            return;
        }
        if (v.getTypeName().equals("double")) {
            double d = event.getDouble(name);
            Asserts.assertTrue(Double.isNaN(d) || d == Double.NEGATIVE_INFINITY);
            return;
        }
        if (v.getTypeName().equals("float")) {
            float f = event.getFloat(name);
            Asserts.assertTrue(Float.isNaN(f) || f == Float.NEGATIVE_INFINITY);
            return;
        }
        if (v.getTypeName().equals("int")) {
            int i = event.getInt(name);
            Asserts.assertTrue(i == Integer.MIN_VALUE);
            return;
        }
        if (v.getTypeName().equals("long")) {
            Asserts.assertEquals(event.getLong(name), Long.MIN_VALUE);
            return;
        }
        Object o = event.getValue(name);
        Asserts.assertNull(o);
    }

    private static void assertThread(RecordedThread eventThread, Thread thread) {
        RecordedThreadGroup eventThreadGroup;
        Asserts.assertNotNull(eventThread, "Thread in event was null");
        Asserts.assertEquals(eventThread.getJavaThreadId(), thread.threadId(), "Wrong thread id");
        Asserts.assertEquals(eventThread.getJavaName(), thread.getName(), "Wrong thread name");
        ThreadGroup threadGroup = thread.getThreadGroup();
        Asserts.assertNotNull(eventThreadGroup, "eventThreadGroup was null");
        for (eventThreadGroup = eventThread.getThreadGroup(); eventThreadGroup != null; eventThreadGroup = eventThreadGroup.getParent()) {
            String groupName = eventThreadGroup.getName();
            if (threadGroup != null) {
                Asserts.assertEquals(groupName, threadGroup.getName(), "Wrong threadGroup name");
                threadGroup = threadGroup.getParent();
                continue;
            }
            Asserts.assertNotNull(groupName, "threadGroup name was null");
            Asserts.assertFalse(groupName.isEmpty(), "threadGroup name was empty");
        }
    }

    public static boolean hasField(RecordedEvent event, String name) {
        return event.getFields().stream().map(vd -> vd.getName()).anyMatch(s -> s.equals(name));
    }

    public static boolean isEventType(RecordedEvent event, String typeName) {
        return typeName.equals(event.getEventType().getName());
    }

    public static List<RecordedEvent> fromRecording(Recording recording) throws IOException {
        if (recording.getId() == lastId) {
            throw new IOException("Recording with id " + lastId + " has already been dumped. Store the results in a List<RecordedEvent> instead of dumping the recording again");
        }
        lastId = recording.getId();
        return RecordingFile.readAllEvents(Events.makeCopy(recording));
    }

    public static RecordingFile copyTo(Recording r) throws IOException {
        return new RecordingFile(Events.makeCopy(r));
    }

    private static Path makeCopy(Recording recording) throws IOException {
        Path p = recording.getDestination();
        if (p == null) {
            File directory = new File(".");
            ProcessHandle h = ProcessHandle.current();
            p = new File(directory.getAbsolutePath(), "recording-" + recording.getId() + "-pid" + h.pid() + ".jfr").toPath();
            recording.dump(p);
        }
        return p;
    }

    public static void hasAnnotation(ValueDescriptor field, Class<? extends Annotation> annotationClass) throws Exception {
        AnnotationElement a = Events.getAnnotation(field, annotationClass);
        if (a == null) {
            throw new Exception("Expected " + annotationClass.getSimpleName() + " on field " + field.getName());
        }
    }

    public static void assertAnnotation(ValueDescriptor field, Class<? extends Annotation> annotationClass, String value) throws Exception {
        AnnotationElement a = Events.getAnnotation(field, annotationClass);
        Object v = a.getValue("value");
        if (!v.equals(value)) {
            throw new Exception("Expected " + annotationClass.getSimpleName() + " on field " + field.getName() + " to have value " + value + ", but got " + String.valueOf(v));
        }
    }

    public static AnnotationElement getAnnotation(ValueDescriptor v, Class<?> clazz) throws Exception {
        for (AnnotationElement a : v.getAnnotationElements()) {
            if (!a.getTypeName().equals(clazz.getName())) continue;
            return a;
        }
        throw new Exception("Could not find annotation " + clazz.getName());
    }

    public static AnnotationElement getAnnotationByName(EventType t, String name) throws Exception {
        for (AnnotationElement a : t.getAnnotationElements()) {
            if (!a.getTypeName().equals(name)) continue;
            return a;
        }
        throw new Exception("Could not find annotation '" + name + " in type " + t.getName());
    }

    public static SettingDescriptor getSetting(EventType type, String name) {
        for (SettingDescriptor s : type.getSettingDescriptors()) {
            if (!s.getName().equals(name)) continue;
            return s;
        }
        throw new IllegalArgumentException("Could not setting with name " + name);
    }

    public static void hasEvent(Recording r, String name) throws IOException {
        List<RecordedEvent> events = Events.fromRecording(r);
        Events.hasEvents(events);
        Events.hasEvent(events, name);
    }

    public static void hasEvent(List<RecordedEvent> events, String name) throws IOException {
        if (!Events.containsEvent(events, name)) {
            Asserts.fail("Missing event " + name + " in recording " + events.toString());
        }
    }

    public static void hasNotEvent(List<RecordedEvent> events, String name) throws IOException {
        if (Events.containsEvent(events, name)) {
            Asserts.fail("Rercording should not contain event " + name + " " + events.toString());
        }
    }

    public static RecordedEvent getFirst(List<RecordedEvent> events, String name) throws Exception {
        for (RecordedEvent event : events) {
            if (!event.getEventType().getName().equals(name)) continue;
            return event;
        }
        Asserts.fail("Missing event " + name + " in recording " + events.toString());
        return null;
    }

    private static boolean containsEvent(List<RecordedEvent> events, String name) {
        for (RecordedEvent event : events) {
            if (!event.getEventType().getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public static void assertEventCount(List<RecordedEvent> events, int count) throws Exception {
        if (events.size() != count) {
            throw new Exception("Expected " + count + " events, found " + events.size());
        }
    }

    public static void assertTopFrame(RecordedEvent event, Class<?> expectedClass, String expectedMethodName) {
        Events.assertTopFrame(event, expectedClass.getName(), expectedMethodName);
    }

    public static void assertTopFrame(RecordedEvent event, String expectedClass, String expectedMethodName) {
        RecordedStackTrace stackTrace = event.getStackTrace();
        Asserts.assertNotNull(stackTrace, "Missing stack trace");
        RecordedFrame topFrame = stackTrace.getFrames().get(0);
        if (Events.isFrame(topFrame, expectedClass, expectedMethodName)) {
            return;
        }
        String expected = expectedClass + "::" + expectedMethodName;
        Asserts.fail("Expected top frame " + expected + ". Found " + String.valueOf(topFrame));
    }

    public static void assertFrame(RecordedEvent event, Class<?> expectedClass, String expectedMethodName) {
        RecordedStackTrace stackTrace = event.getStackTrace();
        Asserts.assertNotNull(stackTrace, "Missing stack trace");
        for (RecordedFrame frame : stackTrace.getFrames()) {
            if (!Events.isFrame(frame, expectedClass.getName(), expectedMethodName)) continue;
            return;
        }
        Asserts.fail("Expected " + expectedClass.getName() + "::" + expectedMethodName + " in stack trace");
    }

    private static boolean isFrame(RecordedFrame frame, String expectedClass, String expectedMethodName) {
        RecordedMethod method;
        RecordedClass type;
        return frame.isJavaFrame() && expectedClass.equals((type = (method = frame.getMethod()).getType()).getName()) && expectedMethodName.equals(method.getName());
    }
}

