/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Container;
import java.awt.Cursor;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;

class HtmlPane
extends JScrollPane
implements HyperlinkListener {
    JEditorPane html;

    public HtmlPane() {
        try {
            URL url = this.getClass().getResource("/resources/HelpFiles/toc.html");
            this.html = new JEditorPane(url);
            this.html.setEditable(false);
            this.html.addHyperlinkListener(this);
            this.html.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
            JViewport vp = this.getViewport();
            vp.add(this.html);
        }
        catch (MalformedURLException e) {
            System.out.println("Malformed URL: " + String.valueOf(e));
        }
        catch (IOException e) {
            System.out.println("IOException: " + String.valueOf(e));
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.linkActivated(e.getURL());
        }
    }

    protected void linkActivated(URL u) {
        Cursor c = this.html.getCursor();
        Cursor waitCursor = Cursor.getPredefinedCursor(3);
        this.html.setCursor(waitCursor);
        SwingUtilities.invokeLater(new PageLoader(this, u, c));
    }

    class PageLoader
    implements Runnable {
        URL url;
        Cursor cursor;
        final /* synthetic */ HtmlPane this$0;

        PageLoader(HtmlPane this$0, URL u, Cursor c) {
            HtmlPane htmlPane = this$0;
            Objects.requireNonNull(htmlPane);
            this.this$0 = htmlPane;
            this.url = u;
            this.cursor = c;
        }

        @Override
        public void run() {
            if (this.url == null) {
                this.this$0.html.setCursor(this.cursor);
                Container parent = this.this$0.html.getParent();
                parent.repaint();
            } else {
                Document doc = this.this$0.html.getDocument();
                try {
                    this.this$0.html.setPage(this.url);
                }
                catch (IOException ioe) {
                    this.this$0.html.setDocument(doc);
                    this.this$0.getToolkit().beep();
                }
                finally {
                    this.url = null;
                    SwingUtilities.invokeLater(this);
                }
            }
        }
    }
}

