/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.errors.StopWalkException;
import org.eclipse.jgit.internal.storage.dfs.DfsRepository;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;

class RefAdvancerWalk {
    private final DfsRepository db;
    private final InPackPredicate includeP;

    RefAdvancerWalk(DfsRepository db, InPackPredicate include) {
        this.db = db;
        this.includeP = include;
    }

    private RevWalk createRevWalk() {
        RevWalk rw = new RevWalk(this.db);
        rw.sort(RevSort.COMMIT_TIME_DESC);
        rw.setRevFilter(new FirstInPack(this.includeP));
        return rw;
    }

    Set<RevCommit> advance(List<ObjectId> allTips) throws IOException {
        HashSet<RevCommit> tipsInMidx = new HashSet<RevCommit>(allTips.size());
        Throwable throwable = null;
        Object var4_5 = null;
        try (RevWalk rw = this.createRevWalk();){
            for (ObjectId tip : allTips) {
                RevCommit inPack;
                RevObject tipObject = rw.parseAny(tip);
                if (!(tipObject instanceof RevCommit)) continue;
                RevCommit tipCommit = (RevCommit)tipObject;
                rw.markStart(tipCommit);
                while ((inPack = rw.next()) != null) {
                    tipsInMidx.add(inPack);
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return tipsInMidx;
    }

    private static class FirstInPack
    extends RevFilter {
        private final InPackPredicate isInPack;

        FirstInPack(InPackPredicate isInPack) {
            this.isInPack = isInPack;
        }

        @Override
        public boolean include(RevWalk walker, RevCommit cmit) throws StopWalkException, IOException {
            if (!this.isInPack.test(cmit)) {
                return false;
            }
            RevCommit[] revCommitArray = cmit.getParents();
            int n = revCommitArray.length;
            int n2 = 0;
            while (n2 < n) {
                RevCommit p = revCommitArray[n2];
                walker.markUninteresting(p);
                ++n2;
            }
            return true;
        }

        @Override
        public RevFilter clone() {
            return this;
        }
    }

    @FunctionalInterface
    static interface InPackPredicate {
        public boolean test(RevCommit var1) throws IOException;
    }
}

