/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.interpreter.internal.view.wizards;

import java.util.List;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.sirius.ui.interpreter.internal.InterpreterMessages;
import org.eclipse.sirius.ui.interpreter.internal.view.Variable;
import org.eclipse.sirius.ui.interpreter.internal.view.wizards.NewVariableWizardPage;

public class NewVariableWizard
extends Wizard {
    private final List<Variable> existingVariables;
    private NewVariableWizardPage page;
    private final Variable selectedVariable;

    public NewVariableWizard(Variable selectedVariable, List<Variable> existingVariables) {
        this.setWindowTitle(InterpreterMessages.getString("interpreter.wizard.newvariable.wizardtitle"));
        this.selectedVariable = selectedVariable;
        this.existingVariables = existingVariables;
    }

    public void addPages() {
        String initialVariableName = this.selectedVariable != null ? this.selectedVariable.getName() : null;
        this.page = new NewVariableWizardPage(initialVariableName, this.existingVariables);
        this.addPage((IWizardPage)this.page);
    }

    public String getVariableName() {
        if (this.page != null) {
            return this.page.getVariableName();
        }
        return null;
    }

    public Object getVariableValue() {
        if (this.page != null) {
            return this.page.getVariableValue();
        }
        return null;
    }

    public boolean performFinish() {
        this.page.setVariableName();
        this.page.setVariableValue();
        return true;
    }
}

