/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.interpreter.internal;

import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Text;

public final class SWTUtil {
    private SWTUtil() {
    }

    public static SourceViewer createScrollableSourceViewer(Composite parent, int style) {
        SourceViewer viewer = new SourceViewer(parent, null, style);
        SWTUtil.setUpScrollableListener((Scrollable)viewer.getTextWidget());
        return viewer;
    }

    public static StyledText createScrollableStyledText(Composite parent, int style) {
        StyledText text = new StyledText(parent, style);
        if ((style & 0x300) == 0) {
            return text;
        }
        SWTUtil.setUpScrollableListener((Scrollable)text);
        return text;
    }

    public static Text createScrollableText(Composite parent, int style) {
        Text text = new Text(parent, style);
        if ((style & 0x300) == 0) {
            return text;
        }
        SWTUtil.setUpScrollableListener((Scrollable)text);
        return text;
    }

    public static void setUpScrollableListener(final Scrollable scrollable) {
        final ScrollableResizeListener resizeListener = new ScrollableResizeListener(scrollable);
        scrollable.addControlListener((ControlListener)resizeListener);
        final ScrollableModifyListener modifyListener = new ScrollableModifyListener(scrollable);
        if (scrollable instanceof Text) {
            ((Text)scrollable).addModifyListener((ModifyListener)modifyListener);
        } else if (scrollable instanceof StyledText) {
            ((StyledText)scrollable).addModifyListener((ModifyListener)modifyListener);
        }
        scrollable.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                scrollable.removeControlListener((ControlListener)resizeListener);
                if (scrollable instanceof Text) {
                    ((Text)scrollable).removeModifyListener(modifyListener);
                } else if (scrollable instanceof StyledText) {
                    ((StyledText)scrollable).removeModifyListener(modifyListener);
                }
            }
        });
    }

    protected static Point computeTextSize(Control widget, String text) {
        String[] lines = text.split("(\r\n)|\n|\r");
        String longestLine = "";
        if (lines.length > 0) {
            longestLine = lines[0];
            int i = 0;
            while (i < lines.length) {
                if (lines[i].length() > longestLine.length()) {
                    longestLine = lines[i];
                }
                ++i;
            }
        }
        GC gc = new GC((Drawable)widget);
        gc.setFont(widget.getFont());
        int textWidth = gc.stringExtent((String)longestLine).x;
        int textHeight = gc.stringExtent((String)"W").y * lines.length;
        gc.dispose();
        return new Point(textWidth, textHeight);
    }

    protected static class ScrollableModifyListener
    implements ModifyListener {
        private final Scrollable text;

        public ScrollableModifyListener(Scrollable text) {
            this.text = text;
        }

        public void modifyText(ModifyEvent e) {
            String currentText;
            Rectangle clientArea = this.text.getClientArea();
            if (this.text instanceof Text) {
                currentText = ((Text)this.text).getText();
            } else if (this.text instanceof StyledText) {
                currentText = ((StyledText)this.text).getText();
            } else {
                return;
            }
            Point textSize = SWTUtil.computeTextSize((Control)this.text, currentText);
            if (clientArea.width > textSize.x && this.text.getHorizontalBar() != null) {
                this.text.getHorizontalBar().setVisible(false);
            } else if (this.text.getHorizontalBar() != null) {
                this.text.getHorizontalBar().setVisible(true);
            }
            if (clientArea.height > textSize.y && this.text.getVerticalBar() != null) {
                this.text.getVerticalBar().setVisible(false);
            } else if (this.text.getVerticalBar() != null) {
                this.text.getVerticalBar().setVisible(true);
            }
        }
    }

    protected static class ScrollableResizeListener
    extends ControlAdapter {
        private Point lastSize;
        private String lastText;
        private final Scrollable text;

        public ScrollableResizeListener(Scrollable text) {
            this.text = text;
        }

        public void controlResized(ControlEvent e) {
            String currentText;
            Rectangle clientArea = this.text.getClientArea();
            if (this.text instanceof Text) {
                currentText = ((Text)this.text).getText();
            } else if (this.text instanceof StyledText) {
                currentText = ((StyledText)this.text).getText();
            } else {
                return;
            }
            Point textSize = this.lastSize;
            if (textSize == null || !this.lastText.equals(currentText)) {
                textSize = SWTUtil.computeTextSize((Control)this.text, currentText);
                this.lastText = currentText;
                this.lastSize = textSize;
            }
            if (clientArea.width > textSize.x && this.text.getHorizontalBar() != null) {
                if (clientArea.height > this.text.getHorizontalBar().getSize().y) {
                    this.text.getHorizontalBar().setVisible(false);
                }
            } else if (this.text.getHorizontalBar() != null) {
                this.text.getHorizontalBar().setVisible(true);
            }
            if (clientArea.height > textSize.y && this.text.getVerticalBar() != null) {
                if (clientArea.width > this.text.getVerticalBar().getSize().x) {
                    this.text.getVerticalBar().setVisible(false);
                }
            } else if (this.text.getVerticalBar() != null) {
                this.text.getVerticalBar().setVisible(true);
            }
        }
    }
}

