/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.ui.tools.api.selection.page;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.sirius.common.tools.api.util.TreeItemWrapper;
import org.eclipse.sirius.common.ui.tools.api.navigator.GroupingContentProvider;
import org.eclipse.sirius.common.ui.tools.api.selection.EObjectSelectionWizard;
import org.eclipse.sirius.common.ui.tools.api.selection.page.AbstractSelectionWizardPage;
import org.eclipse.sirius.common.ui.tools.api.util.TreeItemWrapperContentProvider;
import org.eclipse.sirius.common.ui.tools.api.view.common.item.ItemDecorator;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeItem;

public class EObjectSelectionWizardPage
extends AbstractSelectionWizardPage {
    Composite pageComposite;
    private TreeItemWrapper treeObjects;
    private final AdapterFactoryLabelProvider myAdapterFactoryLabelProvider;
    private final List<EObject> selectedEObjects = new ArrayList<EObject>();
    private TreeViewer treeViewer;
    private boolean isMany;
    private boolean selectFirst;

    public EObjectSelectionWizardPage(String pageName, String title, ImageDescriptor imageTitle, Collection<? extends EObject> objects, AdapterFactory factory) {
        super(pageName, title, imageTitle);
        this.setPageComplete(false);
        this.myAdapterFactoryLabelProvider = new AdapterFactoryLabelProvider(factory);
        this.treeObjects = this.convertToTree(objects);
        this.selectFirst = true;
    }

    public EObjectSelectionWizardPage(String pageName, String title, ImageDescriptor imageTitle, TreeItemWrapper treeObjects, AdapterFactory factory) {
        super(pageName, title, imageTitle);
        this.setPageComplete(false);
        this.myAdapterFactoryLabelProvider = new AdapterFactoryLabelProvider(factory);
        this.treeObjects = treeObjects;
        this.selectFirst = true;
    }

    private TreeItemWrapper convertToTree(Collection<?> objects2) {
        TreeItemWrapper root = new TreeItemWrapper(null, null);
        Iterator<?> iter = objects2.iterator();
        while (iter.hasNext()) {
            TreeItemWrapper treeItemWrapper = new TreeItemWrapper(iter.next(), root);
            root.getChildren().add(treeItemWrapper);
        }
        return root;
    }

    public void setMany(boolean many) {
        this.isMany = many;
    }

    public void setFirstElementSelected(boolean select) {
        this.selectFirst = select;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.pageComposite = new Composite(parent, 0);
        this.pageComposite.setLayout((Layout)new GridLayout());
        this.pageComposite.setLayoutData((Object)new GridData(4, 4, false, false));
        this.createSelectionGroup(this.pageComposite);
        this.treeViewer = this.createTreeViewer(this.pageComposite);
        this.treeViewer.setInput((Object)this.treeObjects);
        this.myViewerfilter.setTreeViewer(this.treeViewer);
        EObjectSelectionWizardPage.expandTreeViewer(this.treeViewer);
        this.initRootPrefix();
        if (this.selectFirst && this.treeViewer.getTree().getItemCount() > 0) {
            this.treeViewer.getTree().setSelection(this.treeViewer.getTree().getItem(0));
            if (this.treeViewer.getTree().getItem(0).getData() instanceof TreeItemWrapper) {
                this.selectedEObjects.add((EObject)((TreeItemWrapper)this.treeViewer.getTree().getItem(0).getData()).getWrappedObject());
            }
            this.setPageComplete(true);
        }
        this.setControl((Control)this.pageComposite);
    }

    public boolean isCurrentPage() {
        return super.isCurrentPage();
    }

    private TreeViewer createTreeViewer(Composite parent) {
        TreeViewer viewer = null;
        viewer = !this.isMany ? new TreeViewer(parent, 2820) : new TreeViewer(parent, 2818);
        GridData gridData = new GridData(4, 4, true, true);
        viewer.getControl().setLayoutData((Object)gridData);
        viewer.getTree().setHeaderVisible(false);
        viewer.getTree().setLinesVisible(false);
        GroupingContentProvider contentProvider = new GroupingContentProvider(new TreeItemWrapperContentProvider());
        viewer.setContentProvider((IContentProvider)contentProvider);
        viewer.setLabelProvider((IBaseLabelProvider)new EObjectSelectionLabelProvider());
        viewer.setComparator(new ViewerComparator());
        viewer.addFilter((ViewerFilter)this.myViewerfilter);
        viewer.addSelectionChangedListener((ISelectionChangedListener)new EObjectSelectionListAdapter());
        viewer.getTree().addMouseListener(MouseListener.mouseDoubleClickAdapter(evt -> {
            EObjectSelectionWizard wizard = (EObjectSelectionWizard)this.getWizard();
            if (wizard.getDialog() != null) {
                wizard.getDialog().finishPressed();
            }
        }));
        return viewer;
    }

    private void initRootPrefix() {
        String prefix = null;
        boolean again = true;
        int count = this.treeViewer.getTree().getItemCount();
        int i = 0;
        while (i < count && again) {
            TreeItem treeItem = this.treeViewer.getTree().getItem(i);
            if ((prefix = this.computeCommonPrefix(prefix, treeItem)) == null) {
                again = false;
            } else if ((prefix = this.computeChildrenPrefix(prefix, treeItem)) == null) {
                again = false;
            }
            ++i;
        }
        if (prefix != null) {
            this.elementsToSelectText.setText(prefix);
            this.elementsToSelectText.setSelection(prefix.length());
        }
    }

    private String computeChildrenPrefix(String oldPrefix, TreeItem parent) {
        String prefix = oldPrefix;
        boolean again = true;
        int count = parent.getItemCount();
        int i = 0;
        while (i < count && again) {
            TreeItem treeItem = parent.getItem(i);
            if ((prefix = this.computeCommonPrefix(prefix, treeItem)) == null) {
                again = false;
            } else if ((prefix = this.computeChildrenPrefix(prefix, treeItem)) == null) {
                again = false;
            }
            ++i;
        }
        return prefix;
    }

    private String computeCommonPrefix(String oldPrefix, TreeItem treeItem) {
        String prefix = oldPrefix;
        if (prefix == null) {
            prefix = treeItem.getText();
        } else if (!treeItem.getText().startsWith(prefix)) {
            int searchIndex = Math.min(prefix.length() - 1, treeItem.getText().length());
            String newPrefix = null;
            while (searchIndex > 0 && newPrefix == null) {
                if (treeItem.getText().startsWith(prefix.substring(0, searchIndex))) {
                    newPrefix = prefix.substring(0, searchIndex);
                    continue;
                }
                --searchIndex;
            }
            prefix = newPrefix != null ? newPrefix : null;
        }
        return prefix;
    }

    public EObject getSelectedEObject() {
        if (this.selectedEObjects.size() > 0) {
            return this.selectedEObjects.get(0);
        }
        return null;
    }

    public List<EObject> getSelectedEObjects() {
        return this.selectedEObjects;
    }

    public void dispose() {
        this.myAdapterFactoryLabelProvider.dispose();
        if (this.pageComposite != null && !this.pageComposite.isDisposed()) {
            this.pageComposite.dispose();
        }
        super.dispose();
    }

    public void setTreeObjects(Collection<? extends EObject> objects) {
        this.treeObjects = this.convertToTree(objects);
        if (this.treeViewer != null && this.treeViewer.getTree() != null && !this.treeViewer.getTree().isDisposed()) {
            this.treeViewer.setInput((Object)this.treeObjects);
        }
    }

    private final class EObjectSelectionLabelProvider
    extends LabelProvider {
        private EObjectSelectionLabelProvider() {
        }

        public Image getImage(Object element) {
            Image result = null;
            result = element instanceof TreeItemWrapper ? EObjectSelectionWizardPage.this.myAdapterFactoryLabelProvider.getImage(((TreeItemWrapper)element).getWrappedObject()) : (element instanceof ItemDecorator ? ((ItemDecorator)element).getImage() : EObjectSelectionWizardPage.this.myAdapterFactoryLabelProvider.getImage(element));
            return result;
        }

        public String getText(Object element) {
            String result = null;
            result = element instanceof TreeItemWrapper ? EObjectSelectionWizardPage.this.myAdapterFactoryLabelProvider.getText(((TreeItemWrapper)element).getWrappedObject()) : (element instanceof ItemDecorator ? ((ItemDecorator)element).getText() : EObjectSelectionWizardPage.this.myAdapterFactoryLabelProvider.getText(element));
            return result;
        }
    }

    private final class EObjectSelectionListAdapter
    implements ISelectionChangedListener {
        private EObjectSelectionListAdapter() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (event.getSelection() instanceof IStructuredSelection) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                EObjectSelectionWizardPage.this.setPageComplete(false);
                if (selection.size() > 0) {
                    Iterator it = selection.toList().iterator();
                    EObjectSelectionWizardPage.this.selectedEObjects.clear();
                    while (it.hasNext()) {
                        Object selectedElement = it.next();
                        if (selectedElement instanceof TreeItemWrapper) {
                            EObjectSelectionWizardPage.this.selectedEObjects.add((EObject)((TreeItemWrapper)selectedElement).getWrappedObject());
                            EObjectSelectionWizardPage.this.setPageComplete(true);
                            continue;
                        }
                        if (!(selectedElement instanceof EObject)) continue;
                        EObjectSelectionWizardPage.this.selectedEObjects.add((EObject)selectedElement);
                        EObjectSelectionWizardPage.this.setPageComplete(true);
                    }
                    return;
                }
            }
            EObjectSelectionWizardPage.this.selectedEObjects.clear();
            EObjectSelectionWizardPage.this.setPageComplete(false);
        }
    }
}

