/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.theme;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.zip.CRC32;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.theme.CssValue;
import org.eclipse.rap.rwt.internal.theme.Size;
import org.eclipse.rap.rwt.internal.theme.ThemePropertyAdapterRegistry;
import org.eclipse.rap.rwt.internal.theme.ThemeResource;
import org.eclipse.rap.rwt.internal.util.ParamCheck;
import org.eclipse.rap.rwt.service.ApplicationContext;
import org.eclipse.rap.rwt.service.ResourceLoader;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

public class CssImage
implements CssValue,
ThemeResource {
    private static final String IMAGE_DEST_PATH = "themes/images";
    private static final String NONE_INPUT = "none";
    public static final CssImage NONE = new CssImage(true, null, null, null, null, true);
    private final Size size;
    public final boolean none;
    public final String path;
    public final ResourceLoader loader;
    public final String[] gradientColors;
    public final float[] gradientPercents;
    public final boolean vertical;

    private CssImage(boolean none, String path, ResourceLoader loader, String[] gradientColors, float[] gradientPercents, boolean vertical) {
        this.none = none;
        this.path = path;
        this.loader = loader;
        this.gradientColors = gradientColors;
        this.gradientPercents = gradientPercents;
        this.vertical = vertical;
        if (none) {
            this.size = new Size(0, 0);
        } else {
            try {
                this.size = CssImage.readImageSize(path, loader);
                if (this.size == null) {
                    throw new IllegalArgumentException("Failed to read image: " + path);
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed to read image: " + path, e);
            }
        }
    }

    public static CssImage valueOf(String input, ResourceLoader loader) {
        CssImage result;
        if (NONE_INPUT.equals(input)) {
            result = NONE;
        } else {
            ParamCheck.notNull(input, "input");
            ParamCheck.notNull(loader, "loader");
            if (input.length() == 0) {
                throw new IllegalArgumentException("Empty image path");
            }
            result = new CssImage(false, input, loader, null, null, true);
        }
        return result;
    }

    public static CssImage createGradient(String[] gradientColors, float[] gradientPercents, boolean vertical) {
        if (gradientColors == null || gradientPercents == null) {
            throw new NullPointerException("null argument");
        }
        CssImage result = new CssImage(true, null, null, gradientColors, gradientPercents, vertical);
        return result;
    }

    public boolean isGradient() {
        return this.gradientColors != null && this.gradientPercents != null;
    }

    public Size getSize() {
        return this.size;
    }

    @Override
    public String getResourcePath(ApplicationContext applicationContext) {
        String result = null;
        if (!this.none && this.path != null) {
            ThemePropertyAdapterRegistry registry = ThemePropertyAdapterRegistry.getInstance(applicationContext);
            ThemePropertyAdapterRegistry.ThemePropertyAdapter adapter = registry.getPropertyAdapter(CssImage.class);
            String cssKey = adapter.getKey(this);
            result = "themes/images/" + cssKey;
        }
        return result;
    }

    @Override
    public InputStream getResourceAsStream() throws IOException {
        InputStream inputStream = null;
        if (!this.none && this.path != null) {
            inputStream = this.loader.getResourceAsStream(this.path);
        }
        return inputStream;
    }

    @Override
    public String toDefaultString() {
        return this.none ? NONE_INPUT : "";
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object.getClass() == CssImage.class) {
            CssImage other = (CssImage)object;
            return (this.path == null ? other.path == null : this.path.equals(other.path)) && (this.loader == null ? other.loader == null : this.loader.equals(other.loader)) && (this.gradientColors == null ? other.gradientColors == null : Arrays.equals(this.gradientColors, other.gradientColors)) && (this.gradientPercents == null ? other.gradientPercents == null : Arrays.equals(this.gradientPercents, other.gradientPercents)) && other.vertical == this.vertical;
        }
        return false;
    }

    public int hashCode() {
        CRC32 result = new CRC32();
        if (this.none) {
            result.update(1);
            if (this.gradientColors != null && this.gradientPercents != null) {
                int i = 0;
                while (i < this.gradientColors.length) {
                    result.update(this.gradientColors[i].getBytes());
                    ++i;
                }
                i = 0;
                while (i < this.gradientPercents.length) {
                    result.update(Float.floatToIntBits(this.gradientPercents[i]));
                    ++i;
                }
                if (this.vertical) {
                    result.update(2);
                }
            }
        } else {
            result.update(3);
            result.update(this.path.getBytes());
        }
        return (int)result.getValue();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("CssImage{ ");
        if (this.gradientColors != null && this.gradientPercents != null) {
            result.append("gradient: ");
            result.append(this.vertical ? "vertical " : "horizontal ");
            int i = 0;
            while (i < this.gradientColors.length) {
                result.append(", ");
                result.append(this.gradientColors[i]);
                if (i < this.gradientPercents.length) {
                    result.append(" ");
                    result.append(this.gradientPercents[i]);
                }
                ++i;
            }
        } else {
            result.append((String)(this.none ? NONE_INPUT : "path: " + this.path));
        }
        result.append(" }");
        return result.toString();
    }

    public static Image createSwtImage(CssImage image) throws IOException {
        Image result;
        if (image.loader == null) {
            String message = "Cannot create image without resource loader";
            throw new IllegalArgumentException(message);
        }
        try (InputStream inputStream = image.loader.getResourceAsStream(image.path);){
            result = ContextProvider.getApplicationContext().getImageFactory().findImage(image.path, inputStream);
        }
        return result;
    }

    private static Size readImageSize(String path, ResourceLoader loader) throws IOException {
        InputStream inputStream = loader.getResourceAsStream(path);
        if (inputStream != null) {
            try {
                ImageData data = new ImageData(inputStream);
                Size size = new Size(data.width, data.height);
                return size;
            }
            finally {
                inputStream.close();
            }
        }
        return null;
    }
}

