/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.sparql.ir;

import java.util.Collections;
import java.util.Set;
import java.util.function.UnaryOperator;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrBGP;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrExists;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrNode;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrNot;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrPrinter;

public class IrFilter
extends IrNode {
    private final String conditionText;
    private final IrNode body;

    public IrFilter(String conditionText, boolean newScope) {
        super(newScope);
        this.conditionText = conditionText;
        this.body = null;
    }

    public IrFilter(IrNode body, boolean newScope) {
        super(newScope);
        this.conditionText = null;
        this.body = body;
    }

    public String getConditionText() {
        return this.conditionText;
    }

    public IrNode getBody() {
        return this.body;
    }

    @Override
    public void print(IrPrinter p) {
        if (this.body == null) {
            p.line("FILTER (" + this.conditionText + ")");
            return;
        }
        p.startLine();
        p.append("FILTER ");
        this.body.print(p);
    }

    @Override
    public IrNode transformChildren(UnaryOperator<IrNode> op) {
        if (this.body == null) {
            return this;
        }
        if (this.body instanceof IrExists) {
            IrExists ex = (IrExists)this.body;
            IrBGP inner = ex.getWhere();
            if (inner != null) {
                IrNode t = (IrNode)op.apply(inner);
                if ((t = t.transformChildren(op)) instanceof IrBGP) {
                    inner = (IrBGP)t;
                }
            }
            IrExists ex2 = new IrExists(inner, ex.isNewScope());
            IrFilter nf = new IrFilter(ex2, this.isNewScope());
            return nf;
        }
        if (this.body instanceof IrNot) {
            IrNot n = (IrNot)this.body;
            IrNode innerNode = n.getInner();
            if (innerNode instanceof IrExists) {
                IrExists ex = (IrExists)innerNode;
                IrBGP inner = ex.getWhere();
                if (inner != null) {
                    IrNode t = (IrNode)op.apply(inner);
                    if ((t = t.transformChildren(op)) instanceof IrBGP) {
                        inner = (IrBGP)t;
                    }
                }
                IrExists ex2 = new IrExists(inner, ex.isNewScope());
                IrFilter nf = new IrFilter(new IrNot(ex2, n.isNewScope()), this.isNewScope());
                return nf;
            }
            IrFilter nf = new IrFilter(new IrNot(innerNode, n.isNewScope()), this.isNewScope());
            return nf;
        }
        return this;
    }

    @Override
    public Set<Var> getVars() {
        if (this.body != null) {
            return this.body.getVars();
        }
        return Collections.emptySet();
    }
}

