/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.iteration;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;

public class CloseableIteratorIteration<E>
implements CloseableIteration<E> {
    private Iterator<? extends E> iter;
    private boolean closed = false;

    public CloseableIteratorIteration(Iterator<? extends E> iter) {
        this.iter = Objects.requireNonNull(iter, "Iterator was null");
    }

    @Override
    public boolean hasNext() {
        if (this.isClosed()) {
            return false;
        }
        boolean result = this.iter.hasNext();
        if (!result) {
            this.close();
        }
        return result;
    }

    @Override
    public E next() {
        if (this.isClosed()) {
            throw new NoSuchElementException("Iteration has been closed");
        }
        return this.iter.next();
    }

    @Override
    public void remove() {
        if (this.isClosed()) {
            throw new IllegalStateException("Iteration has been closed");
        }
        this.iter.remove();
    }

    protected void handleClose() {
    }

    public final boolean isClosed() {
        return this.closed;
    }

    @Override
    public final void close() {
        if (!this.closed) {
            this.closed = true;
            this.handleClose();
        }
    }
}

