/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.iteration;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.rdf4j.common.iteration.AbstractCloseableIteration;

public abstract class AbstractCloseableIteratorIteration<E>
extends AbstractCloseableIteration<E> {
    private Iterator<? extends E> iter;

    protected abstract Iterator<? extends E> getIterator();

    @Override
    public boolean hasNext() {
        boolean result;
        if (this.isClosed()) {
            return false;
        }
        if (this.iter == null) {
            this.iter = this.getIterator();
        }
        if (!(result = this.iter.hasNext())) {
            this.close();
        }
        return result;
    }

    @Override
    public E next() {
        if (this.isClosed()) {
            throw new NoSuchElementException("Iteration has been closed");
        }
        if (this.iter == null) {
            this.iter = this.getIterator();
        }
        return this.iter.next();
    }

    @Override
    public void remove() {
        if (this.isClosed()) {
            throw new IllegalStateException("Iteration has been closed");
        }
        if (this.iter == null) {
            this.iter = this.getIterator();
        }
        this.iter.remove();
    }
}

