/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.feature.WorkspaceFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.project.PDEProject;

public class WorkspaceFeatureModelManager
extends WorkspaceModelManager<IFeatureModel> {
    @Override
    protected boolean isInterestingProject(IProject project) {
        return WorkspaceFeatureModelManager.isFeatureProject(project);
    }

    @Override
    protected void createModel(IProject project, boolean notify) {
        IFile featureXml = PDEProject.getFeatureXml(project);
        if (featureXml.exists()) {
            WorkspaceFeatureModel model = new WorkspaceFeatureModel(featureXml);
            this.loadModel(model, false);
            this.getModelsMap().put(project, model);
            if (notify) {
                this.addChange(model, 1);
            }
        }
    }

    @Override
    protected IFeatureModel removeModel(IProject project) {
        IFeatureModel model = (IFeatureModel)this.getModelsMap().remove(project);
        this.addChange(model, 2);
        return model;
    }

    @Override
    protected void handleFileDelta(IResourceDelta delta) {
        IProject project;
        IFile featureXml;
        IFile file = (IFile)delta.getResource();
        if (file.equals((Object)(featureXml = PDEProject.getFeatureXml(project = file.getProject())))) {
            IFeatureModel model = (IFeatureModel)this.getModel(project);
            int kind = delta.getKind();
            if (kind == 2 && model != null) {
                this.removeModel(project);
            } else if (kind == 1 || model == null) {
                this.createModel(file.getProject(), true);
            } else if (kind == 4 && (0x100 & delta.getFlags()) != 0) {
                this.loadModel(model, true);
                this.addChange(model, 4);
            }
        }
    }

    protected IFeatureModel[] getFeatureModels() {
        this.initialize();
        return this.getModelsMap().values().toArray(new IFeatureModel[this.getModelsMap().size()]);
    }

    public void removeModel(IFeatureModel iFeatureModel) {
        for (Map.Entry entry : this.getModelsMap().entrySet()) {
            if (entry.getValue() != iFeatureModel) continue;
            this.removeModel(entry.getKey());
            break;
        }
    }
}

