/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.target;

import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.resource.CapReqBuilder;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.IntStream;
import javax.xml.parsers.DocumentBuilder;
import org.eclipse.core.internal.runtime.XmlProcessorFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.ITargetLocationFactory;
import org.eclipse.pde.internal.core.target.Messages;
import org.eclipse.pde.internal.core.target.RepositoryBundleContainer;
import org.osgi.resource.Requirement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RepositoryLocationFactory
implements ITargetLocationFactory {
    @Override
    public ITargetLocation getTargetLocation(String type, String serializedXML) throws CoreException {
        if (!"Repository".equals(type)) {
            throw new CoreException(Status.error((String)NLS.bind((String)Messages.TargetRefrenceLocationFactory_Unsupported_Type, (Object)type)));
        }
        try {
            DocumentBuilder docBuilder = XmlProcessorFactory.createDocumentBuilderWithErrorOnDOCTYPE();
            Document document = docBuilder.parse(new ByteArrayInputStream(serializedXML.getBytes(StandardCharsets.UTF_8)));
            Element location = document.getDocumentElement();
            NodeList childNodes = location.getChildNodes();
            List<Requirement> requirements = IntStream.range(0, childNodes.getLength()).mapToObj(childNodes::item).filter(Element.class::isInstance).map(Element.class::cast).filter(element -> element.getNodeName().equalsIgnoreCase("require")).flatMap(element -> {
                String textContent = element.getTextContent();
                Parameters parameters = new Parameters(textContent);
                return CapReqBuilder.getRequirementsFrom((Parameters)parameters).stream();
            }).toList();
            return new RepositoryBundleContainer(location.getAttribute("uri"), requirements);
        }
        catch (Exception e) {
            throw new CoreException(Status.error((String)NLS.bind((String)Messages.TargetRefrenceLocationFactory_Parsing_Failed, (Object)e.getMessage()), (Throwable)e));
        }
    }
}

