/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize.mapping;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.ui.internal.synchronize.mapping.GitObjectMapping;
import org.eclipse.egit.ui.internal.synchronize.mapping.GitTreeTraversal;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelBlob;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelObject;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelTree;

class GitTreeMapping
extends GitObjectMapping {
    private final GitModelTree tree;
    private static final IWorkspaceRoot ROOT = ResourcesPlugin.getWorkspace().getRoot();

    protected GitTreeMapping(GitModelTree object) {
        super(object);
        this.tree = object;
    }

    public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
        GitModelObject[] objects = this.tree.getChildren();
        ResourceTraversal[] result = new ResourceTraversal[objects.length];
        int i = 0;
        while (i < objects.length) {
            if (objects[i] instanceof GitModelTree) {
                result[i] = new GitTreeTraversal((GitModelTree)objects[i]);
            } else {
                IResource[] resources = this.getResources((GitModelBlob)objects[i]);
                result[i] = new ResourceTraversal(resources, 0, 16);
            }
            ++i;
        }
        return result;
    }

    private IResource[] getResources(GitModelBlob modelBlob) {
        IFile file = ROOT.getFileForLocation(modelBlob.getLocation());
        if (file == null) {
            file = ROOT.getFile(modelBlob.getLocation());
        }
        return new IResource[]{file};
    }
}

