/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.core.refactoring.descriptors.InlineLocalVariableDescriptor;
import org.eclipse.jdt.internal.core.manipulation.BindingLabelProviderCore;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.jdt.internal.core.manipulation.dom.NecessaryParenthesesChecker;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.core.manipulation.util.Strings;
import org.eclipse.jdt.internal.core.refactoring.descriptors.RefactoringSignatureDescriptorFactory;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptorUtil;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStringStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.code.CodeRefactoringUtil;
import org.eclipse.jdt.internal.corext.refactoring.code.Invocations;
import org.eclipse.jdt.internal.corext.refactoring.code.TempAssignmentFinder;
import org.eclipse.jdt.internal.corext.refactoring.rename.RefactoringAnalyzeUtil;
import org.eclipse.jdt.internal.corext.refactoring.rename.TempDeclarationFinder;
import org.eclipse.jdt.internal.corext.refactoring.rename.TempOccurrenceAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TightSourceRangeComputer;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.util.Progress;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.RangeMarker;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class InlineTempRefactoring
extends Refactoring {
    private int fSelectionStart;
    private int fSelectionLength;
    private ICompilationUnit fCu;
    private VariableDeclaration fVariableDeclaration;
    private SimpleName[] fReferences;
    private CompilationUnit fASTRoot;
    private boolean fCheckResultForCompileProblems;
    private Set<SimpleName> fReferencesNeedingParams = new HashSet<SimpleName>();
    private Map<SimpleName, ITrackedNodePosition> fTrackedReferences = new HashMap<SimpleName, ITrackedNodePosition>();
    private Map<SimpleName, ISourceRange> fResolvedTrackedReferences = new HashMap<SimpleName, ISourceRange>();
    private CompilationUnitChange fChange;

    public InlineTempRefactoring(ICompilationUnit unit, CompilationUnit node, int selectionStart, int selectionLength) {
        Assert.isTrue((selectionStart >= 0 ? 1 : 0) != 0);
        Assert.isTrue((selectionLength >= 0 ? 1 : 0) != 0);
        this.fSelectionStart = selectionStart;
        this.fSelectionLength = selectionLength;
        this.fCu = unit;
        this.fASTRoot = node;
        this.fVariableDeclaration = null;
        this.fCheckResultForCompileProblems = true;
        this.fChange = null;
    }

    public InlineTempRefactoring(ICompilationUnit unit, int selectionStart, int selectionLength) {
        this(unit, null, selectionStart, selectionLength);
    }

    public InlineTempRefactoring(VariableDeclaration decl) {
        this.fVariableDeclaration = decl;
        ASTNode astRoot = decl.getRoot();
        Assert.isTrue((boolean)(astRoot instanceof CompilationUnit));
        this.fASTRoot = (CompilationUnit)astRoot;
        Assert.isTrue((boolean)(this.fASTRoot.getJavaElement() instanceof ICompilationUnit));
        this.fSelectionStart = decl.getStartPosition();
        this.fSelectionLength = decl.getLength();
        this.fCu = (ICompilationUnit)this.fASTRoot.getJavaElement();
        this.fCheckResultForCompileProblems = true;
        this.fChange = null;
    }

    public InlineTempRefactoring(JavaRefactoringArguments arguments, RefactoringStatus status) {
        this(null, null, 0, 0);
        RefactoringStatus initializeStatus = this.initialize(arguments);
        status.merge(initializeStatus);
    }

    public void setCheckResultForCompileProblems(boolean checkResultForCompileProblems) {
        this.fCheckResultForCompileProblems = checkResultForCompileProblems;
    }

    public RefactoringStatus checkIfTempSelected() {
        VariableDeclaration decl = this.getVariableDeclaration();
        if (decl == null) {
            return CodeRefactoringUtil.checkMethodSyntaxErrors(this.fSelectionStart, this.fSelectionLength, this.getASTRoot(), RefactoringCoreMessages.InlineTempRefactoring_select_temp);
        }
        if (decl.getParent() instanceof FieldDeclaration) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InlineTemRefactoring_error_message_fieldsCannotBeInlined);
        }
        return new RefactoringStatus();
    }

    private CompilationUnit getASTRoot() {
        if (this.fASTRoot == null) {
            this.fASTRoot = RefactoringASTParser.parseWithASTProvider((ITypeRoot)this.fCu, true, null);
        }
        return this.fASTRoot;
    }

    public VariableDeclaration getVariableDeclaration() {
        if (this.fVariableDeclaration == null) {
            this.fVariableDeclaration = TempDeclarationFinder.findTempDeclaration(this.getASTRoot(), this.fSelectionStart, this.fSelectionLength);
        }
        return this.fVariableDeclaration;
    }

    private ASTNode getSelectedNode() {
        return TempDeclarationFinder.getSelectedNode(this.getASTRoot(), this.fSelectionStart, this.fSelectionLength);
    }

    public String getName() {
        return RefactoringCoreMessages.InlineTempRefactoring_name;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask("", 1);
            RefactoringStatus result = Checks.validateModifiesFiles(ResourceUtil.getFiles(new ICompilationUnit[]{this.fCu}), this.getValidationContext(), pm);
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            ASTNode selected = this.getSelectedNode();
            VariableDeclaration declaration = this.getVariableDeclaration();
            result.merge(this.checkSelection(selected, declaration));
            result.merge(this.checkClashes(declaration));
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    private RefactoringStatus checkClashes(VariableDeclaration declaration) {
        SimpleName[] simpleNameArray = this.getReferences();
        int n = simpleNameArray.length;
        int n2 = 0;
        while (n2 < n) {
            SimpleName reference = simpleNameArray[n2];
            Set<IVariableBinding> newVariables = this.getNewVariables(reference);
            List<Name> initializerNames = this.getInitializerNames(declaration.getInitializer());
            for (Name name : initializerNames) {
                List<Expression> alternativeQualifications;
                if (!this.clashesWithNewVariables(newVariables, (Expression)name) || (alternativeQualifications = this.getAlternativeQualifications(reference, name)).size() <= 0) continue;
                boolean inlinable = false;
                for (Expression alternative : alternativeQualifications) {
                    if (this.clashesWithNewVariables(newVariables, alternative)) continue;
                    inlinable = true;
                    break;
                }
                if (inlinable) continue;
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InlineTemRefactoring_error_message_inliningClashes, name));
            }
            ++n2;
        }
        return null;
    }

    private RefactoringStatus checkSelection(ASTNode selectedNode, VariableDeclaration decl) {
        SimpleName[] references;
        ASTNode parent = decl.getParent();
        if (parent instanceof MethodDeclaration) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InlineTempRefactoring_method_parameter);
        }
        if (parent instanceof CatchClause) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InlineTempRefactoring_exceptions_declared);
        }
        if (parent instanceof VariableDeclarationExpression && parent.getLocationInParent() == ForStatement.INITIALIZERS_PROPERTY) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InlineTempRefactoring_for_initializers);
        }
        if (parent instanceof VariableDeclarationExpression && parent.getLocationInParent() == TryStatement.RESOURCES2_PROPERTY) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InlineTempRefactoring_resource_in_try_with_resources);
        }
        if (selectedNode instanceof Name && selectedNode.getLocationInParent() == TryStatement.RESOURCES2_PROPERTY) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InlineTempRefactoring_resource_used_in_try_with_resources);
        }
        if (decl.getInitializer() == null) {
            String message = Messages.format(RefactoringCoreMessages.InlineTempRefactoring_not_initialized, BasicElementLabels.getJavaElementName(decl.getName().getIdentifier()));
            return RefactoringStatus.createFatalErrorStatus((String)message);
        }
        SimpleName[] simpleNameArray = references = this.getReferences();
        int n = references.length;
        int n2 = 0;
        while (n2 < n) {
            SimpleName ref = simpleNameArray[n2];
            if (ref.getLocationInParent() == TryStatement.RESOURCES2_PROPERTY) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InlineTempRefactoring_resource_used_in_try_with_resources);
            }
            ++n2;
        }
        return this.checkAssignments(decl);
    }

    private RefactoringStatus checkAssignments(VariableDeclaration decl) {
        TempAssignmentFinder assignmentFinder = new TempAssignmentFinder(decl);
        this.getASTRoot().accept((ASTVisitor)assignmentFinder);
        if (!assignmentFinder.hasAssignments()) {
            return new RefactoringStatus();
        }
        ASTNode firstAssignment = assignmentFinder.getFirstAssignment();
        int start = firstAssignment.getStartPosition();
        int length = firstAssignment.getLength();
        SourceRange range = new SourceRange(start, length);
        RefactoringStatusContext context = JavaStatusContext.create((ITypeRoot)this.fCu, (ISourceRange)range);
        String message = Messages.format(RefactoringCoreMessages.InlineTempRefactoring_assigned_more_once, BasicElementLabels.getJavaElementName(decl.getName().getIdentifier()));
        return RefactoringStatus.createFatalErrorStatus((String)message, (RefactoringStatusContext)context);
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        try {
            SourceRange range;
            pm.beginTask("", 1);
            CompilationUnitRewrite cuRewrite = new CompilationUnitRewrite(this.fCu, this.fASTRoot);
            this.inlineTemp(cuRewrite);
            this.removeTemp(cuRewrite);
            Document doc = null;
            if (!this.fTrackedReferences.isEmpty()) {
                doc = new Document(this.fCu.getSource());
                try {
                    cuRewrite.getASTRewrite().rewriteAST().apply((IDocument)doc);
                    for (Map.Entry<SimpleName, ITrackedNodePosition> entry : this.fTrackedReferences.entrySet()) {
                        SimpleName name = entry.getKey();
                        ITrackedNodePosition position = entry.getValue();
                        int start = position.getStartPosition();
                        int length = position.getLength();
                        range = new SourceRange(start, length);
                        this.fResolvedTrackedReferences.put(name, (ISourceRange)range);
                    }
                }
                catch (BadLocationException | MalformedTreeException entry) {
                    // empty catch block
                }
            }
            this.fChange = cuRewrite.createChange(RefactoringCoreMessages.InlineTempRefactoring_inline, false, Progress.subMonitor(pm, 1));
            if (this.fCheckResultForCompileProblems) {
                RefactoringStatus result;
                RefactoringStatus refactoringStatus = result = doc == null ? RefactoringAnalyzeUtil.checkNewSource(this.fChange, this.fCu, this.fASTRoot, pm) : RefactoringAnalyzeUtil.checkNewSource((IDocument)doc, this.fCu, this.fASTRoot, pm);
                if (!result.isOK()) {
                    RefactoringStatusEntry[] refactoringStatusEntryArray = result.getEntries();
                    int n = refactoringStatusEntryArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        RefactoringStatusEntry entry = refactoringStatusEntryArray[n2];
                        JavaStringStatusContext context = (JavaStringStatusContext)entry.getContext();
                        if (entry.getMessage().startsWith("Type mismatch:")) {
                            range = context.getSourceRange();
                            int rangeEnd = range.getOffset() + range.getLength();
                            try {
                                for (Map.Entry<SimpleName, ISourceRange> trackedEntry : this.fResolvedTrackedReferences.entrySet()) {
                                    int trackedEntryEnd = trackedEntry.getValue().getOffset() + trackedEntry.getValue().getLength();
                                    if (trackedEntry.getValue().getOffset() < range.getOffset() || trackedEntryEnd > rangeEnd) continue;
                                    this.fReferencesNeedingParams.add(trackedEntry.getKey());
                                }
                            }
                            catch (MalformedTreeException malformedTreeException) {
                                // empty catch block
                            }
                        }
                        ++n2;
                    }
                    if (!this.fReferencesNeedingParams.isEmpty()) {
                        cuRewrite.clearASTRewrite();
                        this.inlineTemp(cuRewrite);
                        this.removeTemp(cuRewrite);
                        this.fChange = cuRewrite.createChange(RefactoringCoreMessages.InlineTempRefactoring_inline, false, Progress.subMonitor(pm, 1));
                        result = RefactoringAnalyzeUtil.checkNewSource(this.fChange, this.fCu, this.fASTRoot, pm);
                    }
                    RefactoringStatus refactoringStatus2 = result;
                    return refactoringStatus2;
                }
            }
            RefactoringStatus refactoringStatus = new RefactoringStatus();
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask(RefactoringCoreMessages.InlineTempRefactoring_preview, 2);
            InlineLocalVariableDescriptor descriptor = this.createRefactoringDescriptor();
            this.fChange.setDescriptor((ChangeDescriptor)new RefactoringChangeDescriptor((RefactoringDescriptor)descriptor));
            CompilationUnitChange compilationUnitChange = this.fChange;
            return compilationUnitChange;
        }
        finally {
            pm.done();
        }
    }

    private InlineLocalVariableDescriptor createRefactoringDescriptor() {
        HashMap<String, String> arguments = new HashMap<String, String>();
        String project = null;
        IJavaProject javaProject = this.fCu.getJavaProject();
        if (javaProject != null) {
            project = javaProject.getElementName();
        }
        IVariableBinding binding = this.getVariableDeclaration().resolveBinding();
        String text = null;
        IMethodBinding method = binding.getDeclaringMethod();
        text = method != null ? BindingLabelProviderCore.getBindingLabel((IBinding)method, 2235681801344L) : BasicElementLabels.getJavaElementName("{...}");
        String description = Messages.format(RefactoringCoreMessages.InlineTempRefactoring_descriptor_description_short, BasicElementLabels.getJavaElementName(binding.getName()));
        String header = Messages.format(RefactoringCoreMessages.InlineTempRefactoring_descriptor_description, new String[]{BindingLabelProviderCore.getBindingLabel((IBinding)binding, 2235681801344L), text});
        JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, (Object)this, header);
        comment.addSetting(Messages.format(RefactoringCoreMessages.InlineTempRefactoring_original_pattern, BindingLabelProviderCore.getBindingLabel((IBinding)binding, 2235681801344L)));
        InlineLocalVariableDescriptor descriptor = RefactoringSignatureDescriptorFactory.createInlineLocalVariableDescriptor(project, description, comment.asString(), arguments, 0);
        arguments.put("input", JavaRefactoringDescriptorUtil.elementToHandle(project, (IJavaElement)this.fCu));
        arguments.put("selection", String.valueOf(this.fSelectionStart) + " " + String.valueOf(this.fSelectionLength));
        return descriptor;
    }

    private void inlineTemp(CompilationUnitRewrite cuRewrite) throws JavaModelException {
        TextEditGroup groupDesc = cuRewrite.createGroupDescription(RefactoringCoreMessages.InlineTempRefactoring_inline_edit_name);
        ASTRewrite rewrite = cuRewrite.getASTRewrite();
        SimpleName[] simpleNameArray = this.getReferences();
        int n = simpleNameArray.length;
        int n2 = 0;
        while (n2 < n) {
            SimpleName curr = simpleNameArray[n2];
            Expression initializerCopy = this.getInitializerSource(cuRewrite, curr, groupDesc);
            rewrite.replace((ASTNode)curr, (ASTNode)initializerCopy, groupDesc);
            ++n2;
        }
    }

    private void removeTemp(CompilationUnitRewrite cuRewrite) {
        VariableDeclaration variableDeclaration = this.getVariableDeclaration();
        TextEditGroup groupDesc = cuRewrite.createGroupDescription(RefactoringCoreMessages.InlineTempRefactoring_remove_edit_name);
        ASTNode parent = variableDeclaration.getParent();
        ASTRewrite rewrite = cuRewrite.getASTRewrite();
        TightSourceRangeComputer sourceRangeComputer = new TightSourceRangeComputer();
        rewrite.setTargetSourceRangeComputer((TargetSourceRangeComputer)sourceRangeComputer);
        if (parent instanceof VariableDeclarationStatement && ((VariableDeclarationStatement)parent).fragments().size() == 1) {
            sourceRangeComputer.addTightSourceNode(parent);
            rewrite.remove(parent, groupDesc);
        } else {
            sourceRangeComputer.addTightSourceNode((ASTNode)variableDeclaration);
            rewrite.remove((ASTNode)variableDeclaration, groupDesc);
        }
    }

    private Expression getInitializerSource(CompilationUnitRewrite rewrite, SimpleName reference, TextEditGroup groupDesc) throws JavaModelException {
        Expression copy = this.getModifiedInitializerSource(rewrite, reference, groupDesc);
        if (NecessaryParenthesesChecker.needsParentheses(copy, reference.getParent(), reference.getLocationInParent())) {
            ParenthesizedExpression parentExpr = rewrite.getAST().newParenthesizedExpression();
            parentExpr.setExpression(copy);
            return parentExpr;
        }
        return copy;
    }

    private Expression getModifiedInitializerSource(CompilationUnitRewrite rewrite, SimpleName reference, TextEditGroup groupDesc) throws JavaModelException {
        ITypeBinding explicitCast;
        ITypeBinding[] typeArguments;
        Map<Name, Expression> replacements;
        VariableDeclaration varDecl = this.getVariableDeclaration();
        Expression initializer = varDecl.getInitializer();
        List<Name> initializerNames = this.getInitializerNames(initializer);
        if (!initializerNames.isEmpty() && !(replacements = this.getClashingReplacements(reference, initializerNames)).isEmpty()) {
            return this.replaceClashingNames(rewrite, groupDesc, initializer, replacements);
        }
        ASTNode referenceContext = reference.getParent();
        boolean trackExpression = false;
        if (Invocations.isResolvedTypeInferredFromExpectedType(initializer) && !(referenceContext instanceof VariableDeclarationFragment) && !(referenceContext instanceof SingleVariableDeclaration) && !(referenceContext instanceof Assignment) && (typeArguments = Invocations.getInferredTypeArguments(initializer)) != null) {
            this.fCheckResultForCompileProblems = true;
            if (this.fReferencesNeedingParams.contains(reference)) {
                String newSource = this.createParameterizedInvocation(initializer, typeArguments, rewrite);
                return (Expression)rewrite.getASTRewrite().createStringPlaceholder(newSource, initializer.getNodeType());
            }
            trackExpression = true;
        }
        Expression copy = (Expression)rewrite.getASTRewrite().createCopyTarget((ASTNode)initializer);
        if (trackExpression) {
            this.fTrackedReferences.put(reference, rewrite.getASTRewrite().track(reference.getParent()));
        }
        AST ast = rewrite.getAST();
        if (NecessaryParenthesesChecker.needsParentheses(initializer, reference.getParent(), reference.getLocationInParent())) {
            ParenthesizedExpression parenthesized = ast.newParenthesizedExpression();
            parenthesized.setExpression(copy);
            copy = parenthesized;
        }
        if ((explicitCast = ASTNodes.getExplicitCast(initializer, (Expression)reference)) != null) {
            CastExpression cast = ast.newCastExpression();
            if (NecessaryParenthesesChecker.needsParentheses(copy, (ASTNode)cast, (StructuralPropertyDescriptor)CastExpression.EXPRESSION_PROPERTY)) {
                ParenthesizedExpression parenthesized = ast.newParenthesizedExpression();
                parenthesized.setExpression(copy);
                copy = parenthesized;
            }
            cast.setExpression(copy);
            ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext((ASTNode)reference, rewrite.getImportRewrite());
            cast.setType(rewrite.getImportRewrite().addImport(explicitCast, ast, (ImportRewrite.ImportRewriteContext)context, ImportRewrite.TypeLocation.CAST));
            copy = cast;
        } else if (initializer instanceof ArrayInitializer && ASTNodes.getDimensions(varDecl) > 0) {
            ArrayType newType = (ArrayType)ASTNodeFactory.newType(ast, varDecl);
            ArrayCreation newArrayCreation = ast.newArrayCreation();
            newArrayCreation.setType(newType);
            newArrayCreation.setInitializer((ArrayInitializer)copy);
            return newArrayCreation;
        }
        return copy;
    }

    private List<Name> getInitializerNames(Expression initializer) {
        ScopeAnalyzer scopeAnalyzer = new ScopeAnalyzer(this.fASTRoot);
        VariableDeclaration var = this.getVariableDeclaration();
        int end = var.getStartPosition();
        final HashSet<IBinding> declarationsAtInitializer = new HashSet<IBinding>(Arrays.asList(scopeAnalyzer.getDeclarationsInScope(end, 2)));
        final ArrayList<Name> initializerNames = new ArrayList<Name>();
        if (initializer != null) {
            initializer.accept(new ASTVisitor(){

                public boolean visit(QualifiedName node) {
                    IBinding binding = node.resolveBinding();
                    if (binding instanceof IVariableBinding) {
                        initializerNames.add(node);
                    }
                    return false;
                }

                public boolean visit(SimpleName node) {
                    IBinding binding = node.resolveBinding();
                    if (binding instanceof IVariableBinding && declarationsAtInitializer.contains(binding)) {
                        initializerNames.add(node);
                    }
                    return false;
                }
            });
        }
        return initializerNames;
    }

    private Expression replaceClashingNames(final CompilationUnitRewrite rewrite, final TextEditGroup groupDesc, Expression initializer, final Map<Name, Expression> replacements) {
        final Expression copyOfInitializer = (Expression)ASTNode.copySubtree((AST)this.fASTRoot.getAST(), (ASTNode)initializer);
        final ASTMatcher astMatcher = new ASTMatcher();
        copyOfInitializer.accept(new ASTVisitor(){

            public boolean visit(QualifiedName copyOfInitializerNode) {
                return this.replace((Name)copyOfInitializerNode);
            }

            public boolean visit(SimpleName node) {
                return this.replace((Name)node);
            }

            private boolean replace(Name copyOfInitializerNode) {
                Set replacementKeySet = replacements.entrySet();
                Iterator replacementIterator = replacementKeySet.iterator();
                while (replacementIterator.hasNext()) {
                    Map.Entry replacement = replacementIterator.next();
                    Name key = (Name)replacement.getKey();
                    if ((!(key instanceof QualifiedName) || !astMatcher.match((QualifiedName)key, (Object)copyOfInitializerNode)) && (!(key instanceof SimpleName) || !astMatcher.match((SimpleName)key, (Object)copyOfInitializerNode))) continue;
                    if (copyOfInitializerNode != copyOfInitializer) {
                        rewrite.getASTRewrite().replace((ASTNode)copyOfInitializerNode, (ASTNode)replacement.getValue(), groupDesc);
                        replacementIterator.remove();
                    }
                    return false;
                }
                return false;
            }
        });
        if (!replacements.isEmpty()) {
            return replacements.values().iterator().next();
        }
        return copyOfInitializer;
    }

    private Map<Name, Expression> getClashingReplacements(SimpleName reference, List<Name> initializerNames) {
        Set<IVariableBinding> newVariables = this.getNewVariables(reference);
        HashMap<Name, Expression> replacements = new HashMap<Name, Expression>();
        block0: for (Name initializerName : initializerNames) {
            if (!this.clashesWithNewVariables(newVariables, (Expression)initializerName)) continue;
            List<Expression> alternativeQualifications = this.getAlternativeQualifications(reference, initializerName);
            for (Expression alternative : alternativeQualifications) {
                if (this.clashesWithNewVariables(newVariables, alternative)) continue;
                replacements.put(initializerName, alternative);
                continue block0;
            }
        }
        return replacements;
    }

    private List<Expression> getAlternativeQualifications(SimpleName reference, Name initializerName) {
        IVariableBinding resolvedVariableBinding;
        boolean isStatic;
        QualifiedName initializerQualifiedName;
        IBinding resolveBinding;
        ArrayList<Expression> ans = new ArrayList<Expression>();
        if (initializerName instanceof SimpleName) {
            SimpleName simpleNameInitializer = (SimpleName)initializerName;
            IBinding resolveBinding2 = simpleNameInitializer.resolveBinding();
            if (resolveBinding2 instanceof IVariableBinding) {
                IVariableBinding resolvedVariableBinding2 = (IVariableBinding)resolveBinding2;
                boolean isStatic2 = Modifier.isStatic((int)resolvedVariableBinding2.getModifiers());
                if (isStatic2) {
                    ans.add((Expression)this.createFullyQualifiedName(simpleNameInitializer, resolvedVariableBinding2.getDeclaringClass(), false));
                    ans.add((Expression)this.createFullyQualifiedName(simpleNameInitializer, resolvedVariableBinding2.getDeclaringClass(), true));
                } else if (resolvedVariableBinding2.isField()) {
                    AST ast = this.fASTRoot.getAST();
                    FieldAccess newFieldAccess = ast.newFieldAccess();
                    newFieldAccess.setExpression((Expression)ast.newThisExpression());
                    newFieldAccess.setName((SimpleName)ASTNode.copySubtree((AST)ast, (ASTNode)simpleNameInitializer));
                    ans.add((Expression)newFieldAccess);
                }
            }
        } else if (initializerName instanceof QualifiedName && (resolveBinding = (initializerQualifiedName = (QualifiedName)initializerName).resolveBinding()) instanceof IVariableBinding && (isStatic = Modifier.isStatic((int)(resolvedVariableBinding = (IVariableBinding)resolveBinding).getModifiers()))) {
            SimpleName simpleName = initializerQualifiedName.getName();
            int i = this.findCommonDeclaringClassIndex(reference, initializerQualifiedName);
            ITypeBinding initializerQualifiedNameTypeBinding = initializerQualifiedName.getQualifier().resolveTypeBinding();
            ans.add((Expression)this.createFullyQualifiedName(simpleName, initializerQualifiedNameTypeBinding, false));
            ans.add((Expression)this.createFullyQualifiedName(simpleName, initializerQualifiedNameTypeBinding, i, false));
            ans.add((Expression)this.createFullyQualifiedName(simpleName, initializerQualifiedNameTypeBinding, true));
            ans.add((Expression)this.createFullyQualifiedName(simpleName, initializerQualifiedNameTypeBinding, i, true));
        }
        return ans;
    }

    private int findCommonDeclaringClassIndex(SimpleName reference, QualifiedName initializerQualifiedName) {
        final ArrayList initializerSimpleNames = new ArrayList();
        initializerQualifiedName.accept(new ASTVisitor(){

            public boolean visit(QualifiedName qualifiedName) {
                initializerSimpleNames.add(0, qualifiedName.getName());
                qualifiedName.getQualifier().accept((ASTVisitor)this);
                return false;
            }

            public boolean visit(SimpleName simpleName) {
                initializerSimpleNames.add(0, simpleName);
                return false;
            }
        });
        TypeDeclaration typeDeclaration = (TypeDeclaration)ASTNodes.getParent((ASTNode)reference, 55);
        ITypeBinding declaringClassBinding = typeDeclaration.resolveBinding();
        int i = 1;
        while (i < initializerSimpleNames.size() && declaringClassBinding != this.getDeclaringClass((SimpleName)initializerSimpleNames.get(i))) {
            ++i;
        }
        return i;
    }

    private ITypeBinding getDeclaringClass(SimpleName simpleName) {
        IBinding resolveBinding = simpleName.resolveBinding();
        if (resolveBinding instanceof ITypeBinding) {
            return ((ITypeBinding)resolveBinding).getDeclaringClass();
        }
        if (resolveBinding instanceof IVariableBinding) {
            return ((IVariableBinding)resolveBinding).getDeclaringClass();
        }
        return null;
    }

    private boolean clashesWithNewVariables(Set<IVariableBinding> newVariables, Expression name) {
        if (name instanceof QualifiedName) {
            return this.clashesWithNewVariables(newVariables, (QualifiedName)name);
        }
        if (name instanceof SimpleName) {
            return this.clashesWithNewVariables(newVariables, (SimpleName)name);
        }
        return false;
    }

    private boolean clashesWithNewVariables(Set<IVariableBinding> newVariables, QualifiedName qualifiedName) {
        return this.clashesWithNewVariables(newVariables, ASTNodes.getLeftMostSimpleName((Name)qualifiedName));
    }

    private boolean clashesWithNewVariables(Set<IVariableBinding> newVariables, SimpleName leftMostSimpleName) {
        String leftMostSimpleNameIdentifier = leftMostSimpleName.getIdentifier();
        for (IVariableBinding newVariable : newVariables) {
            if (!newVariable.getName().equals(leftMostSimpleNameIdentifier)) continue;
            return true;
        }
        return false;
    }

    private Set<IVariableBinding> getNewVariables(SimpleName reference) {
        ScopeAnalyzer scopeAnalyzer = new ScopeAnalyzer(this.fASTRoot);
        IBinding[] declarationsAtReference = scopeAnalyzer.getDeclarationsInScope(reference.getStartPosition(), 2);
        HashSet<IVariableBinding> newVariables = new HashSet<IVariableBinding>(declarationsAtReference.length);
        IBinding[] iBindingArray = declarationsAtReference;
        int n = declarationsAtReference.length;
        int n2 = 0;
        while (n2 < n) {
            IBinding newVariable = iBindingArray[n2];
            newVariables.add((IVariableBinding)newVariable);
            ++n2;
        }
        VariableDeclaration var = this.getVariableDeclaration();
        int endPosition = var.getStartPosition() + var.getLength();
        IBinding[] iBindingArray2 = scopeAnalyzer.getDeclarationsInScope(endPosition, 2);
        int n3 = iBindingArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            IBinding oldVariable = iBindingArray2[n4];
            newVariables.remove(oldVariable);
            ++n4;
        }
        return newVariables;
    }

    private Name createFullyQualifiedName(SimpleName simpleName, ITypeBinding declaringClass, boolean addPackage) {
        return this.createFullyQualifiedName(simpleName, declaringClass, 0, addPackage);
    }

    private Name createFullyQualifiedName(SimpleName simpleName, ITypeBinding declaringClass, int numberOfClassesToSkip, boolean addPackage) {
        AST ast = this.fASTRoot.getAST();
        ArrayList<ITypeBinding> declaringClasses = new ArrayList<ITypeBinding>();
        while (declaringClass != null) {
            declaringClasses.add(declaringClass);
            declaringClass = declaringClass.getDeclaringClass();
        }
        int i = 0;
        while (i < numberOfClassesToSkip) {
            if (declaringClasses.size() <= 0) break;
            declaringClasses.remove(declaringClasses.size() - 1);
            ++i;
        }
        StringBuilder qualifiedName = new StringBuilder();
        if (addPackage && declaringClasses.size() > 0) {
            qualifiedName.append(((ITypeBinding)declaringClasses.get(declaringClasses.size() - 1)).getPackage().getName());
            qualifiedName.append('.');
        }
        int i2 = declaringClasses.size() - 1;
        while (i2 >= 0) {
            qualifiedName.append(((ITypeBinding)declaringClasses.get(i2)).getName());
            qualifiedName.append('.');
            --i2;
        }
        qualifiedName.append(simpleName.getFullyQualifiedName());
        return ast.newName(qualifiedName.toString());
    }

    private String createParameterizedInvocation(Expression invocation, ITypeBinding[] typeArguments, CompilationUnitRewrite cuRewrite) throws JavaModelException {
        MethodInvocation methodInvocation;
        Object expression;
        ASTRewrite rewrite = ASTRewrite.create((AST)invocation.getAST());
        ListRewrite typeArgsRewrite = Invocations.getInferredTypeArgumentsRewrite(rewrite, invocation);
        ITypeBinding[] iTypeBindingArray = typeArguments;
        int n = typeArguments.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding typeArgument = iTypeBindingArray[n2];
            Type typeArgumentNode = cuRewrite.getImportRewrite().addImport(typeArgument, cuRewrite.getAST());
            typeArgsRewrite.insertLast((ASTNode)typeArgumentNode, null);
            ++n2;
        }
        if (invocation instanceof MethodInvocation && (expression = (methodInvocation = (MethodInvocation)invocation).getExpression()) == null) {
            IMethodBinding methodBinding = methodInvocation.resolveMethodBinding();
            expression = methodBinding != null && Modifier.isStatic((int)methodBinding.getModifiers()) ? cuRewrite.getAST().newName(cuRewrite.getImportRewrite().addImport(methodBinding.getDeclaringClass().getTypeDeclaration())) : invocation.getAST().newThisExpression();
            rewrite.set((ASTNode)invocation, (StructuralPropertyDescriptor)MethodInvocation.EXPRESSION_PROPERTY, expression, null);
        }
        Document document = new Document(this.fCu.getBuffer().getContents());
        RangeMarker marker = new RangeMarker(invocation.getStartPosition(), invocation.getLength());
        TextEdit[] rewriteEdits = rewrite.rewriteAST((IDocument)document, this.fCu.getOptions(true)).removeChildren();
        marker.addChildren(rewriteEdits);
        try {
            marker.apply((IDocument)document, 2);
            String rewrittenInitializer = document.get(marker.getOffset(), marker.getLength());
            IRegion region = document.getLineInformation(document.getLineOfOffset(marker.getOffset()));
            int oldIndent = Strings.computeIndentUnits(document.get(region.getOffset(), region.getLength()), this.fCu);
            return Strings.changeIndent(rewrittenInitializer, oldIndent, this.fCu, "", TextUtilities.getDefaultLineDelimiter((IDocument)document));
        }
        catch (BadLocationException | MalformedTreeException e) {
            JavaManipulationPlugin.log(e);
            return this.fCu.getBuffer().getText(invocation.getStartPosition(), invocation.getLength());
        }
    }

    public SimpleName[] getReferences() {
        if (this.fReferences != null) {
            return this.fReferences;
        }
        TempOccurrenceAnalyzer analyzer = new TempOccurrenceAnalyzer(this.getVariableDeclaration(), false);
        analyzer.perform();
        this.fReferences = analyzer.getReferenceNodes();
        return this.fReferences;
    }

    private RefactoringStatus initialize(JavaRefactoringArguments arguments) {
        int length;
        int offset;
        String selection = arguments.getAttribute("selection");
        if (selection != null) {
            offset = -1;
            length = -1;
            StringTokenizer tokenizer = new StringTokenizer(selection);
            if (tokenizer.hasMoreTokens()) {
                offset = Integer.parseInt(tokenizer.nextToken());
            }
            if (tokenizer.hasMoreTokens()) {
                length = Integer.parseInt(tokenizer.nextToken());
            }
            if (offset < 0 || length < 0) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new Object[]{selection, "selection"}));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "selection"));
        }
        this.fSelectionStart = offset;
        this.fSelectionLength = length;
        String handle = arguments.getAttribute("input");
        if (handle != null) {
            IJavaElement element = JavaRefactoringDescriptorUtil.handleToElement(arguments.getProject(), handle, false);
            if (element == null || !element.exists() || element.getElementType() != 5) {
                return JavaRefactoringDescriptorUtil.createInputFatalStatus(element, this.getName(), "org.eclipse.jdt.ui.inline.temp");
            }
            this.fCu = (ICompilationUnit)element;
            if (this.checkIfTempSelected().hasFatalError()) {
                return JavaRefactoringDescriptorUtil.createInputFatalStatus(element, this.getName(), "org.eclipse.jdt.ui.inline.temp");
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
        }
        return new RefactoringStatus();
    }
}

