/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.manipulation;

import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.manipulation.JavaManipulation;
import org.eclipse.jdt.internal.core.manipulation.CodeTemplateContextType;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateTranslator;
import org.eclipse.jface.text.templates.TemplateVariableResolver;

public class CodeTemplateContext
extends TemplateContext {
    private String fLineDelimiter;
    private IJavaProject fProject;

    public CodeTemplateContext(String contextTypeName, IJavaProject project, String lineDelim) {
        super(JavaManipulation.getCodeTemplateContextRegistry().getContextType(contextTypeName));
        this.fLineDelimiter = lineDelim;
        this.fProject = project;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IProject.class) {
            return adapter.cast(this.getJavaProject().getProject());
        }
        return (T)super.getAdapter(adapter);
    }

    public IJavaProject getJavaProject() {
        return this.fProject;
    }

    public TemplateBuffer evaluate(Template template) throws BadLocationException, TemplateException {
        Iterator iterator = this.getContextType().resolvers();
        while (iterator.hasNext()) {
            TemplateVariableResolver var = (TemplateVariableResolver)iterator.next();
            if (!(var instanceof CodeTemplateContextType.CodeTemplateVariableResolver)) continue;
            Assert.isNotNull((Object)this.getVariable(var.getType()), (String)("Variable " + var.getType() + "not defined"));
        }
        if (!this.canEvaluate(template)) {
            return null;
        }
        String pattern = CodeTemplateContext.changeLineDelimiter(template.getPattern(), this.fLineDelimiter);
        TemplateTranslator translator = new TemplateTranslator();
        TemplateBuffer buffer = translator.translate(pattern);
        this.getContextType().resolve(buffer, (TemplateContext)this);
        return buffer;
    }

    private static String changeLineDelimiter(String code, String lineDelim) {
        try {
            DefaultLineTracker tracker = new DefaultLineTracker();
            tracker.set(code);
            int nLines = tracker.getNumberOfLines();
            if (nLines == 1) {
                return code;
            }
            StringBuilder buf = new StringBuilder();
            int i = 0;
            while (i < nLines) {
                if (i != 0) {
                    buf.append(lineDelim);
                }
                IRegion region = tracker.getLineInformation(i);
                String line = code.substring(region.getOffset(), region.getOffset() + region.getLength());
                buf.append(line);
                ++i;
            }
            return buf.toString();
        }
        catch (BadLocationException e) {
            return code;
        }
    }

    public boolean canEvaluate(Template template) {
        return true;
    }

    public void setCompilationUnitVariables(ICompilationUnit cu) {
        this.setVariable("file_name", cu.getElementName());
        this.setVariable("package_name", cu.getParent().getElementName());
        this.setVariable("project_name", cu.getJavaProject().getElementName());
    }
}

