/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.launching.sourcelookup.advanced;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.sourcelookup.IPersistableSourceLocator2;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.internal.launching.sourcelookup.advanced.BackgroundProcessingJob;
import org.eclipse.jdt.internal.launching.sourcelookup.advanced.IRunnableWithProgress;
import org.eclipse.jdt.internal.launching.sourcelookup.advanced.WorkspaceProjectSourceContainers;

public class AdvancedSourceLookupSupport {
    public static final String ID_sourceContainerResolvers = "org.eclipse.jdt.launching.sourceContainerResolvers";
    public static final String ID_workspaceProjectDescribers = "org.eclipse.jdt.launching.workspaceProjectDescribers";
    private static BackgroundProcessingJob backgroundJob;
    private static volatile WorkspaceProjectSourceContainers workspaceProjects;
    private static final Lock workspaceProjectsLock;

    static {
        workspaceProjectsLock = new ReentrantLock();
    }

    private AdvancedSourceLookupSupport() {
    }

    public static void start() {
        backgroundJob = new BackgroundProcessingJob();
    }

    public static void stop() {
        backgroundJob.cancel();
        backgroundJob = null;
        workspaceProjectsLock.lock();
        try {
            if (workspaceProjects != null) {
                workspaceProjects.close();
                workspaceProjects = null;
            }
        }
        finally {
            workspaceProjectsLock.unlock();
        }
    }

    public static void schedule(IRunnableWithProgress task) {
        backgroundJob.schedule(task);
    }

    public static WorkspaceProjectSourceContainers getWorkspaceJavaProjects(IProgressMonitor monitor) throws CoreException {
        return AdvancedSourceLookupSupport.getWorkspaceJavaProjects0(monitor);
    }

    /*
     * Exception decompiling
     */
    private static WorkspaceProjectSourceContainers getWorkspaceJavaProjects0(IProgressMonitor monitor) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String getJavaagentString() {
        return "-javaagent:\"" + AdvancedSourceLookupSupport.getJavaagentLocation() + "\"";
    }

    public static String getJavaagentLocation() {
        return LaunchingPlugin.getFileInPlugin((IPath)new Path("lib/javaagent-shaded.jar")).getAbsolutePath();
    }

    public static IProgressMonitor getContextMonitor(IProgressMonitor monitor) {
        Job job;
        if (monitor == null && (job = Job.getJobManager().currentJob()) != null) {
            monitor = new NullProgressMonitor();
        }
        return monitor;
    }

    public static ILaunch createAdvancedLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return new Launch(configuration, mode, (ISourceLocator)AdvancedSourceLookupSupport.createSourceLocator("org.eclipse.jdt.launching.sourceLocator.JavaAdvancedSourceLookupDirector", configuration));
    }

    public static IPersistableSourceLocator createSourceLocator(String type, ILaunchConfiguration configuration) throws CoreException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        IPersistableSourceLocator locator = launchManager.newSourceLocator(type);
        String memento = configuration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, null);
        if (memento == null) {
            locator.initializeDefaults(configuration);
        } else if (locator instanceof IPersistableSourceLocator2) {
            ((IPersistableSourceLocator2)locator).initializeFromMemento(memento, configuration);
        } else {
            locator.initializeFromMemento(memento);
        }
        return locator;
    }

    public static boolean isAdvancedSourcelookupEnabled() {
        return Platform.getPreferencesService().getBoolean(JDIDebugPlugin.getUniqueIdentifier(), JDIDebugPlugin.PREF_ENABLE_ADVANCED_SOURCELOOKUP, true, null);
    }
}

