/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.platform.internal.ui.commands;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.bindings.Trigger;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.formatting.KeyFormatterFactory;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.platform.ui.commands.GetHotkey;
import org.eclipse.rcptt.ecl.runtime.ICommandService;
import org.eclipse.rcptt.ecl.runtime.IProcess;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;

public class GetCommandHotkeyService
implements ICommandService {
    public IStatus service(Command command, IProcess context) throws InterruptedException, CoreException {
        if (!(command instanceof GetHotkey)) {
            return Status.CANCEL_STATUS;
        }
        GetHotkey getCommand = (GetHotkey)command;
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
        TriggerSequence[] triggerSequenceArray = bindingService.getActiveBindingsFor(getCommand.getCommandId());
        int n = triggerSequenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            TriggerSequence binding = triggerSequenceArray[n2];
            Trigger[] triggerArray = binding.getTriggers();
            int n3 = triggerArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Trigger trigger = triggerArray[n4];
                if (trigger instanceof KeyStroke) {
                    KeyStroke keyStroke = (KeyStroke)trigger;
                    context.getOutput().write((Object)keyStroke.toString());
                    return Status.OK_STATUS;
                }
                ++n4;
            }
            ++n2;
        }
        return new Status(4, "org.eclipse.rcptt.ecl.platform.ui", "No keyboard hotkey is defined for " + getCommand.getCommandId() + " in current context");
    }

    public static String formatKeyWithMeta(int mask, int keyCode, int meta) {
        if (meta == 0) {
            return KeyFormatterFactory.getFormalKeyFormatter().format(KeyStroke.getInstance((int)mask, (int)keyCode));
        }
        String strKey = GetCommandHotkeyService.getMeta(meta);
        if (!strKey.equals("")) {
            strKey = String.valueOf(strKey) + "+";
        }
        strKey = String.valueOf(strKey) + KeyFormatterFactory.getFormalKeyFormatter().format(keyCode);
        return strKey;
    }

    public static String getMeta(int stateMask) {
        MetaBuilder rv = new MetaBuilder();
        rv.process(stateMask);
        return rv.toString();
    }

    static class MetaBuilder {
        final StringBuilder sb = new StringBuilder();

        MetaBuilder() {
        }

        void addMeta(String key) {
            if (this.sb.length() > 0) {
                this.sb.append("+");
            }
            this.sb.append(key);
        }

        void tryMeta(int stateMask, int keyMask, String key) {
            if ((stateMask & keyMask) != 0) {
                this.addMeta(key);
            }
        }

        void process(int stateMask) {
            if (Platform.getOS().equals("macosx")) {
                this.tryMeta(stateMask, 0x400000, "M1");
                this.tryMeta(stateMask, 131072, "M2");
                this.tryMeta(stateMask, 65536, "M3");
                this.tryMeta(stateMask, 262144, "M4");
            } else {
                this.tryMeta(stateMask, 262144, "M1");
                this.tryMeta(stateMask, 131072, "M2");
                this.tryMeta(stateMask, 65536, "M3");
            }
        }

        public String toString() {
            return this.sb.toString();
        }
    }
}

