/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.target;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetHandle;
import org.eclipse.pde.internal.core.target.AbstractTargetHandle;
import org.eclipse.pde.internal.core.target.Messages;
import org.eclipse.pde.internal.core.target.P2TargetUtils;
import org.eclipse.pde.internal.core.target.TargetDefinition;

public class WorkspaceFileTargetHandle
extends AbstractTargetHandle {
    private final IFile fFile;
    static final String SCHEME = "resource";

    static ITargetHandle restoreHandle(URI uri) {
        String part = uri.getSchemeSpecificPart();
        IPath path = IPath.fromOSString((String)part);
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        return new WorkspaceFileTargetHandle(file);
    }

    public WorkspaceFileTargetHandle(IFile file) {
        this.fFile = file;
    }

    @Override
    public String getMemento() throws CoreException {
        try {
            URI uri = new URI(SCHEME, this.fFile.getFullPath().toPortableString(), null);
            return uri.toString();
        }
        catch (URISyntaxException e) {
            throw new CoreException(Status.error((String)Messages.WorkspaceFileTargetHandle_0, (Throwable)e));
        }
    }

    @Override
    void doSave(ITargetDefinition definition) throws CoreException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ((TargetDefinition)definition).write(outputStream);
        ByteArrayInputStream stream = new ByteArrayInputStream(outputStream.toByteArray());
        if (!this.fFile.exists()) {
            this.fFile.create((InputStream)stream, false, null);
        } else {
            IStatus status;
            if (this.fFile.isReadOnly() && !(status = ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{this.fFile}, null)).isOK()) {
                throw new CoreException(status);
            }
            this.fFile.setContents((InputStream)stream, true, false, null);
        }
    }

    @Override
    protected InputStream getInputStream() throws CoreException {
        return this.fFile.getContents();
    }

    @Override
    public boolean exists() {
        return this.fFile.exists();
    }

    public boolean equals(Object obj) {
        if (obj instanceof WorkspaceFileTargetHandle) {
            WorkspaceFileTargetHandle handle = (WorkspaceFileTargetHandle)obj;
            return this.fFile.equals((Object)handle.fFile);
        }
        return false;
    }

    public int hashCode() {
        return this.fFile.hashCode() + this.getClass().hashCode();
    }

    @Override
    void delete() throws CoreException {
        if (this.fFile.exists()) {
            this.fFile.delete(false, null);
        }
        P2TargetUtils.deleteProfile(this);
    }

    public String toString() {
        return this.fFile.getName();
    }

    public IFile getTargetFile() {
        return this.fFile;
    }
}

