/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.ecl.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.rcptt.core.ecl.model.BuiltinContainer;
import org.eclipse.rcptt.core.ecl.model.CompositeContainer;
import org.eclipse.rcptt.core.ecl.model.IDeclContainer;
import org.eclipse.rcptt.core.ecl.model.ProcDecl;
import org.eclipse.rcptt.core.ecl.model.SrcLoc;
import org.eclipse.rcptt.core.ecl.model.VarDecl;
import org.eclipse.rcptt.core.ecl.model.providers.DeclarationFactory;
import org.eclipse.rcptt.core.ecl.parser.ast.Parser;
import org.eclipse.rcptt.core.ecl.parser.ast.Script;
import org.eclipse.rcptt.core.ecl.parser.model.LocalContainer;
import org.eclipse.rcptt.core.internal.ecl.parser.Q7EclParserPlugin;
import org.eclipse.rcptt.core.model.IContext;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.IQ7ProjectMetadata;
import org.eclipse.rcptt.core.model.ITestCase;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.model.search.Q7SearchCore;
import org.eclipse.rcptt.core.scenario.NamedElement;
import org.eclipse.rcptt.core.scenario.Scenario;
import org.eclipse.rcptt.core.scenario.ScenarioProperty;
import org.eclipse.rcptt.core.workspace.Q7Utils;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.core.model.Q7InternalTestCase;

public class Q7ElementContainer
implements IDeclContainer {
    private IDeclContainer composite;
    private String resource;
    public final Script script;
    public int offset;
    private LocalContainer localDeclarations = null;
    private LocalContainer propertyDeclarations = null;
    private List<IDeclContainer> referenceDeclarations = new ArrayList<IDeclContainer>();
    private boolean buildins = true;
    private String text;
    private String referencesList;

    public Q7ElementContainer(IQ7NamedElement element, String text, int offset, boolean includeBuiltin) {
        this.resource = Q7Utils.safeGetId((IQ7NamedElement)element);
        this.script = Parser.parse(text);
        this.text = text;
        this.offset = offset;
        this.buildins = includeBuiltin;
        this.localDeclarations = LocalContainer.fromScript(this.script, offset, this.resource);
        this.calculatePropertyDeclarations(element);
        this.referenceDeclarations = new ArrayList<IDeclContainer>();
        this.referencesList = this.calculateDependenciesHash(element);
        this.initReferences(element);
        this.initComposite();
    }

    private void calculatePropertyDeclarations(IQ7NamedElement element) {
        if (element == null) {
            return;
        }
        try {
            this.propertyDeclarations = new LocalContainer();
            NamedElement namedElement = element.getNamedElement();
            if (namedElement instanceof Scenario) {
                EList properties = ((Scenario)namedElement).getProperties();
                for (ScenarioProperty sp : properties) {
                    this.propertyDeclarations.addVar(new VarDecl(sp.getName(), new SrcLoc(0, 0)));
                }
            }
        }
        catch (ModelException e) {
            Q7EclParserPlugin.log((CoreException)e);
        }
    }

    public boolean isSameContent(String value, IQ7NamedElement element) {
        String hash = this.calculateDependenciesHash(element);
        return this.text.equals(value) && this.referencesList.equals(hash);
    }

    private String calculateDependenciesHash(IQ7NamedElement element) {
        StringBuilder bb = new StringBuilder();
        IContext[] iContextArray = Q7ElementContainer.getReferencedContexts(element);
        int n = iContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContext context = iContextArray[n2];
            try {
                bb.append("_").append(context.getID());
            }
            catch (ModelException e) {
                RcpttPlugin.log((Throwable)e);
            }
            ++n2;
        }
        if (element != null && element.isWorkingCopy() && element instanceof ITestCase) {
            try {
                String[] ctxs = ((ITestCase)element).getContexts();
                if (ctxs != null) {
                    String[] stringArray = ctxs;
                    int n3 = ctxs.length;
                    n = 0;
                    while (n < n3) {
                        String ctx = stringArray[n];
                        bb.append("_").append(ctx);
                        ++n;
                    }
                }
            }
            catch (ModelException e) {
                RcpttPlugin.log((Throwable)e);
            }
        }
        return bb.toString();
    }

    public void setOffset(int offset) {
        this.offset = offset;
        this.localDeclarations = LocalContainer.fromScript(this.script, offset, this.resource);
        this.initComposite();
    }

    private void initComposite() {
        ArrayList<IDeclContainer> all = new ArrayList<IDeclContainer>();
        if (this.localDeclarations != null) {
            all.add(this.localDeclarations);
        }
        all.addAll(this.referenceDeclarations);
        if (this.buildins) {
            all.add(BuiltinContainer.INSTANCE);
        }
        all.add(this.propertyDeclarations);
        this.composite = new CompositeContainer(all.toArray(new IDeclContainer[0]));
    }

    private void initReferences(IQ7NamedElement element) {
        IContext[] referenced;
        IContext[] iContextArray = referenced = Q7ElementContainer.getReferencedContexts(element);
        int n = referenced.length;
        int n2 = 0;
        while (n2 < n) {
            IContext context = iContextArray[n2];
            IDeclContainer container = DeclarationFactory.INSTANCE.safeFromContext(context);
            if (container != null) {
                this.referenceDeclarations.add(container);
            }
            ++n2;
        }
    }

    private static IContext[] getReferencedContexts(IQ7NamedElement element) {
        if (element == null) {
            return new IContext[0];
        }
        try {
            ArrayList<IContext> result = new ArrayList<IContext>();
            if (element instanceof Q7InternalTestCase) {
                Scenario scenario = ((Q7InternalTestCase)element).getNamedElement();
                for (String id : scenario.getContexts()) {
                    IQ7NamedElement ref = Q7SearchCore.findById((String)id);
                    if (!(ref instanceof IContext)) continue;
                    result.add((IContext)ref);
                }
                return result.toArray(new IContext[result.size()]);
            }
            if (element instanceof ITestCase) {
                String[] ids = ((ITestCase)element).getContexts();
                return RcpttCore.getInstance().getContexts((IQ7NamedElement)((ITestCase)element), Arrays.asList(ids), null, true);
            }
            IQ7ProjectMetadata metadata = element.getQ7Project().getMetadata();
            if (metadata.exists()) {
                String[] ids;
                String[] stringArray = ids = metadata.getContexts();
                int n = ids.length;
                int n2 = 0;
                while (n2 < n) {
                    String id = stringArray[n2];
                    IQ7NamedElement ref = Q7SearchCore.findById((String)id);
                    if (ref instanceof IContext) {
                        result.add((IContext)ref);
                    }
                    ++n2;
                }
            }
            return result.toArray(new IContext[result.size()]);
        }
        catch (ModelException e) {
            return new IContext[0];
        }
    }

    @Override
    public String getResource() {
        return this.resource;
    }

    @Override
    public ProcDecl resolveProc(String name) {
        return this.composite.resolveProc(name);
    }

    @Override
    public VarDecl resolveVar(String name) {
        return this.composite.resolveVar(name);
    }

    @Override
    public ProcDecl[] getProcs() {
        return this.composite.getProcs();
    }

    @Override
    public VarDecl[] getVars() {
        return this.composite.getVars();
    }

    public void includeBuildins(boolean b) {
        this.buildins = b;
    }
}

