/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.slf4j;

import org.osgi.service.log.Logger;
import org.slf4j.Marker;
import org.slf4j.event.Level;
import org.slf4j.helpers.AbstractLogger;
import org.slf4j.helpers.MessageFormatter;

class EquinoxLogger
extends AbstractLogger {
    private static final long serialVersionUID = 1L;
    private final Logger logger;

    EquinoxLogger(String name, Logger logger) {
        this.name = name;
        this.logger = logger;
    }

    public boolean isTraceEnabled() {
        return this.logger != null && this.logger.isTraceEnabled();
    }

    public boolean isDebugEnabled() {
        return this.logger != null && this.logger.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.logger != null && this.logger.isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.logger != null && this.logger.isWarnEnabled();
    }

    public boolean isErrorEnabled() {
        return this.logger != null && this.logger.isErrorEnabled();
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.isTraceEnabled();
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.isDebugEnabled();
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.isInfoEnabled();
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.isWarnEnabled();
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.isErrorEnabled();
    }

    protected String getFullyQualifiedCallerName() {
        return null;
    }

    protected void handleNormalizedLoggingCall(Level level, Marker marker, String messagePattern, Object[] arguments, Throwable throwable) {
        String formattedMessage;
        if (this.logger == null) {
            return;
        }
        if (level == Level.TRACE && this.logger.isTraceEnabled()) {
            formattedMessage = MessageFormatter.basicArrayFormat((String)messagePattern, (Object[])arguments);
            this.logger.trace(formattedMessage, (Object)throwable);
        }
        if (level == Level.DEBUG && this.logger.isDebugEnabled()) {
            formattedMessage = MessageFormatter.basicArrayFormat((String)messagePattern, (Object[])arguments);
            this.logger.debug(formattedMessage, (Object)throwable);
        }
        if (level == Level.WARN && this.logger.isWarnEnabled()) {
            formattedMessage = MessageFormatter.basicArrayFormat((String)messagePattern, (Object[])arguments);
            this.logger.warn(formattedMessage, (Object)throwable);
        }
        if (level == Level.INFO && this.logger.isInfoEnabled()) {
            formattedMessage = MessageFormatter.basicArrayFormat((String)messagePattern, (Object[])arguments);
            this.logger.info(formattedMessage, (Object)throwable);
        }
        if (level == Level.ERROR && this.logger.isInfoEnabled()) {
            formattedMessage = MessageFormatter.basicArrayFormat((String)messagePattern, (Object[])arguments);
            this.logger.info(formattedMessage, (Object)throwable);
        }
    }
}

