/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.launching.p2utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipInputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.director.PermissiveSlicer;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.Util;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.actions.CollectAction;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.internal.repository.mirroring.Mirroring;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRequest;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.rcptt.launching.p2utils.Q7P2UtilsActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class P2Utils {
    public static ITargetPlatformService getTargetService() {
        Class<ITargetPlatformService> serviceClass = ITargetPlatformService.class;
        return P2Utils.getPDECoreService(serviceClass);
    }

    private static <T> T getPDECoreService(Class<T> serviceClass) {
        BundleContext context = FrameworkUtil.getBundle(P2Utils.class).getBundleContext();
        ServiceReference reference = context.getServiceReference(serviceClass);
        try {
            Object object = context.getService(reference);
            return (T)object;
        }
        finally {
            context.ungetService(reference);
        }
    }

    public static IMetadataRepositoryManager getRepositoryManager() throws CoreException {
        return P2Utils.getRepositoryManager(P2Utils.getProvisioningAgent());
    }

    public static IProvisioningAgent getProvisioningAgent() {
        return P2Utils.getPDECoreService(IProvisioningAgent.class);
    }

    public static IMetadataRepositoryManager getRepositoryManager(IProvisioningAgent agent) throws CoreException {
        if (agent == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", "Failed to locate repository. Can't get service " + IProvisioningAgent.SERVICE_NAME));
        }
        IMetadataRepositoryManager manager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
        if (manager == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", "Failed to locate repository. No metadata repository manager found."));
        }
        return manager;
    }

    public static IArtifactRepositoryManager getArtifactRepositoryManager() throws CoreException {
        return P2Utils.getArtifactRepositoryManager(P2Utils.getProvisioningAgent());
    }

    public static IArtifactRepositoryManager getArtifactRepositoryManager(IProvisioningAgent agent) throws CoreException {
        if (agent == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", "Failed to locate repository. Can't get service " + IProvisioningAgent.SERVICE_NAME));
        }
        IArtifactRepositoryManager manager = (IArtifactRepositoryManager)agent.getService(IArtifactRepositoryManager.SERVICE_NAME);
        if (manager == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", "Failed to locate repository. No metadata repository manager found."));
        }
        return manager;
    }

    public static IMetadataRepository safeLoadRepository(URI uri, IProgressMonitor monitor, IProvisioningAgent agent) throws CoreException {
        try {
            IMetadataRepositoryManager rm = P2Utils.getRepositoryManager(agent);
            rm.removeRepository(uri);
            try {
                rm.refreshRepository(uri, monitor);
            }
            catch (ProvisionException provisionException) {
                // empty catch block
            }
            return rm.loadRepository(uri, monitor);
        }
        catch (RuntimeException e) {
            if (e instanceof OperationCanceledException || monitor.isCanceled()) {
                throw new CoreException((IStatus)new Status(8, "org.eclipse.rcptt.launching.p2utils", "Repository load cancelled", (Throwable)e));
            }
            throw e;
        }
    }

    public static IArtifactRepository safeLoadArtifactRepository(URI uri, IProgressMonitor monitor, IProvisioningAgent agent) {
        try {
            IArtifactRepositoryManager rm = P2Utils.getArtifactRepositoryManager(agent);
            rm.removeRepository(uri);
            try {
                rm.refreshRepository(uri, monitor);
            }
            catch (ProvisionException provisionException) {
                // empty catch block
            }
            return rm.loadRepository(uri, monitor);
        }
        catch (Throwable e) {
            if (e instanceof OperationCanceledException || monitor.isCanceled()) {
                return null;
            }
            Q7P2UtilsActivator.getDefault().log(e);
            return null;
        }
    }

    public static Set<String> mapUnitsToId(Set<IInstallableUnit> availableUnits) {
        HashSet<String> unitIDs = new HashSet<String>();
        for (IInstallableUnit u : availableUnits) {
            unitIDs.add(u.getId());
        }
        return unitIDs;
    }

    public static List<IQuery<IInstallableUnit>> mapUnitsToQuery(Set<String> units) {
        ArrayList<IQuery<IInstallableUnit>> queries = new ArrayList<IQuery<IInstallableUnit>>();
        for (String id : units) {
            queries.add((IQuery<IInstallableUnit>)QueryUtil.createIUQuery((String)id));
        }
        return queries;
    }

    public static List<IQuery<IInstallableUnit>> mapUnitsToCategoryQuery(Collection<IInstallableUnit> units) {
        ArrayList<IQuery<IInstallableUnit>> queries = new ArrayList<IQuery<IInstallableUnit>>();
        for (IInstallableUnit unit : units) {
            Collection requirements = unit.getRequirements();
            for (IRequirement req : requirements) {
                queries.add((IQuery<IInstallableUnit>)QueryUtil.createMatchQuery((IExpression)req.getMatches(), (Object[])new Object[0]));
            }
        }
        return queries;
    }

    public static IQuery<IInstallableUnit> createQuery(Collection<String> unitExpressions) {
        IQuery finalQuery = null;
        if (unitExpressions.isEmpty()) {
            finalQuery = QueryUtil.ALL_UNITS;
        } else {
            List<IQuery<IInstallableUnit>> items = P2Utils.mapUnitsToQuery(Set.copyOf(unitExpressions));
            finalQuery = QueryUtil.createLatestQuery((IQuery)QueryUtil.createCompoundQuery(items, (boolean)false));
        }
        return finalQuery;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IStatus validateBundle(File file) {
        if (!file.exists()) {
            return new Status(4, "org.eclipse.rcptt.launching.p2utils", "File " + String.valueOf(file) + " does not exist");
        }
        if (file.isDirectory()) {
            return Status.OK_STATUS;
        }
        if (file.getName().toLowerCase().endsWith(".jar") == false) return Status.OK_STATUS;
        try {
            var1_1 = null;
            var2_4 = null;
            try {
                block22: {
                    stream = new BufferedInputStream(new FileInputStream(file));
                    try {
                        block23: {
                            zin = new ZipInputStream(stream);
                            names = new HashSet<String>();
lbl15:
                            // 2 sources

                            while (true) {
                                entry = zin.getNextEntry();
                                if (entry == null) {
                                    if (names.size() != 0) break block22;
                                    v0 = new Status(4, "org.eclipse.rcptt.launching.p2utils", "Empty ZIP archive " + String.valueOf(file));
                                    if (zin == null) break block23;
                                }
                                ** GOTO lbl-1000
                                break;
                            }
                            zin.close();
                        }
                        if (stream == null) return v0;
                    }
                    catch (Throwable var2_5) {
                        if (var1_1 == null) {
                            var1_1 = var2_5;
                        } else if (var1_1 != var2_5) {
                            var1_1.addSuppressed(var2_5);
                        }
                        if (stream == null) throw var1_1;
                        stream.close();
                        throw var1_1;
                    }
                    stream.close();
                    return v0;
                }
                ** try [egrp 5[TRYBLOCK] [1 : 153->156)] { 
lbl42:
                // 1 sources

                return Status.OK_STATUS;
                while (true) {
                    if (stream == null) return v1;
                    stream.close();
                    return v1;
                }
lbl-1000:
                // 1 sources

                {
                    names.add(entry.getName());
                    ** continue;
                }
lbl50:
                // 1 sources

                finally {
                    if (zin == null) ** continue;
                    zin.close();
                }
            }
            catch (Throwable var2_6) {
                if (var1_1 == null) {
                    var1_1 = var2_6;
                    throw var1_1;
                }
                if (var1_1 == var2_6) throw var1_1;
                var1_1.addSuppressed(var2_6);
                throw var1_1;
            }
        }
        catch (Throwable e) {
            return new Status(4, "org.eclipse.rcptt.launching.p2utils", "Failed to check " + String.valueOf(file), e);
        }
    }

    public static void installUnits(IProgressMonitor monitor, IArtifactRepository artifactRepository, IFileArtifactRepository filesRepository, List<IInstallableUnit> toInstall, int installTryCount, ILogMonitor logMonitor, boolean useRaw, IProvisioningAgent agent) throws CoreException {
        if (logMonitor != null) {
            logMonitor.log("Downloading artifacts to: " + filesRepository.getLocation().toString());
        }
        filesRepository.setProperty("eclipse.p2.force.threading", "true");
        while (toInstall.size() > 0) {
            ArrayList<IArtifactKey> keys = new ArrayList<IArtifactKey>();
            for (IInstallableUnit unit : toInstall) {
                keys.addAll(unit.getArtifacts());
            }
            ArrayList<IArtifactRequest> requests = new ArrayList<IArtifactRequest>();
            if (useRaw) {
                P2Utils.rawMirror(artifactRepository, filesRepository, logMonitor, agent, keys);
            } else {
                for (IInstallableUnit unit : toInstall) {
                    Collection toDownload = unit.getArtifacts();
                    for (IArtifactKey key : toDownload) {
                        Map repositoryProperties = CollectAction.createArtifactDescriptorProperties((IInstallableUnit)unit);
                        requests.add(Util.getArtifactRepositoryManager((IProvisioningAgent)agent).createMirrorRequest(key, (IArtifactRepository)filesRepository, null, repositoryProperties));
                    }
                }
                if (requests.size() == 0) break;
                artifactRepository.getArtifacts(requests.toArray(new IArtifactRequest[requests.size()]), monitor);
            }
            MultiStatus rv = new MultiStatus("org.eclipse.rcptt.launching.p2utils", 0, "Failed to install bundles", null);
            ArrayList<IInstallableUnit> installedOK = new ArrayList<IInstallableUnit>();
            for (IInstallableUnit unit : toInstall) {
                Collection toDownload = unit.getArtifacts();
                if (toDownload == null || toDownload.size() == 0) {
                    installedOK.add(unit);
                    continue;
                }
                for (IArtifactKey key : toDownload) {
                    File file = filesRepository.getArtifactFile(key);
                    if (file != null && file.exists()) {
                        IStatus result = P2Utils.validateBundle(file);
                        if (result.isOK()) {
                            installedOK.add(unit);
                            continue;
                        }
                        rv.add(result);
                    }
                    filesRepository.removeDescriptor(key, monitor);
                }
            }
            toInstall.removeAll(installedOK);
            if (toInstall.size() == 0) {
                return;
            }
            if (--installTryCount < 0) {
                throw new CoreException((IStatus)rv);
            }
            if (logMonitor == null) continue;
            logMonitor.log("Artifacts left on iteration: " + toInstall.size() + " retrying: " + installTryCount + "delay: 5 seconds");
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
        }
    }

    private static void rawMirror(IArtifactRepository artifactRepository, IFileArtifactRepository filesRepository, ILogMonitor logMonitor, IProvisioningAgent agent, List<IArtifactKey> keys) {
        MultiStatus result;
        Mirroring mirror = new Mirroring(artifactRepository, (IArtifactRepository)filesRepository, true);
        mirror.setCompare(false);
        mirror.setComparatorId(null);
        mirror.setBaseline(null);
        mirror.setValidate(false);
        mirror.setCompareExclusions(null);
        mirror.setTransport((Transport)agent.getService(Transport.SERVICE_NAME));
        if (keys.size() > 0) {
            mirror.setArtifactKeys(keys.toArray(new IArtifactKey[keys.size()]));
        }
        if ((result = mirror.run(false, false)) != null && !result.isOK() && logMonitor != null) {
            logMonitor.log("Mirroring is failed: " + result.getMessage());
        }
    }

    public static IQuery<IInstallableUnit> createContainmentQuery(Set<IInstallableUnit> availableUnits) {
        return QueryUtil.createCompoundQuery(P2Utils.mapUnitsToCategoryQuery(availableUnits), (boolean)false);
    }

    public static void expandFeatures(IProgressMonitor monitor, IMetadataRepository repository, Set<IInstallableUnit> availableUnits) {
        PermissiveSlicer slicer = new PermissiveSlicer((IQueryable)repository, new Hashtable(), false, true, true, true, false);
        IQueryable slice = slicer.slice(availableUnits, monitor);
        availableUnits.addAll(slice.query(QueryUtil.ALL_UNITS, monitor).toSet());
    }

    public static interface ILogMonitor {
        public void log(String var1);
    }
}

