/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.internal.debug.runtime;

import java.net.Socket;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.rcptt.ecl.core.CommandStack;
import org.eclipse.rcptt.ecl.core.GetVal;
import org.eclipse.rcptt.ecl.core.IStackListener;
import org.eclipse.rcptt.ecl.core.ProcInstance;
import org.eclipse.rcptt.ecl.debug.model.BreakpointCmd;
import org.eclipse.rcptt.ecl.debug.model.DebugCmd;
import org.eclipse.rcptt.ecl.debug.model.EventType;
import org.eclipse.rcptt.ecl.debug.model.ModelFactory;
import org.eclipse.rcptt.ecl.debug.model.ResolveVariableCmd;
import org.eclipse.rcptt.ecl.debug.model.ResolveVariableEvent;
import org.eclipse.rcptt.ecl.debug.model.SkipAllCmd;
import org.eclipse.rcptt.ecl.debug.model.StackFrame;
import org.eclipse.rcptt.ecl.debug.model.Variable;
import org.eclipse.rcptt.ecl.debug.runtime.ModelUtils;
import org.eclipse.rcptt.ecl.debug.runtime.Session;
import org.eclipse.rcptt.ecl.debug.runtime.SuspendManager;
import org.eclipse.rcptt.ecl.gen.ast.AstExec;
import org.eclipse.rcptt.ecl.internal.core.CorePlugin;
import org.eclipse.rcptt.ecl.internal.debug.runtime.EclStackSupport;
import org.eclipse.rcptt.ecl.internal.debug.runtime.Log;
import org.eclipse.rcptt.ecl.internal.debug.runtime.MultiLatch;

public class ServerSession
extends Session
implements IStackListener {
    private int lastLine = -1;
    private int lastStackLevel = 0;
    private int stepOverStackLevel = 0;
    private EclStackSupport stackSupport = null;
    private List<StackFrame> currentFrame = null;
    private Map<String, Variable> currentVariables = new HashMap<String, Variable>();
    private volatile StepKind step = StepKind.None;
    private volatile boolean skip = false;
    private final MultiLatch latch = new MultiLatch();
    private final String id;
    private final Map<String, Set<Integer>> breakpoints = new HashMap<String, Set<Integer>>();

    public ServerSession(Socket socket, String id) throws CoreException {
        super(socket);
        this.id = id;
        this.stackSupport = new EclStackSupport(this.id);
        CommandStack.addListener((IStackListener)this);
        this.request(ModelUtils.createEvent(EventType.STARTED));
    }

    @Override
    public void terminate() {
        CommandStack.removeListener((IStackListener)this);
        super.terminate();
        this.latch.unlock();
    }

    public void enter(CommandStack stack) {
        try {
            List<StackFrame> frames = this.stackSupport.getFrames(stack);
            if (frames != null) {
                if (stack.getCommand() instanceof GetVal || stack.getCommand() instanceof AstExec) {
                    return;
                }
                if (this.lastLine != frames.get(0).getLine()) {
                    this.lastLine = -1;
                }
                this.lastStackLevel = this.getStackLevel(stack);
                if (this.latch.isLocked()) {
                    if (StepKind.StepOver.equals((Object)this.step)) {
                        if (this.lastLine != frames.get(0).getLine() && this.stepOverStackLevel >= this.lastStackLevel) {
                            this.lastLine = frames.get(0).getLine();
                            this.setCurrentState(frames);
                            this.request(ModelUtils.createStackEvent(EventType.STEP_ENDED, frames));
                            this.await();
                        }
                    } else if (StepKind.StepReturn.equals((Object)this.step)) {
                        if (this.lastLine != frames.get(0).getLine() && (this.stepOverStackLevel > this.lastStackLevel || this.lastStackLevel == 0)) {
                            this.lastLine = frames.get(0).getLine();
                            this.setCurrentState(frames);
                            this.request(ModelUtils.createStackEvent(EventType.STEP_ENDED, frames));
                            this.await();
                        }
                    } else {
                        this.setCurrentState(frames);
                        if (StepKind.Step.equals((Object)this.step)) {
                            this.request(ModelUtils.createStackEvent(EventType.STEP_ENDED, frames));
                        } else {
                            this.request(ModelUtils.createStackEvent(EventType.SUSPENDED, frames));
                        }
                        this.await();
                    }
                } else if (this.isHitBreakpoint(frames.get(0)) && this.lastLine != frames.get(0).getLine()) {
                    this.lastLine = frames.get(0).getLine();
                    this.setCurrentState(frames);
                    this.latch.lock();
                    this.request(ModelUtils.createStackEvent(EventType.BREAKPOINT_HIT, frames));
                    this.await();
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (CoreException e) {
            CorePlugin.err((String)e.getMessage(), (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    private int getStackLevel(CommandStack stack) {
        int level = 0;
        CommandStack st = stack.getParent();
        while (st != null) {
            if (st.getCommand() instanceof ProcInstance) {
                ++level;
            }
            st = st.getParent();
        }
        return level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCurrentState(List<StackFrame> frames) {
        Map<String, Variable> map = this.currentVariables;
        synchronized (map) {
            this.currentFrame = frames;
            this.currentVariables.clear();
            for (StackFrame stackFrame : frames) {
                EList<Variable> list = stackFrame.getVariables();
                this.storeVarIds(list);
            }
        }
    }

    private void storeVarIds(EList<Variable> list) {
        for (Variable var : list) {
            this.currentVariables.put(var.getId(), var);
            if (var.getChildren().size() <= 0) continue;
            this.storeVarIds(var.getChildren());
        }
    }

    private boolean isHitBreakpoint(StackFrame data) {
        if (this.skip) {
            return false;
        }
        String file = data.getFile();
        Set<Integer> lines = this.breakpoints.get(file);
        if (lines != null) {
            return lines.contains(data.getLine());
        }
        return false;
    }

    private void await() throws InterruptedException {
        SuspendManager.INSTANCE.fireSuspend();
        try {
            this.latch.await();
        }
        finally {
            SuspendManager.INSTANCE.fireResume();
        }
    }

    public void exit(CommandStack stack) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handle(EObject op) {
        if (op instanceof DebugCmd) {
            switch (((DebugCmd)op).getType()) {
                case SUSPEND: {
                    this.suspend();
                    break;
                }
                case RESUME: {
                    this.resume();
                    break;
                }
                case STEP: {
                    this.step();
                    break;
                }
                case STEP_OVER: {
                    this.stepOver();
                    break;
                }
                case STEP_RETURN: {
                    this.stepReturn();
                    break;
                }
                case BREAKPOINT_ADD: {
                    this.addBreakpoint((BreakpointCmd)op);
                    break;
                }
                case BREAKPOINT_REMOVE: {
                    this.removeBreakpoint((BreakpointCmd)op);
                    break;
                }
                case SKIP_ALL: {
                    this.skip = ((SkipAllCmd)op).isSkip();
                    break;
                }
                case RESOLVE_VARIABLE: {
                    Map<String, Variable> map = this.currentVariables;
                    synchronized (map) {
                        ResolveVariableCmd resolveCmd = (ResolveVariableCmd)op;
                        Variable var = this.currentVariables.get(resolveCmd.getId());
                        if (var != null) {
                            this.stackSupport.resolveVariable(var);
                        }
                        ResolveVariableEvent event = ModelFactory.eINSTANCE.createResolveVariableEvent();
                        event.setType(EventType.RESOLVE_VARIABLE);
                        event.setVariable(var);
                        if (var != null) {
                            Map<String, Variable> map2 = this.currentVariables;
                            synchronized (map2) {
                                this.storeVarIds(var.getChildren());
                            }
                        }
                        try {
                            this.request(event);
                        }
                        catch (CoreException e) {
                            CorePlugin.err((String)e.getMessage(), (Throwable)e);
                            Thread.currentThread().interrupt();
                        }
                        break;
                    }
                }
                default: {
                    throw new IllegalArgumentException("Unexpected request: " + String.valueOf(op));
                }
            }
        }
    }

    @Override
    protected void handle(Exception e) {
        Log.log(e);
    }

    private synchronized void suspend() {
        this.latch.lock();
    }

    private synchronized void resume() {
        this.step = StepKind.None;
        this.latch.unlock();
        try {
            this.request(ModelUtils.createEvent(EventType.RESUMED));
        }
        catch (CoreException e) {
            CorePlugin.err((String)e.getMessage(), (Throwable)e);
        }
    }

    private void step() {
        this.step = StepKind.Step;
        this.latch.lockAfterUnlock();
    }

    private void stepOver() {
        this.step = StepKind.StepOver;
        this.stepOverStackLevel = this.lastStackLevel;
        this.latch.lockAfterUnlock();
    }

    private void stepReturn() {
        this.step = StepKind.StepReturn;
        this.stepOverStackLevel = this.lastStackLevel;
        this.latch.lockAfterUnlock();
    }

    private void addBreakpoint(BreakpointCmd event) {
        Set<Integer> set = this.breakpoints.get(event.getPath());
        if (set == null) {
            set = new HashSet<Integer>();
            this.breakpoints.put(event.getPath(), set);
        }
        set.add(event.getLine());
    }

    private void removeBreakpoint(BreakpointCmd event) {
        Set<Integer> set = this.breakpoints.get(event.getPath());
        if (set != null) {
            set.remove(event.getLine());
        }
        if (set.isEmpty()) {
            this.breakpoints.remove(event.getPath());
        }
    }

    private static enum StepKind {
        None,
        Step,
        StepOver,
        StepReturn;

    }
}

