/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.plugin;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EAnnotationValidator;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.plugin.RegistryReader;

class AnnotationValidatorRegistryReader
extends RegistryReader {
    static final String TAG_VALIDATOR = "validator";
    static final String ATT_URI = "uri";
    static final String ATT_CLASS = "class";

    public AnnotationValidatorRegistryReader() {
        super(RegistryFactory.getRegistry(), EcorePlugin.INSTANCE.getSymbolicName(), "annotation_validator");
    }

    @Override
    protected boolean readElement(IConfigurationElement element, boolean add) {
        if (element.getName().equals(TAG_VALIDATOR)) {
            String uri = element.getAttribute(ATT_URI);
            if (uri == null) {
                this.logMissingAttribute(element, ATT_URI);
            } else if (element.getAttribute(ATT_CLASS) == null) {
                this.logMissingAttribute(element, ATT_CLASS);
            } else {
                if (add) {
                    AnnotationValidatorDescriptor previous = EAnnotationValidator.Registry.INSTANCE.put(uri, new AnnotationValidatorDescriptor(element, ATT_CLASS));
                    if (previous instanceof AnnotationValidatorDescriptor) {
                        AnnotationValidatorDescriptor descriptor = previous;
                        EcorePlugin.INSTANCE.log("Both '" + descriptor.element.getContributor().getName() + "' and '" + element.getContributor().getName() + "' register an annotation validator for '" + uri + "'");
                    }
                    return true;
                }
                EAnnotationValidator.Registry.INSTANCE.remove(uri);
                return true;
            }
        }
        return false;
    }

    static class AnnotationValidatorDescriptor
    extends RegistryReader.PluginClassDescriptor
    implements EAnnotationValidator.Descriptor {
        protected EAnnotationValidator eAnnotationValidator;

        public AnnotationValidatorDescriptor(IConfigurationElement e, String attrName) {
            super(e, attrName);
        }

        @Override
        public EAnnotationValidator getEAnnotationValidator() {
            try {
                Class javaClass = CommonPlugin.loadClass((String)this.element.getDeclaringExtension().getContributor().getName(), (String)this.element.getAttribute(this.attributeName));
                try {
                    Field field = javaClass.getField("INSTANCE");
                    Object result = field.get(null);
                    return (EAnnotationValidator)result;
                }
                catch (NoSuchFieldException e) {
                    return (EAnnotationValidator)javaClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
            }
            catch (ClassNotFoundException e) {
                throw new WrappedException((Exception)e);
            }
            catch (IllegalAccessException e) {
                throw new WrappedException((Exception)e);
            }
            catch (InstantiationException e) {
                throw new WrappedException((Exception)e);
            }
            catch (IllegalArgumentException e) {
                throw new WrappedException((Exception)e);
            }
            catch (InvocationTargetException e) {
                throw new WrappedException((Exception)e);
            }
            catch (NoSuchMethodException e) {
                throw new WrappedException((Exception)e);
            }
            catch (SecurityException e) {
                throw new WrappedException((Exception)e);
            }
        }
    }
}

