/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction.proposals;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.ui.text.correction.proposals.LinkedCorrectionProposalCore;

public class NewLocalVariableCorrectionProposalCore
extends LinkedCorrectionProposalCore {
    private ASTNode fSelectedNode;
    private ICompilationUnit fCu;

    public NewLocalVariableCorrectionProposalCore(String label, ICompilationUnit cu, ASTNode selectedNode, int relevance) {
        super(label, cu, (ASTRewrite)null, relevance);
        this.fSelectedNode = selectedNode;
        this.fCu = cu;
    }

    public boolean hasProposal() {
        Expression exp = null;
        ASTNode aSTNode = this.fSelectedNode;
        if (aSTNode instanceof ExpressionStatement) {
            ExpressionStatement expStmt = (ExpressionStatement)aSTNode;
            exp = expStmt.getExpression();
        } else {
            Expression exp1;
            ASTNode aSTNode2 = this.fSelectedNode;
            if (aSTNode2 instanceof Expression && (exp1 = (Expression)aSTNode2).getLocationInParent() == ExpressionStatement.EXPRESSION_PROPERTY) {
                exp = (Expression)this.fSelectedNode;
            }
        }
        exp = ASTNodes.getUnparenthesedExpression(exp);
        if (exp != null) {
            ITypeBinding typeBinding = exp.resolveTypeBinding();
            if (typeBinding == null) {
                if (exp instanceof CastExpression) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    @Override
    protected ASTRewrite getRewrite() throws CoreException {
        ExpressionStatement expStmt = null;
        Expression exp = null;
        if (this.fSelectedNode instanceof ExpressionStatement) {
            expStmt = (ExpressionStatement)this.fSelectedNode;
            exp = ASTNodes.getUnparenthesedExpression(expStmt.getExpression());
        } else if (this.fSelectedNode instanceof Expression && this.fSelectedNode.getLocationInParent() == ExpressionStatement.EXPRESSION_PROPERTY) {
            exp = ASTNodes.getUnparenthesedExpression((Expression)this.fSelectedNode);
            expStmt = (ExpressionStatement)this.fSelectedNode.getParent();
        }
        if (expStmt != null && exp != null) {
            AST ast = this.fSelectedNode.getAST();
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            CompilationUnit cu = (CompilationUnit)this.fSelectedNode.getRoot();
            ImportRewrite importRewrite = this.createImportRewrite(cu);
            ITypeBinding typeBinding = exp.resolveTypeBinding();
            Type type = null;
            String typeName = null;
            if (typeBinding == null) {
                if (exp instanceof CastExpression) {
                    CastExpression castExp = (CastExpression)exp;
                    type = (Type)rewrite.createCopyTarget((ASTNode)castExp.getType());
                    typeName = castExp.getType().toString();
                }
            } else {
                type = importRewrite.addImport(typeBinding, ast);
                typeName = typeBinding.getName();
            }
            if (type != null) {
                VariableDeclarationFragment vdf = ast.newVariableDeclarationFragment();
                AbstractTypeDeclaration typeDecl = ASTNodes.getFirstAncestorOrNull((ASTNode)expStmt, AbstractTypeDeclaration.class);
                IType declaringType = this.getType(this.fCu, typeDecl.getName().getFullyQualifiedName());
                String[] names = StubUtility.getVariableNameSuggestions(4, declaringType.getJavaProject(), typeName, 0, Arrays.asList(this.computeReservedIdentifiers((ASTNode)expStmt, cu)), true);
                vdf.setName(ast.newSimpleName(names[0]));
                vdf.setInitializer((Expression)rewrite.createCopyTarget((ASTNode)exp));
                VariableDeclarationStatement vdStmt = ast.newVariableDeclarationStatement(vdf);
                vdStmt.setType(type);
                rewrite.replace((ASTNode)expStmt, (ASTNode)vdStmt, null);
                return rewrite;
            }
        }
        return null;
    }

    protected IType getType(ICompilationUnit cu, String name) throws JavaModelException {
        IType[] iTypeArray = cu.getAllTypes();
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            if (type.getTypeQualifiedName('.').equals(name) || type.getElementName().equals(name)) {
                return type;
            }
            ++n2;
        }
        return null;
    }

    protected String[] computeReservedIdentifiers(ASTNode node, CompilationUnit cu) throws JavaModelException {
        ArrayList<String> names = new ArrayList<String>();
        MethodDeclaration declaration = ASTNodes.getFirstAncestorOrNull(node, MethodDeclaration.class);
        if (declaration != null) {
            List parameters = declaration.parameters();
            SingleVariableDeclaration variable = null;
            Iterator iterator = parameters.iterator();
            while (iterator.hasNext()) {
                SingleVariableDeclaration parameter;
                variable = parameter = (SingleVariableDeclaration)iterator.next();
                names.add(variable.getName().getIdentifier());
            }
            Block body = declaration.getBody();
            if (body != null) {
                IBinding[] iBindingArray = new ScopeAnalyzer(cu).getDeclarationsAfter(body.getStartPosition(), 2);
                int n = iBindingArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IBinding binding = iBindingArray[n2];
                    names.add(binding.getName());
                    ++n2;
                }
            }
        }
        String[] result = new String[names.size()];
        names.toArray(result);
        return result;
    }
}

