/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.CorrectionEngine;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.PatternInstanceofExpression;
import org.eclipse.jdt.core.dom.RecordDeclaration;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.IProposableFix;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.ProblemLocation;
import org.eclipse.jdt.ui.text.java.IProblemLocation;

public class SuppressWarningsFixCore
extends CompilationUnitRewriteOperationsFixCore {
    public final String fWarningToken;

    public SuppressWarningsFixCore(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation operation, String warningToken) {
        super(name, compilationUnit, operation);
        this.fWarningToken = warningToken;
    }

    public static IProposableFix createFix(CompilationUnit compilationUnit, ASTNode node, ChildListPropertyDescriptor property, String warningToken, String name) {
        String label = Messages.format(CorrectionMessages.SuppressWarningsSubProcessor_suppress_warnings_label, new String[]{warningToken, name});
        HashMap<ASTNode, ChildListPropertyDescriptor> nodeMap = new HashMap<ASTNode, ChildListPropertyDescriptor>();
        nodeMap.put(node, property);
        return new SuppressWarningsFixCore(label, compilationUnit, new AddNeededSuppressWarningsOperation(nodeMap, warningToken), warningToken);
    }

    public static IProposableFix createAllFix(CompilationUnit compilationUnit, Map<ASTNode, ChildListPropertyDescriptor> nodeMap, String warningToken) {
        String label = Messages.format(CorrectionMessages.SuppressWarningsSubProcessor_suppress_all_warnings_label, warningToken);
        return new SuppressWarningsFixCore(label, compilationUnit, new AddNeededSuppressWarningsOperation(nodeMap, warningToken), null);
    }

    public static IProposableFix createAllFix(CompilationUnit compilationUnit, String warningToken) {
        IProblem[] problems = compilationUnit.getProblems();
        IProblemLocation[] problemLocations = new IProblemLocation[problems.length];
        int i = 0;
        while (i < problems.length) {
            ProblemLocation location = new ProblemLocation(problems[i]);
            problemLocations[i] = location;
            ++i;
        }
        return SuppressWarningsFixCore.createAllFix(compilationUnit, problemLocations, warningToken);
    }

    public static IProposableFix createAllFix(CompilationUnit compilationUnit, IProblemLocation[] problems, String warningToken) {
        HashMap<ASTNode, ChildListPropertyDescriptor> nodeMap = new HashMap<ASTNode, ChildListPropertyDescriptor>();
        int i = 0;
        while (i < problems.length) {
            IProblemLocation location = problems[i];
            if (CorrectionEngine.getWarningToken((int)location.getProblemId()).equals(warningToken)) {
                ASTNode node = location.getCoveringNode(compilationUnit);
                ChildListPropertyDescriptor property = SuppressWarningsFixCore.getChildListPropertyDescriptor(node, warningToken);
                nodeMap.put(node, property);
            }
            ++i;
        }
        String label = Messages.format(CorrectionMessages.SuppressWarningsSubProcessor_suppress_all_warnings_label, warningToken);
        return new SuppressWarningsFixCore(label, compilationUnit, new AddNeededSuppressWarningsOperation(nodeMap, warningToken), null);
    }

    public static ChildListPropertyDescriptor getChildListPropertyDescriptor(ASTNode node, String warningToken) {
        switch (node.getNodeType()) {
            case 44: {
                if (node.getParent() instanceof PatternInstanceofExpression && warningToken.equals("preview")) {
                    return null;
                }
                return SingleVariableDeclaration.MODIFIERS2_PROPERTY;
            }
            case 60: {
                return VariableDeclarationStatement.MODIFIERS2_PROPERTY;
            }
            case 58: {
                return VariableDeclarationExpression.MODIFIERS2_PROPERTY;
            }
            case 55: {
                return TypeDeclaration.MODIFIERS2_PROPERTY;
            }
            case 103: {
                return RecordDeclaration.MODIFIERS2_PROPERTY;
            }
            case 81: {
                return AnnotationTypeDeclaration.MODIFIERS2_PROPERTY;
            }
            case 71: {
                return EnumDeclaration.MODIFIERS2_PROPERTY;
            }
            case 23: {
                return FieldDeclaration.MODIFIERS2_PROPERTY;
            }
            case 31: {
                return MethodDeclaration.MODIFIERS2_PROPERTY;
            }
            case 82: {
                return AnnotationTypeMemberDeclaration.MODIFIERS2_PROPERTY;
            }
            case 72: {
                return EnumConstantDeclaration.MODIFIERS2_PROPERTY;
            }
        }
        return null;
    }

    public String getWarningToken() {
        return this.fWarningToken;
    }

    private static class AddNeededSuppressWarningsOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private final Map<ASTNode, ChildListPropertyDescriptor> fNodeMap;
        private final String fWarningToken;

        public AddNeededSuppressWarningsOperation(Map<ASTNode, ChildListPropertyDescriptor> nodeMap, String warningToken) {
            this.fNodeMap = nodeMap;
            this.fWarningToken = warningToken;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            for (Map.Entry<ASTNode, ChildListPropertyDescriptor> location : this.fNodeMap.entrySet()) {
                Expression value;
                SingleMemberAnnotation annotation;
                ASTNode coveringNode = location.getKey();
                ChildListPropertyDescriptor property = location.getValue();
                ASTRewrite rewrite = cuRewrite.getASTRewrite();
                AST ast = rewrite.getAST();
                StringLiteral newStringLiteral = ast.newStringLiteral();
                newStringLiteral.setLiteralValue(this.fWarningToken);
                Annotation existing = AddNeededSuppressWarningsOperation.findExistingAnnotation(ASTNodes.getChildListProperty(coveringNode, property));
                if (existing == null) {
                    ListRewrite listRewrite = rewrite.getListRewrite(coveringNode, property);
                    SingleMemberAnnotation newAnnot = ast.newSingleMemberAnnotation();
                    ImportRewrite importRewrite = StubUtility.createImportRewrite((CompilationUnit)coveringNode.getRoot(), true);
                    String importString = importRewrite.addImport("java.lang.SuppressWarnings");
                    newAnnot.setTypeName(ast.newName(importString));
                    newAnnot.setValue((Expression)newStringLiteral);
                    listRewrite.insertFirst((ASTNode)newAnnot, null);
                    continue;
                }
                if (existing instanceof SingleMemberAnnotation) {
                    annotation = (SingleMemberAnnotation)existing;
                    value = annotation.getValue();
                    if (AddNeededSuppressWarningsOperation.addSuppressArgument(rewrite, value, newStringLiteral)) continue;
                    rewrite.set((ASTNode)existing, (StructuralPropertyDescriptor)SingleMemberAnnotation.VALUE_PROPERTY, (Object)newStringLiteral, null);
                    continue;
                }
                if (!(existing instanceof NormalAnnotation) || AddNeededSuppressWarningsOperation.addSuppressArgument(rewrite, value = AddNeededSuppressWarningsOperation.findValue((annotation = (NormalAnnotation)existing).values()), newStringLiteral)) continue;
                ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)annotation, NormalAnnotation.VALUES_PROPERTY);
                MemberValuePair pair = ast.newMemberValuePair();
                pair.setName(ast.newSimpleName("value"));
                pair.setValue((Expression)newStringLiteral);
                listRewrite.insertFirst((ASTNode)pair, null);
            }
        }

        private static boolean addSuppressArgument(ASTRewrite rewrite, Expression value, StringLiteral newStringLiteral) {
            if (value instanceof ArrayInitializer) {
                ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)value, ArrayInitializer.EXPRESSIONS_PROPERTY);
                listRewrite.insertLast((ASTNode)newStringLiteral, null);
            } else if (value instanceof StringLiteral) {
                ArrayInitializer newArr = rewrite.getAST().newArrayInitializer();
                newArr.expressions().add(rewrite.createMoveTarget((ASTNode)value));
                newArr.expressions().add(newStringLiteral);
                rewrite.replace((ASTNode)value, (ASTNode)newArr, null);
            } else {
                return false;
            }
            return true;
        }

        private static Expression findValue(List<MemberValuePair> keyValues) {
            for (MemberValuePair curr : keyValues) {
                if (!"value".equals(curr.getName().getIdentifier())) continue;
                return curr.getValue();
            }
            return null;
        }

        private static Annotation findExistingAnnotation(List<? extends ASTNode> modifiers) {
            for (ASTNode aSTNode : modifiers) {
                String fullyQualifiedName;
                Annotation annotation;
                ITypeBinding typeBinding;
                if (!(aSTNode instanceof NormalAnnotation) && !(aSTNode instanceof SingleMemberAnnotation) || !((typeBinding = (annotation = (Annotation)aSTNode).resolveTypeBinding()) != null ? "java.lang.SuppressWarnings".equals(typeBinding.getQualifiedName()) : "SuppressWarnings".equals(fullyQualifiedName = annotation.getTypeName().getFullyQualifiedName()) || "java.lang.SuppressWarnings".equals(fullyQualifiedName))) continue;
                return annotation;
            }
            return null;
        }
    }
}

