/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.eclipse.jdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalPositionGroupCore;

public class LinkedProposalModelCore {
    private Map<String, LinkedProposalPositionGroupCore> fPositionGroups;
    private LinkedProposalPositionGroupCore.PositionInformation fEndPosition;

    public void addPositionGroup(LinkedProposalPositionGroupCore positionGroup) {
        if (positionGroup == null) {
            throw new IllegalArgumentException("positionGroup must not be null");
        }
        if (this.fPositionGroups == null) {
            this.fPositionGroups = new HashMap<String, LinkedProposalPositionGroupCore>();
        }
        this.fPositionGroups.put(positionGroup.getGroupId(), positionGroup);
    }

    protected LinkedProposalPositionGroupCore createPositionGroup(String groupId) {
        return new LinkedProposalPositionGroupCore(groupId);
    }

    public LinkedProposalPositionGroupCore getPositionGroup(String groupId, boolean createIfNotExisting) {
        LinkedProposalPositionGroupCore group;
        LinkedProposalPositionGroupCore linkedProposalPositionGroupCore = group = this.fPositionGroups != null ? this.fPositionGroups.get(groupId) : null;
        if (createIfNotExisting && group == null) {
            group = this.createPositionGroup(groupId);
            this.addPositionGroup(group);
        }
        return group;
    }

    public Iterator<LinkedProposalPositionGroupCore> getPositionGroupCoreIterator() {
        if (this.fPositionGroups == null) {
            return new Iterator<LinkedProposalPositionGroupCore>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public LinkedProposalPositionGroupCore next() {
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return this.fPositionGroups.values().iterator();
    }

    public void setEndPosition(LinkedProposalPositionGroupCore.PositionInformation position) {
        this.fEndPosition = position;
    }

    public void setEndPosition(ITrackedNodePosition position) {
        this.setEndPosition(LinkedProposalPositionGroupCore.createPositionInformation(position, 1));
    }

    public LinkedProposalPositionGroupCore.PositionInformation getEndPosition() {
        return this.fEndPosition;
    }

    public boolean hasLinkedPositions() {
        return this.fPositionGroups != null && !this.fPositionGroups.isEmpty();
    }

    public void clear() {
        this.fPositionGroups = null;
        this.fEndPosition = null;
    }
}

