/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.beans;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.beans.IBeanSetProperty;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.property.set.DelegatingSetProperty;
import org.eclipse.core.databinding.property.set.ISetProperty;
import org.eclipse.core.internal.databinding.beans.BeanPropertyHelper;

public class AnonymousBeanSetProperty<S, E>
extends DelegatingSetProperty<S, E> {
    private final String propertyName;
    private Map<Class<S>, ISetProperty<S, E>> delegates;

    public AnonymousBeanSetProperty(String propertyName, Class<E> elementType) {
        super(elementType);
        this.propertyName = propertyName;
        this.delegates = new HashMap<Class<S>, ISetProperty<S, E>>();
    }

    protected ISetProperty<S, E> doGetDelegate(Object source) {
        IBeanSetProperty delegate;
        Class<?> beanClass = source.getClass();
        if (this.delegates.containsKey(beanClass)) {
            return this.delegates.get(beanClass);
        }
        try {
            delegate = BeanProperties.set(beanClass, this.propertyName, (Class)this.getElementType());
        }
        catch (IllegalArgumentException noSuchProperty) {
            delegate = null;
        }
        this.delegates.put(beanClass, delegate);
        return delegate;
    }

    public String toString() {
        String s = "?." + this.propertyName + "{}";
        Class elementType = (Class)this.getElementType();
        if (elementType != null) {
            s = s + "<" + BeanPropertyHelper.shortClassName(elementType) + ">";
        }
        return s;
    }
}

