/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.junit.Messages;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.jdt.internal.junit.ui.TestMethodSelectionDialog;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;

public class GotoReferencedTestAction
implements IWorkbenchWindowActionDelegate {
    ISelection fSelection;
    IWorkbenchWindow fWorkbench;

    private void run(IStructuredSelection selection) {
        IJavaElement[] elements = this.getSelectedElements(selection);
        if (elements.length == 0) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)JUnitMessages.GotoReferencedTestAction_dialog_title, (String)JUnitMessages.GotoReferencedTestAction_dialog_message);
            return;
        }
        try {
            this.run(elements);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)JUnitMessages.GotoReferencedTestAction_dialog_title, (String)JUnitMessages.GotoReferencedTestAction_dialog_error, (IStatus)e.getStatus());
        }
    }

    private void runWithEditorSelection() {
        try {
            int type;
            JavaEditor editor = this.getActiveEditor();
            if (editor == null) {
                return;
            }
            IJavaElement element = SelectionConverter.getElementAtOffset((JavaEditor)editor);
            int n = type = element != null ? element.getElementType() : -1;
            if (type != 9 && type != 7 && (element = SelectionConverter.getTypeAtOffset((JavaEditor)editor)) == null) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)JUnitMessages.GotoReferencedTestAction_dialog_title, (String)JUnitMessages.GotoReferencedTestAction_dialog_error_nomethod);
                return;
            }
            this.run((IJavaElement[])new IMember[]{(IMember)element});
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)JUnitMessages.GotoReferencedTestAction_dialog_title, (String)JUnitMessages.GotoReferencedTestAction_dialog_error, (IStatus)e.getStatus());
        }
    }

    private void run(IJavaElement[] elements) throws PartInitException, JavaModelException {
        IJavaElement element = elements[0];
        TestMethodSelectionDialog dialog = new TestMethodSelectionDialog(this.getShell(), element);
        dialog.setTitle(JUnitMessages.GotoReferencedTestAction_selectdialog_title);
        String msg = Messages.format((String)JUnitMessages.GotoReferencedTestAction_dialog_select_message, (Object)JavaElementLabels.getElementLabel((IJavaElement)element, (long)0x200009L));
        dialog.setMessage(msg);
        if (dialog.open() == 1) {
            return;
        }
        Object result = dialog.getFirstResult();
        if (result == null) {
            return;
        }
        this.openElement((IJavaElement)result);
    }

    private void openElement(IJavaElement result) throws JavaModelException, PartInitException {
        IEditorPart part = JavaUI.openInEditor((IJavaElement)result);
        JavaUI.revealInEditor((IEditorPart)part, (IJavaElement)result);
    }

    private IJavaElement[] getSelectedElements(IStructuredSelection selection) {
        List elements = selection.toList();
        int size = elements.size();
        if (size == 0) {
            return new IJavaElement[0];
        }
        ArrayList<Object> result = new ArrayList<Object>(size);
        int i = 0;
        while (i < size) {
            Object e = elements.get(i);
            if (e instanceof ICompilationUnit) {
                ICompilationUnit unit = (ICompilationUnit)e;
                IType[] types = new IType[]{};
                try {
                    types = unit.getTypes();
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
                result.addAll(Arrays.asList(types));
            } else if (e instanceof IMethod || e instanceof IType || e instanceof IField) {
                result.add((IMember)e);
            } else {
                return new IJavaElement[0];
            }
            ++i;
        }
        return result.toArray(new IJavaElement[result.size()]);
    }

    public void run(IAction action) {
        if (this.fSelection instanceof IStructuredSelection) {
            this.run((IStructuredSelection)this.fSelection);
        } else {
            this.runWithEditorSelection();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = selection;
        action.setEnabled(this.getActiveEditor() != null);
    }

    private Shell getShell() {
        if (this.fWorkbench != null) {
            return this.fWorkbench.getShell();
        }
        return JUnitPlugin.getActiveWorkbenchShell();
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.fWorkbench = window;
    }

    private JavaEditor getActiveEditor() {
        IEditorPart editor = this.fWorkbench.getActivePage().getActiveEditor();
        if (editor instanceof JavaEditor) {
            return (JavaEditor)editor;
        }
        return null;
    }
}

