/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.base.conditions.evaluation;

import java.time.ZonedDateTime;
import java.util.Objects;
import org.eclipse.passage.lic.api.LicensedProduct;
import org.eclipse.passage.lic.api.conditions.Condition;
import org.eclipse.passage.lic.api.conditions.ConditionOrigin;
import org.eclipse.passage.lic.api.conditions.evaluation.Permission;

public final class BasePermission
implements Permission {
    private final LicensedProduct product;
    private final Condition condition;
    private final ZonedDateTime lease;
    private final ZonedDateTime expiration;
    private final ConditionOrigin origin;

    public BasePermission(LicensedProduct product, Condition condition, ZonedDateTime lease, ZonedDateTime expiration, ConditionOrigin origin) {
        Objects.requireNonNull(product, "BasePermission::product");
        Objects.requireNonNull(condition, "BasePermission::condition");
        Objects.requireNonNull(lease, "BasePermission::lease");
        Objects.requireNonNull(expiration, "BasePermission::expiration");
        Objects.requireNonNull(origin, "BasePermission::conditionOrigin");
        if (!lease.isBefore(expiration)) {
            throw new IllegalArgumentException("`Lease` date must strictly less than `expriation` date.");
        }
        this.product = product;
        this.condition = condition;
        this.lease = lease;
        this.expiration = expiration;
        this.origin = origin;
    }

    public LicensedProduct product() {
        return this.product;
    }

    public Condition condition() {
        return this.condition;
    }

    public ZonedDateTime leaseDate() {
        return this.lease;
    }

    public ZonedDateTime expireDate() {
        return this.expiration;
    }

    public ConditionOrigin conditionOrigin() {
        return this.origin;
    }
}

