/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.engine.phases;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.security.cert.Certificate;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.engine.EngineActivator;
import org.eclipse.equinox.internal.p2.engine.Messages;
import org.eclipse.equinox.p2.core.IAgentLocation;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.UIServices;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.ProfileScope;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.repository.metadata.spi.IInstallableUnitUIServices;
import org.osgi.service.prefs.BackingStoreException;

public class AuthorityChecker {
    public static final String TRUST_ALL_AUTHORITIES = "trustAllAuthorities";
    public static final String TRUSTED_AUTHORITIES_PROPERTY = "trustedAuthorities";
    private static final Pattern ARCHIVE_URI_PATTERN = Pattern.compile("(?i)(jar|zip|archive):(.*)?/(.*)");
    private static final Pattern HIERARCHICAL_URI_PATTERN = Pattern.compile("((?:[^/:]+):(?://[^/]+|///|/)?)([^?#]*)([#?].*)?");
    private final int requestTimeoutMillis;
    private final int maxRequestRetries;
    private final IProvisioningAgent agent;
    private final ProvisioningContext context;
    private final IProfile profile;
    private final Collection<? extends IInstallableUnit> ius;
    private final Collection<? extends IArtifactKey> artifacts;

    public AuthorityChecker(IProvisioningAgent agent, IProfile profile) {
        this(agent, null, List.of(), List.of(), profile);
    }

    AuthorityChecker(IProvisioningAgent agent, ProvisioningContext context, Collection<? extends IInstallableUnit> ius, Collection<? extends IArtifactKey> artifacts, IProfile profile) {
        this.agent = agent;
        this.context = context;
        this.ius = ius;
        this.artifacts = artifacts;
        this.profile = profile;
        this.requestTimeoutMillis = agent.getIntProperty("org.eclipse.equinox.p2.engine.certificateRequestTimeout", 5000);
        this.maxRequestRetries = agent.getIntProperty("org.eclipse.equinox.p2.engine.certificateRequestRetries", 3);
    }

    IStatus start(IProgressMonitor monitor) {
        if (this.isTrustAlways()) {
            return Status.OK_STATUS;
        }
        UIServices uiServices = (UIServices)this.agent.getService(UIServices.class);
        if (uiServices instanceof IInstallableUnitUIServices) {
            IInstallableUnitUIServices installableUnitUIServices = (IInstallableUnitUIServices)uiServices;
            Map<URI, Set<IInstallableUnit>> iuSources = this.context.getInstallableUnitSources(this.ius, monitor);
            Map<URI, Set<IArtifactKey>> artifactSources = this.context.getArtifactSources(this.artifacts, monitor);
            LinkedHashMap artifactKeyIUs = new LinkedHashMap();
            iuSources.values().stream().flatMap(Collection::stream).forEach(iu -> {
                for (IArtifactKey key : iu.getArtifacts()) {
                    artifactKeyIUs.computeIfAbsent(key, it -> new HashSet()).add(iu);
                }
            });
            for (Map.Entry<URI, Set<IArtifactKey>> entry : artifactSources.entrySet()) {
                URI location = entry.getKey();
                for (IArtifactKey artifact : entry.getValue()) {
                    Set artifactIUs = (Set)artifactKeyIUs.get(artifact);
                    if (artifactIUs == null) continue;
                    iuSources.computeIfAbsent(location, it -> new TreeSet()).addAll(artifactIUs);
                }
            }
            Set<URI> preferenceTrustedAuthorities = this.getPreferenceTrustedAuthorities();
            TreeSet<URI> allTrustedAuthorities = new TreeSet<URI>(preferenceTrustedAuthorities);
            iuSources.keySet().removeIf(source -> {
                for (URI uri : AuthorityChecker.getAuthorityChain(source)) {
                    if ("file".equalsIgnoreCase(uri.getScheme())) {
                        return true;
                    }
                    if (!allTrustedAuthorities.contains(uri)) continue;
                    return true;
                }
                return false;
            });
            Map<URI, List<Certificate>> certificates = this.getCertificates(iuSources.keySet(), monitor);
            IInstallableUnitUIServices.TrustAuthorityInfo trustInfo = installableUnitUIServices.getTrustAuthorityInfo(iuSources, certificates);
            this.setTrustAlways(trustInfo.isTrustAlways());
            if (!this.isTrustAlways()) {
                if (trustInfo.isSave()) {
                    preferenceTrustedAuthorities.addAll(trustInfo.getTrustedAuthorities());
                    this.persistTrustedAuthorities(preferenceTrustedAuthorities);
                }
                Collection trustedAuthorities = trustInfo.getTrustedAuthorities();
                iuSources.keySet().removeIf(source -> {
                    for (URI uri : AuthorityChecker.getAuthorityChain(source)) {
                        if (!trustedAuthorities.contains(uri)) continue;
                        return true;
                    }
                    return false;
                });
                if (!iuSources.isEmpty()) {
                    return new Status(8, "org.eclipse.equinox.p2.engine", Messages.AuthorityChecker_UntrustedAuthorities);
                }
            }
        }
        return Status.OK_STATUS;
    }

    public boolean isTrustAlways() {
        IEclipsePreferences preferences = this.getEnngineProfilePreferences();
        if (preferences != null) {
            return preferences.getBoolean(TRUST_ALL_AUTHORITIES, false);
        }
        return false;
    }

    public IStatus setTrustAlways(boolean trustAlways) {
        IEclipsePreferences preferences = this.getEnngineProfilePreferences();
        if (preferences != null) {
            try {
                preferences.putBoolean(TRUST_ALL_AUTHORITIES, trustAlways);
                preferences.flush();
            }
            catch (BackingStoreException ex) {
                return new Status(4, "org.eclipse.equinox.p2.engine", ex.getMessage(), (Throwable)ex);
            }
        }
        return Status.OK_STATUS;
    }

    public Set<URI> getPreferenceTrustedAuthorities() {
        LinkedHashSet<URI> result = new LinkedHashSet<URI>();
        IEclipsePreferences preferences = this.getEnngineProfilePreferences();
        if (preferences != null) {
            String defaultValue = EngineActivator.getProperty("p2.trustedAuthorities", this.agent);
            defaultValue = defaultValue == null ? "https://download.eclipse.org https://archive.eclipse.org" : defaultValue.replace(',', ' ');
            String[] stringArray = preferences.get(TRUSTED_AUTHORITIES_PROPERTY, defaultValue).split("\\s+");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                try {
                    if (!value.isBlank()) {
                        result.add(new URI(value));
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
                ++n2;
            }
        }
        return result;
    }

    public IStatus persistTrustedAuthorities(Collection<? extends URI> trustedAuthorities) {
        IEclipsePreferences preferences = this.getEnngineProfilePreferences();
        if (preferences != null) {
            try {
                preferences.put(TRUSTED_AUTHORITIES_PROPERTY, String.join((CharSequence)" ", AuthorityChecker.getFilteredAuthorities(trustedAuthorities).stream().map(URI::toString).collect(Collectors.toList())));
                preferences.flush();
            }
            catch (BackingStoreException ex) {
                return new Status(4, "org.eclipse.equinox.p2.engine", ex.getMessage(), (Throwable)ex);
            }
        }
        return Status.OK_STATUS;
    }

    public IEclipsePreferences getEnngineProfilePreferences() {
        if (this.profile != null) {
            ProfileScope profileScope = new ProfileScope((IAgentLocation)this.agent.getService(IAgentLocation.class), this.profile.getProfileId());
            return profileScope.getNode("org.eclipse.equinox.p2.engine");
        }
        return null;
    }

    public static List<URI> getFilteredAuthorities(Collection<? extends URI> authorities) {
        ArrayList<URI> filteredAuthorities = new ArrayList<URI>(authorities);
        filteredAuthorities.removeIf(uri -> {
            for (URI authority : AuthorityChecker.getAuthorityChain(uri)) {
                if (authority.equals(uri) || !authorities.contains(authority)) continue;
                return true;
            }
            return false;
        });
        return filteredAuthorities;
    }

    public Map<URI, List<Certificate>> getCertificates(Collection<? extends URI> uris, IProgressMonitor monitor) {
        TreeMap<URI, List<Certificate>> certificates = new TreeMap<URI, List<Certificate>>();
        TreeMap<URI, List<Certificate>> authorities = new TreeMap<URI, List<Certificate>>();
        for (URI uRI : uris) {
            URI authorityURI = AuthorityChecker.getAuthorityChain(uRI).get(0);
            certificates.put(uRI, authorities.computeIfAbsent(authorityURI, it -> new ArrayList()));
        }
        this.gatherCertificates(authorities, monitor);
        return certificates;
    }

    public void gatherCertificates(Map<URI, List<Certificate>> authorities, IProgressMonitor montior) {
        HttpClient client = HttpClient.newBuilder().build();
        Map requests = authorities.keySet().stream().collect(Collectors.toMap(Function.identity(), uri -> {
            try {
                HttpRequest request = HttpRequest.newBuilder().uri((URI)uri).timeout(Duration.ofMillis(this.requestTimeoutMillis)).method("HEAD", HttpRequest.BodyPublishers.noBody()).build();
                return Optional.of(AuthorityChecker.sendHttpRequestOrRetry(client, request, this.maxRequestRetries));
            }
            catch (RuntimeException ex) {
                return Optional.ofNullable(null);
            }
        }));
        for (Map.Entry<URI, List<Certificate>> entry : authorities.entrySet()) {
            if (montior.isCanceled()) {
                return;
            }
            requests.get(entry.getKey()).ifPresent(httpResponse -> {
                try {
                    ((HttpResponse)httpResponse.get()).sslSession().ifPresent(sslSession -> {
                        try {
                            Certificate[] peerCertificates = sslSession.getPeerCertificates();
                            ((List)entry.getValue()).addAll(Arrays.asList(peerCertificates));
                        }
                        catch (SSLPeerUnverifiedException e) {
                            LogHelper.log((IStatus)new Status(2, "org.eclipse.equinox.p2.engine", Messages.AuthorityChecker_GatherCertificatesFailure, (Throwable)e));
                        }
                    });
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (RuntimeException | ExecutionException e) {
                    LogHelper.log((IStatus)new Status(2, "org.eclipse.equinox.p2.engine", Messages.AuthorityChecker_GatherCertificatesFailure, (Throwable)e));
                }
            });
        }
    }

    private static CompletableFuture<HttpResponse<String>> sendHttpRequestOrRetry(HttpClient client, HttpRequest request, int retriesLeft) {
        CompletionStage<HttpResponse<String>> future = client.sendAsync(request, HttpResponse.BodyHandlers.ofString());
        if (retriesLeft > 1) {
            future = future.exceptionallyComposeAsync(e -> AuthorityChecker.sendHttpRequestOrRetry(client, request, retriesLeft - 1));
        }
        return future;
    }

    public static List<URI> getAuthorityChain(URI location) {
        ArrayList<URI> result = new ArrayList<URI>();
        if (location.isOpaque()) {
            Matcher matcher = ARCHIVE_URI_PATTERN.matcher(location.toString());
            if (matcher.matches()) {
                result.addAll(AuthorityChecker.getAuthorityChain(URI.create(matcher.group(2))));
            }
        } else {
            String scheme = location.getScheme();
            if (scheme != null) {
                try {
                    Matcher matcher = HIERARCHICAL_URI_PATTERN.matcher(location.toString());
                    if (matcher.matches()) {
                        String authority = matcher.group(1);
                        String path = matcher.group(2);
                        String tail = matcher.group(3);
                        if (path != null && !path.isEmpty() || tail != null) {
                            URI uri = new URI(authority);
                            result.add(uri);
                            int length = path.length();
                            int index = path.indexOf(47, 1);
                            while (index != -1 && (index == 1 || ++index != length)) {
                                String segment = path.substring(0, index);
                                URI uri2 = new URI(authority + segment);
                                result.add(uri2);
                                index = path.indexOf(47, index + 1);
                            }
                            if (tail != null) {
                                URI uri2 = new URI(authority + path);
                                result.add(uri2);
                            }
                        }
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
        }
        result.add(location);
        return result;
    }
}

