/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.commands.ICommandImageService;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.commands.CommandImageManager;
import org.eclipse.ui.internal.commands.CommandImagePersistence;

public final class CommandImageService
implements ICommandImageService {
    private final CommandImageManager commandImageManager;
    private final CommandImagePersistence commandImagePersistence;

    public CommandImageService(CommandImageManager commandImageManager, ICommandService commandService) {
        if (commandImageManager == null) {
            throw new NullPointerException("Cannot create a command image service with a null manager");
        }
        if (commandService == null) {
            throw new NullPointerException("Cannot create a command image service with a null command service");
        }
        this.commandImageManager = commandImageManager;
        this.commandImagePersistence = new CommandImagePersistence(commandImageManager, commandService);
    }

    public void bind(String commandId, int type, String style, ImageDescriptor descriptor) {
        this.commandImageManager.bind(commandId, type, style, descriptor);
    }

    public void bind(String commandId, int type, String style, URL url) {
        this.commandImageManager.bind(commandId, type, style, url);
    }

    @Override
    public void dispose() {
        this.commandImagePersistence.dispose();
    }

    public String generateUnusedStyle(String commandId) {
        return this.commandImageManager.generateUnusedStyle(commandId);
    }

    @Override
    public ImageDescriptor getImageDescriptor(String commandId) {
        return this.commandImageManager.getImageDescriptor(commandId);
    }

    @Override
    public ImageDescriptor getImageDescriptor(String commandId, int type) {
        return this.commandImageManager.getImageDescriptor(commandId, type);
    }

    @Override
    public ImageDescriptor getImageDescriptor(String commandId, int type, String style) {
        return this.commandImageManager.getImageDescriptor(commandId, type, style);
    }

    @Override
    public ImageDescriptor getImageDescriptor(String commandId, String style) {
        return this.commandImageManager.getImageDescriptor(commandId, style);
    }

    public void readRegistry() {
        this.commandImagePersistence.read();
    }
}

