/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.storage.url;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Objects;
import org.eclipse.equinox.plurl.PlurlStreamHandlerBase;
import org.eclipse.osgi.container.Module;
import org.eclipse.osgi.container.ModuleContainer;
import org.eclipse.osgi.internal.messages.Msg;
import org.eclipse.osgi.storage.bundlefile.BundleEntry;
import org.eclipse.osgi.storage.url.BundleURLConnection;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.Bundle;

public abstract class BundleResourceHandler
extends PlurlStreamHandlerBase {
    public static final String OSGI_RESOURCE_URL_PROTOCOL = "bundleresource";
    public static final String OSGI_ENTRY_URL_PROTOCOL = "bundleentry";
    public static final String SECURITY_CHECKED = "SECURITY_CHECKED";
    public static final String SECURITY_UNCHECKED = "SECURITY_UNCHECKED";
    public static final String BID_FWKID_SEPARATOR = ".fwk";
    protected final ModuleContainer container;
    protected BundleEntry bundleEntry;

    protected BundleResourceHandler(ModuleContainer container, BundleEntry bundleEntry) {
        this.container = container;
        this.bundleEntry = bundleEntry;
    }

    @Override
    protected void parseURL(URL url, String str, int start, int end) {
        int dotIndex;
        if (end < start) {
            return;
        }
        if (url.getPath() != null) {
            this.bundleEntry = null;
        }
        String spec = "";
        if (start < end) {
            spec = str.substring(start, end);
        }
        end -= start;
        String path = url.getPath();
        String host = url.getHost();
        int resIndex = url.getPort();
        if (resIndex < 0) {
            resIndex = 0;
        }
        int pathIdx = 0;
        if (spec.startsWith("//")) {
            int bundleIdEnd;
            int bundleIdIdx = 2;
            pathIdx = spec.indexOf(47, bundleIdIdx);
            if (pathIdx == -1) {
                pathIdx = end;
                path = "";
            }
            if ((bundleIdEnd = spec.indexOf(58, bundleIdIdx)) > pathIdx || bundleIdEnd == -1) {
                bundleIdEnd = pathIdx;
            }
            if (bundleIdEnd < pathIdx - 1) {
                try {
                    resIndex = Integer.parseInt(spec.substring(bundleIdEnd + 1, pathIdx));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            host = spec.substring(bundleIdIdx, bundleIdEnd);
        }
        String query = url.getQuery();
        String ref = url.getRef();
        int queryIdx = spec.indexOf(63, pathIdx);
        int fragmentIdx = spec.indexOf(35, pathIdx);
        int pathEnd = end;
        if (fragmentIdx >= 0 && fragmentIdx < pathEnd) {
            ref = spec.substring(fragmentIdx + 1, end);
            pathEnd = fragmentIdx;
        }
        if (queryIdx >= 0 && queryIdx < pathEnd) {
            query = spec.substring(queryIdx + 1, pathEnd);
            pathEnd = queryIdx;
        }
        if (pathIdx < pathEnd && spec.charAt(pathIdx) == '/') {
            path = spec.substring(pathIdx, pathEnd);
        } else if (pathEnd > pathIdx) {
            int last;
            if (path == null || path.equals("")) {
                path = "/";
            }
            path = (last = path.lastIndexOf(47) + 1) == 0 ? spec.substring(pathIdx, pathEnd) : String.valueOf(path.substring(0, last)) + spec.substring(pathIdx, pathEnd);
        }
        if (path == null) {
            path = "";
        }
        if (path.endsWith("/.") || path.endsWith("/..")) {
            path = String.valueOf(path) + '/';
        }
        while ((dotIndex = path.indexOf("/./")) >= 0) {
            path = String.valueOf(path.substring(0, dotIndex + 1)) + path.substring(dotIndex + 3);
        }
        while ((dotIndex = path.indexOf("/../")) >= 0) {
            path = dotIndex != 0 ? String.valueOf(path.substring(0, path.lastIndexOf(47, dotIndex - 1))) + path.substring(dotIndex + 3) : path.substring(dotIndex + 3);
        }
        while ((dotIndex = path.indexOf("//")) >= 0) {
            path = String.valueOf(path.substring(0, dotIndex + 1)) + path.substring(dotIndex + 2);
        }
        String authorized = SECURITY_UNCHECKED;
        long bundleId = BundleResourceHandler.parseBundleIDFromURLHost(host);
        Module module = this.getModule(bundleId);
        if (this.checkAuthorization(module)) {
            authorized = SECURITY_CHECKED;
        }
        host = BundleResourceHandler.createURLHostForBundleID(this.container, bundleId);
        this.setURL(url, url.getProtocol(), host, resIndex, authorized, null, path, query, ref);
    }

    private Module getModule(long id) {
        return this.container.getModule(id);
    }

    @Override
    public URLConnection openConnection(URL url) throws IOException {
        long bundleID;
        if (this.bundleEntry != null) {
            return new BundleURLConnection(url, this.container, this.bundleEntry);
        }
        String host = url.getHost();
        if (host == null) {
            throw new IOException(NLS.bind(Msg.URL_NO_BUNDLE_ID, url.toExternalForm()));
        }
        try {
            bundleID = BundleResourceHandler.parseBundleIDFromURLHost(host);
        }
        catch (NumberFormatException nfe) {
            throw (MalformedURLException)new MalformedURLException(NLS.bind(Msg.URL_INVALID_BUNDLE_ID, host)).initCause(nfe);
        }
        Module module = this.getModule(bundleID);
        if (module == null) {
            throw new IOException(NLS.bind(Msg.URL_NO_BUNDLE_FOUND, url.toExternalForm()));
        }
        if (!url.getAuthority().equals(SECURITY_CHECKED)) {
            this.checkAuthorization(module);
        }
        return new BundleURLConnection(url, this.container, this.findBundleEntry(url, module));
    }

    protected abstract BundleEntry findBundleEntry(URL var1, Module var2) throws IOException;

    @Override
    public String toExternalForm(URL url) {
        String ref;
        String query;
        String path;
        int index;
        StringBuilder result = new StringBuilder(url.getProtocol());
        result.append("://");
        String host = url.getHost();
        if (host != null && host.length() > 0) {
            result.append(host);
        }
        if ((index = url.getPort()) > 0) {
            result.append(':').append(index);
        }
        if ((path = url.getPath()) != null) {
            if (path.length() > 0 && path.charAt(0) != '/') {
                result.append("/");
            }
            result.append(path);
        }
        if ((query = url.getQuery()) != null && query.length() > 0) {
            result.append('?').append(query);
        }
        if ((ref = url.getRef()) != null && ref.length() > 0) {
            result.append('#').append(ref);
        }
        return result.toString();
    }

    @Override
    public int hashCode(URL url) {
        String host;
        int hash = 0;
        String protocol = url.getProtocol();
        if (protocol != null) {
            hash += protocol.hashCode();
        }
        if ((host = url.getHost()) != null) {
            hash += host.hashCode();
        }
        hash += url.getPort();
        String path = url.getPath();
        if (path != null) {
            hash += path.hashCode();
        }
        return hash += this.container.hashCode();
    }

    @Override
    public boolean equals(URL url1, URL url2) {
        return this.sameFile(url1, url2);
    }

    @Override
    public synchronized InetAddress getHostAddress(URL url) {
        return null;
    }

    @Override
    public boolean hostsEqual(URL url1, URL url2) {
        return BundleResourceHandler.equalsIgnoreCase(url1.getHost(), url2.getHost());
    }

    @Override
    public boolean sameFile(URL url1, URL url2) {
        if (url1.hashCode() != url2.hashCode()) {
            return false;
        }
        return BundleResourceHandler.equalsIgnoreCase(url1.getProtocol(), url2.getProtocol()) && this.hostsEqual(url1, url2) && url1.getPort() == url2.getPort() && Objects.equals(url1.getPath(), url2.getPath());
    }

    protected boolean checkAuthorization(Module module) {
        Bundle moduleBundle;
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return true;
        }
        Bundle bundle = moduleBundle = module == null ? null : module.getBundle();
        if (moduleBundle == null) {
            return false;
        }
        sm.checkPermission(new AdminPermission(moduleBundle, "resource"));
        return true;
    }

    private static boolean equalsIgnoreCase(String s1, String s2) {
        return s1 != null ? s1.equalsIgnoreCase(s2) : s2 == null;
    }

    public static String createURLHostForBundleID(ModuleContainer container, long bundleId) {
        return String.valueOf(bundleId) + BID_FWKID_SEPARATOR + container.hashCode();
    }

    static long parseBundleIDFromURLHost(String host) {
        int dotIndex = host.indexOf(BID_FWKID_SEPARATOR);
        return dotIndex >= 0 && dotIndex < host.length() - 1 ? Long.parseLong(host.substring(0, dotIndex)) : Long.parseLong(host);
    }
}

