/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.concurrent;

import java.util.concurrent.atomic.AtomicMarkableReference;
import org.apache.hc.core5.concurrent.Cancellable;
import org.apache.hc.core5.concurrent.CancellableDependency;
import org.apache.hc.core5.util.Args;

public final class ComplexCancellable
implements CancellableDependency {
    private final AtomicMarkableReference<Cancellable> dependencyRef = new AtomicMarkableReference<Object>(null, false);

    @Override
    public boolean isCancelled() {
        return this.dependencyRef.isMarked();
    }

    @Override
    public void setDependency(Cancellable dependency) {
        Args.notNull(dependency, "dependency");
        while (!this.dependencyRef.compareAndSet(this.dependencyRef.getReference(), dependency, false, false)) {
            if (!this.dependencyRef.isMarked()) continue;
            dependency.cancel();
            return;
        }
    }

    @Override
    public boolean cancel() {
        while (!this.dependencyRef.isMarked()) {
            Cancellable actualDependency = this.dependencyRef.getReference();
            if (!this.dependencyRef.compareAndSet(actualDependency, actualDependency, false, true)) continue;
            if (actualDependency != null) {
                actualDependency.cancel();
            }
            return true;
        }
        return false;
    }
}

