/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.Optional;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSOpenPanel;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSURL;
import org.eclipse.swt.internal.cocoa.NSWindow;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DirectoryDialog
extends Dialog {
    Callback callback_performKeyEquivalent;
    Callback completion_handler_callback;
    NSOpenPanel panel;
    String directoryPath;
    String message = "";
    String filterPath = "";
    long method_performKeyEquivalent = 0L;
    long methodImpl_performKeyEquivalent = 0L;

    public DirectoryDialog(Shell parent) {
        this(parent, 65536);
    }

    public DirectoryDialog(Shell parent, int style) {
        super(parent, DirectoryDialog.checkStyle(parent, style));
        if (Display.getSheetEnabled() && parent != null && (style & 0x10000000) != 0) {
            this.style |= 0x10000000;
        }
        this.checkSubclass();
    }

    long _completionHandler(long result) {
        this.handleResponse(result);
        return result;
    }

    long _performKeyEquivalent(long id2, long sel, long event) {
        boolean result = false;
        NSEvent nsEvent = new NSEvent(event);
        NSWindow window = nsEvent.window();
        if (window != null) {
            result = this.parent.display.performKeyEquivalent(window, nsEvent);
        }
        return result ? 1 : 0;
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public String getMessage() {
        return this.message;
    }

    void handleResponse(long response) {
        if (this.parent != null && (this.style & 0x10000000) != 0) {
            NSApplication.sharedApplication().stopModal();
        }
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        display.setModalDialog(null);
        this.directoryPath = null;
        if (response == 1L) {
            NSString filename = this.panel.filename();
            this.directoryPath = this.filterPath = filename.getString();
        }
        this.releaseHandles();
        if (response != 1L && response != 0L) {
            throw new SWTException(51);
        }
    }

    public String open() {
        try {
            return this.openDialog().orElse(null);
        }
        catch (SWTException e) {
            if (e.code == 51) {
                return null;
            }
            throw e;
        }
    }

    public Optional<String> openDialog() {
        this.directoryPath = null;
        this.panel = NSOpenPanel.openPanel();
        if (this.panel == null) {
            throw new SWTException(51);
        }
        this.callback_performKeyEquivalent = new Callback(this, "_performKeyEquivalent", 3);
        long proc = this.callback_performKeyEquivalent.getAddress();
        this.method_performKeyEquivalent = OS.class_getInstanceMethod(OS.class_NSSavePanel, OS.sel_performKeyEquivalent_);
        if (this.method_performKeyEquivalent != 0L) {
            this.methodImpl_performKeyEquivalent = OS.method_setImplementation(this.method_performKeyEquivalent, proc);
        }
        this.panel.setCanCreateDirectories(true);
        this.panel.setAllowsMultipleSelection((this.style & 2) != 0);
        this.panel.setTitle(NSString.stringWith(this.title != null ? this.title : ""));
        this.panel.setMessage(NSString.stringWith(this.message != null ? this.message : ""));
        this.panel.setCanChooseFiles(false);
        this.panel.setCanChooseDirectories(true);
        this.panel.setTreatsFilePackagesAsDirectories(true);
        NSString dir = this.filterPath != null && this.filterPath.length() > 0 ? NSString.stringWith(this.filterPath) : null;
        this.panel.setDirectoryURL(NSURL.fileURLWithPath(dir));
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        display.setModalDialog(this, this.panel);
        if (this.parent != null && (this.style & 0x10000000) != 0) {
            this.completion_handler_callback = new Callback(this, "_completionHandler", 1);
            long handler = this.completion_handler_callback.getAddress();
            OS.beginSheetModalForWindow(this.panel, this.parent.view.window(), handler);
            NSApplication.sharedApplication().runModalForWindow(this.parent.view.window());
        } else {
            long response = this.panel.runModal();
            this.handleResponse(response);
        }
        return Optional.ofNullable(this.directoryPath);
    }

    void releaseHandles() {
        if (this.method_performKeyEquivalent != 0L) {
            OS.method_setImplementation(this.method_performKeyEquivalent, this.methodImpl_performKeyEquivalent);
        }
        if (this.callback_performKeyEquivalent != null) {
            this.callback_performKeyEquivalent.dispose();
        }
        this.callback_performKeyEquivalent = null;
        if (this.completion_handler_callback != null) {
            this.completion_handler_callback.dispose();
            this.completion_handler_callback = null;
        }
        this.panel = null;
    }

    public void setMessage(String string) {
        if (string == null) {
            this.error(4);
        }
        this.message = string;
    }

    public void setFilterPath(String string) {
        this.filterPath = string;
    }
}

